/***************************************************************************
 *
 * knetworkmanager-devicestore_dbus.h - A NetworkManager frontend for KDE
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef KNETWORKMANAGER_CONNECTION_SETTING_INFO_H
#define KNETWORKMANAGER_CONNECTION_SETTING_INFO_H

#include <stdint.h>
#include <qhostaddress.h>
#include <qmap.h>
#include <qvariant.h>
#include <qobject.h>
#include <qdatetime.h>

#include <dbus/qdbusdata.h>
#include "knetworkmanager-connection_setting.h"

/* NM headers */
#include <nm-setting-connection.h>

namespace ConnectionSettings
{

// info setting
class Info : public ConnectionSetting
{
	public:
		Info(Connection* conn, QString devtype = QString::null, const QString& name = QString::null, bool autoconnect = false);

		SettingsMap toMap() const;
		void        fromMap(const SettingsMap&);

		QString     getDevType() const;
		void        setDevType(const QString&);

		QString     getName() const;
		void        setName(const QString&);

		bool        getAutoconnect() const;
		void        setAutoconnect(bool);

		QDateTime   getTimestamp() const;
		void        setTimestamp(const QDateTime&);

		QString     getUUID() const;
		void        setUUID(const QString&);

		bool        isValid() const;

	private:
		QString    _name;
		QString    _devtype;
		bool       _autoconnect;
		QDateTime  _timestamp;
		QString    _uuid;
};

}
#endif /* KNETWORKMANAGER_CONNECTION_SETTING_INFO_H */
