/***************************************************************************
 *
 * knetworkmanager-connection_setting_gsm.h - A NetworkManager frontend for KDE
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef KNETWORKMANAGER_CONNECTION_SETTING_GSM_H
#define KNETWORKMANAGER_CONNECTION_SETTING_GSM_H

#include <stdint.h>
#include <qhostaddress.h>
#include <qmap.h>
#include <qvariant.h>
#include <qobject.h>

#include <dbus/qdbusdata.h>

#include "knetworkmanager-connection_setting.h"

/* NM headers */
#include <nm-setting-gsm.h>

namespace ConnectionSettings
{

class Connection;

// serial setting
class GSM : public ConnectionSetting
{
	public:
		GSM(Connection* conn);

		SettingsMap toMap() const;
		SettingsMap toSecretsMap(bool with_settings = true) const;
		void        fromMap(const SettingsMap&);
		bool        fromSecretsMap(const SettingsMap&);

		bool     isValid() const;
		bool     useSetting();

		void     setNumber(const QString&);
		QString  getNumber() const;

		void     setUsername(const QString&);
		QString  getUsername() const;

		void     setPassword(const QString&);
		QString  getPassword() const;

		void     setAPN(const QString&);
		QString  getAPN() const;

		void     setNetworkID(const QString&);
		QString  getNetworkID() const;

		void     setNetworkType(int);
		int      getNetworkType() const;

		void     setBand(int);
		int      getBand() const;

		void     setPin(const QString&);
		QString  getPin() const;

		void     setPuk(const QString&);
		QString  getPuk() const;

	private:
		QString _number;
		QString _username;
		QString _password;
		QString _apn;
		QString _network_id;
		int     _network_type;
		int     _band;
		QString _pin;
		QString _puk;
};
}
#endif /* KNETWORKMANAGER_CONNECTION_SETTING_CDMA_H */
