/***************************************************************************
 *
 * knetworkmanager-cellular_device_tray.cpp - A NetworkManager frontend for KDE
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Helmut Schaa       <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

/// Qt includes
#include <qwidget.h> // for Qt::WidgetFlags

// KDE includes
#include <kdebug.h>
#include <klocale.h>
#include <kiconloader.h>

// Qt DBus
#include <dbus/qdbusobjectpath.h>


// KNM includes
#include "knetworkmanager-cellular_device_tray.h"
#include "knetworkmanager-cellular_device.h"
#include "knetworkmanager-menuitem.h"
#include "knetworkmanager-menu_subhead.h"
#include "knetworkmanager-connection_store.h"
#include "knetworkmanager-cdma_connection.h"
#include "knetworkmanager-gsm_connection.h"
#include "knetworkmanager-nm_proxy.h"

#include "knetworkmanager-connection_setting_info.h"
#include "knetworkmanager-connection_setting_ipv4.h"
#include "knetworkmanager-connection_setting_cdma.h"
#include "knetworkmanager-connection_setting_gsm.h"
#include "knetworkmanager-connection_settings_dialog.h"

using namespace ConnectionSettings;

class CellularDeviceTrayPrivate
{
	public:
		CellularDeviceTrayPrivate() {}
		~CellularDeviceTrayPrivate() {}

		CellularDevice* dev;
};

void CellularDeviceTray::newConnection()
{
	// create an appropriate connection
	Connection* conn = 0;
	switch (d->dev->getDeviceType()) {
		case DEVICE_TYPE_GSM:
			conn = new GSMConnection();
			break;
		case DEVICE_TYPE_CDMA:
			conn = new CDMAConnection();
			break;
	}

	// edit the new connection
	ConnectionSettingsDialogImpl* dlg = new ConnectionSettingsDialogImpl(conn, true, NULL, tray(), "connect_something", false, Qt::WDestructiveClose);
	dlg->show();
}


void CellularDeviceTray::addMenuItems(KPopupMenu* menu)
{
	ConnectionStore* connectionStore = ConnectionStore::getInstance();

	// device title
	Subhead* subhead = new Subhead (menu, "subhead", d->dev->getInterface(), SmallIcon("nm_device_wwan", QIconSet::Automatic));
	menu->insertItem (subhead, -1, -1);

	//menu->insertSeparator();
	NMProxy* nm = NMProxy::getInstance();
	Connection* active_conn = nm->getActiveConnection(d->dev);
	if (active_conn)
		printf("%s\n", active_conn->getObjectPath().data());

	// get all available Connections for cellular devices
	// WILLTODO : repeat for GSM
	QValueList<Connection*> connections = connectionStore->getConnections(NM_SETTING_CDMA_SETTING_NAME);
	for (QValueList<Connection*>::iterator it = connections.begin(); it != connections.end(); ++it)
	{
		CDMAConnection* cellularconn = dynamic_cast<CDMAConnection*>(*it);
		if (cellularconn)
		{
			// cellular connection found :)
			Info* info = cellularconn->getInfoSetting();
			IPv4* ip = cellularconn->getIPv4Setting();

			// lets create a nice name for this connection
			if (info)
			{
				QString title = info->getName();
				if (ip)
					title += QString(" (%1)").arg(ip->getMethod() == IPv4::METHOD_DHCP ? i18n("DHCP") : i18n("Manual IP config"));

				NetworkMenuItem* item = new NetworkMenuItem(d->dev, cellularconn, menu);

				int id = menu->insertItem(title, item, SLOT(slotActivate()));
				menu->setItemChecked(id, ((*it) == active_conn));
			}
		}
	}
	connections = connectionStore->getConnections(NM_SETTING_GSM_SETTING_NAME);
	for (QValueList<Connection*>::iterator it = connections.begin(); it != connections.end(); ++it)
	{
		GSMConnection* cellularconn = dynamic_cast<GSMConnection*>(*it);
		if (cellularconn)
		{
			// cellular connection found :)
			Info* info = cellularconn->getInfoSetting();
			IPv4* ip = cellularconn->getIPv4Setting();

			// lets create a nice name for this connection
			if (info)
			{
				QString title = info->getName();
				if (ip)
					title += QString(" (%1)").arg(ip->getMethod() == IPv4::METHOD_DHCP ? i18n("DHCP") : i18n("Manual IP config"));

				NetworkMenuItem* item = new NetworkMenuItem(d->dev, cellularconn, menu);

				int id = menu->insertItem(title, item, SLOT(slotActivate()));
				menu->setItemChecked(id, ((*it) == active_conn));
			}
		}
	}

	// bring the device down
	KAction* deactivate = tray()->actionCollection()->action("deactivate_device");
	if (deactivate)
		deactivate->plug(menu);

	menu->insertSeparator();
}

CellularDeviceTray::CellularDeviceTray (CellularDevice* dev, KSystemTray * parent, const char * name)
	: DeviceTrayComponent (dev, parent, name)
{
	d = new CellularDeviceTrayPrivate();
	d->dev = dev;

	setPixmapForState(NM_DEVICE_STATE_ACTIVATED, KSystemTray::loadIcon("nm_device_wwan"));
}

CellularDeviceTray::~CellularDeviceTray ()
{
	delete d;
}


#include "knetworkmanager-cellular_device_tray.moc"
