/*
Copyright 2008 Will Stephenson <wstephenson@kde.org>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License as
published by the Free Software Foundation; either version 2 of
the License or (at your option) version 3 or any later version
accepted by the membership of KDE e.V. (or its successor approved
by the membership of KDE e.V.), which shall act as a proxy 
defined in Section 14 of version 3 of the license.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef DEVICE_TRAY_COMPONENT_H
#define DEVICE_TRAY_COMPONENT_H

#include <NetworkManager.h>

#include <qmap.h>
#include <qmovie.h>
#include <qobject.h>
#include <qpixmap.h>

#include "traycomponent.h"

class Device;
class KPopupMenu;
class KSystemTray;

class DeviceTrayComponent : public TrayComponent
{
Q_OBJECT
public:
    DeviceTrayComponent(Device * device, KSystemTray * parent, const char * name );
    virtual ~DeviceTrayComponent();
    QPixmap pixmapForState(NMDeviceState state);
    QMovie movieForState(NMDeviceState state);
    virtual QStringList getToolTipText();
    Device* device() const;
signals:
    void needsCenterStage(TrayComponent *, bool);
public slots:
    virtual void newConnection() = 0;
protected slots:
    void deviceStateChanged(NMDeviceState);
protected:
    void setMovieForState(NMDeviceState, QMovie);
    void setPixmapForState(NMDeviceState, QPixmap);
private:
    Device * m_device;
    QMap<NMDeviceState, QMovie>  m_movies;
    QMap<NMDeviceState, QPixmap> m_pixmaps;
    QMap<NMDeviceState, QString>  m_tooltips;
};
#endif // DEVICE_TRAY_COMPONENT_H
