/***************************************************************************
 *
 * knetworkmanager-notify.h - A NetworkManager frontend for KDE 
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Timo Hoenig <thoenig@suse.de>, <thoenig@nouse.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef KNETWORKMANAGER_NOTIFY_H
#define KNETWORKMANAGER_NOTIFY_H

#include <kdialogbase.h>

#include "knetworkmanager.h"

class ActivationWidget;

class ActivationStageNotify : public KDialogBase
{
	Q_OBJECT
		
	public:
	  ActivationStageNotify  (QWidget * parent = 0, const char *name = 0, bool modal = FALSE, WFlags fl = 0, KNetworkManager* ctx = NULL);
	  ~ActivationStageNotify ();

	private slots:
	  void destroyActivationStage ();

	protected:

	  KNetworkManager*  _ctx;
	  ActivationWidget* _activationWidget;
};

class ActivationStageNotifyVPN : public ActivationStageNotify
{
	Q_OBJECT

	public:
	  ActivationStageNotifyVPN (QWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0, KNetworkManager* ctx = NULL, VPNConnection* vpnConnection = NULL);
	  ~ActivationStageNotifyVPN ();

	public slots:
	  void updateActivationStage ();

	private:
	
	  VPNConnection* _vpnConnection;
};

class ActivationStageNotifyNetwork : public ActivationStageNotify
{
	Q_OBJECT

	public:
	  ActivationStageNotifyNetwork  (const QString & essid, QWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0, KNetworkManager* ctx = NULL, Device* dev = NULL );
	  ~ActivationStageNotifyNetwork ();

	public slots:
	  void updateActivationStage ();

	private:
	  Device* _dev;
	  QString _essid;
};

#endif /* KNETWORKMANAGER_NOTIFY_H */
