/***************************************************************************
 *
 * knetworkmanager-device.cpp - A NetworkManager frontend for KDE 
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Timo Hoenig     <thoenig@suse.de>, <thoenig@nouse.net>
 *         Will Stephenson <wstephenson@suse.de>, <wstephenson@kde.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#include "knetworkmanager.h"
#include "knetworkmanager-device.h"

class DevicePrivate
{
public:
	DevicePrivate() :   interface (""), bustype (BUS_UNKNOWN), product (""), vendor (""), obj_path (""),
						type (DEVICE_TYPE_UNKNOWN),  udi (""), active (false), act_stage (NM_ACT_STAGE_UNKNOWN),
						ipv4_address (""), subnetmask (""), broadcast (""), hw_address (""), route (""),
						pri_dns (""), sec_dns (""), strength (0), link_active (false), speed (0),
						capabilities (NM_DEVICE_CAP_NONE) {}
/*	DevicePrivate( const DevicePrivate & o ) : interface ( o.interface ), bustype (o.bustype), product (o.product), vendor (o.vendor), obj_path (o.path),
						type (DEVICE_TYPE_UNKNOWN),  udi (""), active (false), act_stage (NM_ACT_STAGE_UNKNOWN),
						ipv4_address (""), subnetmask (""), broadcast (""), hw_address (""), route (""),
						pri_dns (""), sec_dns (""), strength (0), link_active (false), speed (0),
						capabilities (NM_DEVICE_CAP_NONE) {}*/
	~DevicePrivate() {}
	QString      interface;
	enum bustype bustype;
	QString      product;
	QString      vendor;
	QString      obj_path;
	NMDeviceType type;
	QString      udi;
	bool	       active;
	NMActStage   act_stage;  
	QString      ipv4_address;
	QString      subnetmask;
	QString      broadcast;
	QString      hw_address;
	QString      route;
	QString      pri_dns;
	QString      sec_dns;
	unsigned int mode;
	int          strength;
	bool         link_active;
	int          speed;
	unsigned int capabilities;
	unsigned int capabilities_type;

	NetworkList  networkList;

};

Device::Device (const QString & obj_path)
{
	d = new DevicePrivate;
	d->obj_path = obj_path;
}

Device::Device ()
{
	d = new DevicePrivate;
}

Device::~Device ()
{
	for ( NetworkList::Iterator i = d->networkList.begin (); i != d->networkList.end (); ++i)
		delete *i;
	delete d;
}
// Device::Device( const Device & other )
// {
// 	d = other.d;
// }

void
Device::setInterface (const QString & interface)
{
	d->interface = interface;
}

QString
Device::getInterface () const
{
	return d->interface;
}

void
Device::setBustype (const QString & bus)
{
	if (QString::compare (bus, "pci") == 0)
		d->bustype = BUS_PCI;
	else if (QString::compare (bus, "usb") == 0)
		d->bustype = BUS_USB;
	else if (QString::compare (bus, "pcmcia") == 0)
		d->bustype = BUS_PCMCIA;
	else
		d->bustype = BUS_UNKNOWN;
}

bustype
Device::getBustype () const
{
	return d->bustype;
}

void
Device::setProduct (const QString & product)
{
	d->product = product;
}

QString
Device::getProduct () const
{
	return d->product;
}

void
Device::setVendor (const QString & vendor)
{
	d->vendor = vendor;
}

QString
Device::getVendor () const
{
	return d->vendor;
}

void
Device::setObjectPath (const QString & obj_path)
{
	d->obj_path = obj_path;
}

QString
Device::getObjectPath () const
{
	return d->obj_path;
}

void
Device::setType (const NMDeviceType & type)
{
	/* Wireless devices need a list of networks */
	d->type = type;
}

void
Device::setUdi (const QString & udi)
{
	d->udi = udi;
}

QString
Device::getUdi () const
{
	return d->udi;
}

void
Device::setActive (bool active)
{
	d->active = active;
}

bool
Device::isActive () const
{
	return d->active;
}

void
Device::setActivationStage (const NMActStage & act_stage)
{
	d->act_stage = act_stage;
}

NMActStage
Device::getActivationStage () const
{
	return d->act_stage;
}

void
Device::setIPv4Address (const QString& ipv4_address)
{
	d->ipv4_address = ipv4_address;
}

QString
Device::getIPv4Address () const
{
	return d->ipv4_address;
}

void
Device::setSubnetmask (const QString& subnetmask)
{
	d->subnetmask = subnetmask;
}

QString
Device::getSubnetmask () const
{
	return d->subnetmask;
}

void
Device::setBroadcast (const QString& broadcast)
{
	d->broadcast = broadcast;
}

QString
Device::getBroadcast () const
{
	return d->broadcast;
}

void
Device::setHardwareAddress (const QString& hw_address)
{
	d->hw_address = hw_address;
}

QString
Device::getHardwareAddress () const
{
	return d->hw_address;
}

void
Device::setRoute (const QString& route)
{
	d->route = route;
}

QString
Device::getRoute () const
{
	return d->route;
}

void
Device::setPrimaryDNS (const QString& pri_dns)
{
	d->pri_dns = pri_dns;
}

QString
Device::getPrimaryDNS () const
{
	return d->pri_dns;
}

void
Device::setSecondaryDNS (const QString& sec_dns)
{
	d->sec_dns = sec_dns;
}

QString
Device::getSecondaryDNS () const
{
	return d->sec_dns;
}

void
Device::setMode (unsigned int mode)
{
	d->mode = mode;
}

unsigned int
Device::getMode () const
{
	return d->mode;
}

NMDeviceType
Device::getType () const
{
	return d->type;
}

void
Device::setStrength (int strength)
{
	d->strength = strength;
}

int
Device::getStrength () const
{
	return d->strength;
}

void
Device::setLinkActive (bool link_active)
{
	d->link_active = link_active;
}

bool
Device::getLinkActive () const
{
	return d->link_active;
}

void
Device::setSpeed (int speed)
{
	d->speed = speed;
}

int
Device::getSpeed () const
{
	return d->speed;
}


void
Device::setCapabilities (unsigned int capabilities)
{
	d->capabilities = capabilities;
}

unsigned int
Device::getCapabilities () const
{
	return d->capabilities;
}

bool
Device::hasCarrierDetect () const
{
	return d->capabilities & NM_DEVICE_CAP_CARRIER_DETECT;
}

void
Device::setCapabilitiesType (unsigned int capabilities_type)
{
	d->capabilities_type = capabilities_type;
}

unsigned int
Device::getCapabilitiesType () const
{
	return d->capabilities_type;
}
void
Device::addNetwork (Network* net)
{
	d->networkList.append (net);
}

void
Device::removeNetwork (Network* net)
{
	d->networkList.remove (net);
}

Network*
Device::getNetwork (const QString& obj_path) const
{
	NetworkList::iterator i;
	Network* net = 0;

	if (d->networkList.empty ()) {
		goto out;
	}
	for (i = d->networkList.begin (); i != d->networkList.end (); ++i) {
		if ((*i)->getObjectPath () == obj_path) {
			net = *i;
			goto out;
		}
	}

out:
	return net;

}

NetworkList
Device::getNetworkList () const
{
	return d->networkList;
}

bool
Device::isWired ()
{
	return ( d->type == DEVICE_TYPE_802_3_ETHERNET);
}

bool
Device::isWireless ()
{
	return ( d->type == DEVICE_TYPE_802_11_WIRELESS);
}

bool
Device::operator == (const Device & dev)
{
	return ( d->obj_path == dev.d->obj_path );
}
