#!/bin/sh

IN="$1"
TMP="$1".avi
OUT="$2"
normalisation="$3"
aspect="$4"
# frequency="$5"
# FFMPEG can only write 48KHz DV audio
frequency="48000"
size=`[ "$aspect" = "4:3" ] && echo "720:540" || echo "720:405"`

which mencoder > /dev/null
if [ $? -eq 0 ]; then
	mencoder -o "$TMP" -oac pcm -ovc lavc -lavcopts \
	vstrict=-1:vcodec=ffv1:autoaspect -xy 720 -zoom \
	-vf scale,expand=${size},dsize="$aspect" "$1"
	
	ffmpeg -threads 2 -i "$TMP" -s $normalisation -r $normalisation -aspect $aspect \
		-ac 2 -ar $frequency -y "$OUT"
	
	rm -f "$TMP" &> /dev/null
else
	ffmpeg -threads 2 -i "$IN" -s $normalisation -r $normalisation -aspect $aspect \
		-ac 2 -ar $frequency -y "$OUT"
fi