#!/bin/sh

usage()
{
	# Title
	echo "Title: Flash Dual Pass (FFMPEG)"

	# Usable?
	which ffmpeg> /dev/null
	[ $? -eq 0 ] && echo Status: Active || echo Status: Inactive

	# Type
	echo Flags: double-pass file-producer

	# Profiles
	echo "Profile: Broadband Quality FLV (320x240, 564Kbps)"
	echo "Profile: Low Quality FLV (320x240, 15fps, 128Kbps)"
	echo "Profile: Broadband Quality SWF+XHTML (320x240, 564Kbps)"
	echo "Profile: Low Quality SWF+XHTML (320x240, 15fps, 128Kbps)"
}

generate_xhtml()
{
	cat > "$1" << EOF
<div style="text-align: center;">
  <object width="320" height="240" align="middle"
    codebase="http://fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=7,0,0,0"
    classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000">
    <param name="allowFlashAutoInstall" value="true" />
    <param name="quality" value="high" />
    <param name="bgcolor" value="#ffffff" />
    <param name="movie" value="`basename "$1" .html`.swf" />
    <embed width="320" height="240" align="center"
      pluginspage="http://www.macromedia.com/go/getflashplayer"
      type="application/x-shockwave-flash"
      quality="high"
      bgcolor="#ffffff"
      src="`basename "$1" .html`.swf" />
  </object>
</div>
EOF
}

execute()
{
	# Arguments
	normalisation="$1"
	length="$2"
	profile="$3"
	file="$4"
	pass="$6"
	[ "x$file" = "x" ] && file="kino_export_"`date +%Y-%m-%d_%H.%M.%S`

	# Determine info arguments
	size=`[ "$normalisation" = "pal" ] && echo 352x288 || echo 352x240`
	hq=""
	[ $pass -eq "2" ] && hq="-deinterlace"
	

	# Run the command
	case "$profile" in 
		"0" ) 	ffmpeg -f dv -i pipe: -pass $pass -passlogfile "$file" $hq \
			-r "$normalisation" -b 500 -ac 2 -ab 64 -s 320x240 -aspect 4:3 \
			-ar 44100 -y "$file".flv ;;
		"1" ) 	ffmpeg -f dv -i pipe: -pass $pass -passlogfile "$file" $hq \
			-r 15.0 -b 80 -ac 1 -ab 48 -s 320x240 -aspect 4:3 \
			-ar 22050 -y "$file".flv ;;
		"2" )	ffmpeg -f dv -i pipe: -pass $pass -passlogfile "$file" $hq \
			-r "$normalisation" -b 500 -ac 2 -ab 64 -s 320x240 -aspect 4:3 \
			-ar 44100 -y "$file".swf
			[ $pass -eq "2" ] && generate_xhtml "$file".html
			;;
		"3" )	ffmpeg -f dv -i pipe: -pass $pass -passlogfile "$file" $hq \
			-r 15.0 -b 80 -ac 1 -ab 48 -s 320x240 -aspect 4:3 \
			-ar 22050 -y "$file".swf
			[ $pass -eq "2" ] && generate_xhtml "$file".html
			;;
	esac
	[ $pass -eq "2" ] && rm -f "$file-0.log"
}

[ "$1" = "--usage" ] || [ -z "$1" ] && usage "$@" || execute "$@"
