/***************************************************************************
 *   Copyright (C) 2003 by Mattia Merzi                                    *
 *   ottobit@ferrara.linux.it                                              *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include <kapplication.h>
#include <kcmdlineargs.h>
#include <kaboutdata.h>

#include <qmessagebox.h>
#include <qdir.h>
#include <unistd.h>
#include <kstandarddirs.h>
#include <kprocess.h>
#include <kdebug.h>

#include "DevicesWindow.h"
#include "BluezConnector.h"

static const char *description =
    I18N_NOOP("KDE Bluetooth Monitor");

static const char *version = "0.0";

int main( int argc, char *argv[] )
{
    BluezConnector* bc;// = BluezConnector.getDefaultConnector();
    bc = BluezConnector::getDefaultConnector();
    KAboutData aboutData("khciconfig", I18N_NOOP("KDE Bluetooth Device Viewer"),
                         version, description, KAboutData::License_GPL,
                         "(c) 2003, Mattia Merzi\n");
    aboutData.addAuthor("Mattia Merzi", I18N_NOOP("Author, Maintainer"), "ottobit@ferrara.linux.it");
    KCmdLineArgs::init( argc, argv, &aboutData );

    KApplication a;

    int user_is_root = FALSE;

    if (getuid() != 0)
    {
        QString uname = QString::fromAscii("access as ");
        uname = uname.append(cuserid(0));

        int res = QMessageBox::information( NULL , "Run as root ?"
                                            , "In order to change the bluetooth devices configuration"
                                            "\nyou must restart khciconfig as root"
                                            , "restart as root" , uname );
        kdDebug() << "res: " << res << endl;
        if (!res)
        {
            kdDebug() << "restarting via KDEsu !!!" << endl;
            QString kdesu;
            QString path = getenv("PATH");
            path.append(":/usr/bin");
            kdesu = KGlobal::dirs()->findExe("kdesu", path);
            KProcess* proc;
            proc = new KProcess;
            *proc << kdesu;
#if (QT_VERSION >= 0x030200)
            QString wd = qApp->applicationFilePath().ascii();
#else
            QString wd = QDir::currentDirPath();
            wd.append("/");
            wd.append(argv[0]);
#endif
            kdDebug() << ">" << wd.ascii() << "<" << endl;
            *proc << wd.ascii();
            proc->start();
            exit(0);
        }
    }
    else
    {
        user_is_root = TRUE;
    }

    DevicesWindow* dw = new DevicesWindow();
    dw->setUserIsRoot(user_is_root);

    a.setTopWidget(dw);
    dw->show();
    a.exec();


    return 0;
}
