/*
    This file is part of libqobex.

    Copyright (c) 2003 Mathias Froehlich <Mathias.Froehlich@web.de>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/

#ifndef QOBEXFBSSERVEROPS_H
#define QOBEXFBSSERVEROPS_H

#include <qfile.h>
#include <qcstring.h>
#include <qbuffer.h>

#include <qobex/qobexuuid.h>
#include <qobex/qobexobject.h>
#include <qobex/qobexauth.h>
#include <qobex/qobexserverops.h>

class QObexFBSServerOps
  : public QObexServerOps {
public:
  QObexFBSServerOps();
  virtual ~QObexFBSServerOps();

  virtual void connect( const QObexObject&, QObexObject& );
  virtual void disconnect( const QObexObject& );
  virtual void get( const QObexObject&, QObexObject& );
  virtual void del( const QObexObject&, QObexObject& );
  virtual void put( const QObexObject&, QObexObject& );
  virtual void setPath( const QObexObject&, QObexObject& );
  virtual void abort( const QObexObject& );
  virtual void streamingError();

  virtual bool dataReq( QByteArray&, Q_LONG );
  virtual bool data( const QValueList<QByteArray>& );

  virtual bool canHandle( const QByteArray& );
  virtual QObexServerOps* clone();

  virtual QObexAuthDigestChallenge::AuthInfo serverAuthInfo();
  virtual QByteArray serverSecret( const QString& clientUserId );
  virtual QObexAuthDigestResponse::AuthInfo clientAuthInfo( const QString& realm, bool userRequired );

protected:
  QFile f;
  QBuffer mXmlBuf;
  bool mFolderListingMode;

private:
  static bool checkForDotDot( const QString&, QObexObject& );
  static QByteArray getObexFolderListing( const QString& path, bool*ok );
};

#endif
