//-*-c++-*-
/***************************************************************************
 *   Copyright (C) 2003 by Fred Schaettgen                                 *
 *   kdebluetooth@schaettgen.de                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef NEIGHBOURFACTORY_H
#define NEIGHBOURFACTORY_H

#include <qobject.h>
#include <qptrlist.h>
#include <qdatetime.h>

namespace KBluetooth
{
namespace SDP
{

class NeighbourInfo;

/**
@author Fred Schaettgen
*/
class NeighbourFactory : public QObject
{
    Q_OBJECT
private:
    QPtrList<NeighbourInfo> neighbourList;
    QDateTime neighbourUpdateTime;
    void updateNeighbours();
    void queryNeighbours();
public:
    NeighbourFactory(QObject *parent = 0, const char *name = 0);

    virtual ~NeighbourFactory();
    QPtrList<NeighbourInfo> getNeighbourList(QString params = QString(""));
};

}
}
#endif
