/*
    This file is part of kio_obex.

    Copyright (c) 2003 Mathias Froehlich <Mathias.Froehlich@web.de>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/

#ifndef WIZARD_H
#define WIZARD_H

#include <qwizard.h>

class QString;
class QWidget;
class QHBoxLayout;
class QLabel;
class QListBox;
class QWidgetStack;
class KRestrictedLine;

class BluetoothDeviceWidget;
class IrDADeviceWidget;
class SerialDeviceWidget;
class IpDeviceWidget;

class Wizard : public QWizard
{
  Q_OBJECT
public:
  enum {
    SerialConfigurationPage,
    BluetoothConfigurationPage,
    IrDAConfigurationPage,
    IpConfigurationPage
  };

  Wizard( QWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0 );
  ~Wizard();

  QString name() const;
  QString transport() const;
  QString peer() const;
  QString device() const;
  int ipPort() const;
  int speed() const;
  
public slots:
  void slotAliasInput( const QString& );
  void slotTransportSelectionChanged();
  void slotTransportHighlighted( int );
  void slotPageThree( bool );

protected:
  // Widgets for the first page.
  QWidget* mWizardPage0;
  QHBoxLayout* mWizardPage0Layout;
  QLabel* mAliasInputText;
  KRestrictedLine* mAliasInput;

  // Widgets for the second page.
  QWidget* mWizardPage1;
  QHBoxLayout* mWizardPage1Layout;
  QLabel* mTransportInputText;
  QListBox* mTransportInputBox;

  // Widgets for the third page.
  // This is a widget stack depending on the transport selection on the second page.
  QWidgetStack* mWidgetStack;
  SerialDeviceWidget* mSerial;
  IrDADeviceWidget* mIrDA;
  BluetoothDeviceWidget* mBluetooth;
  IpDeviceWidget* mIp;
};

#endif
