/*
    This file is part of kio_obex.

    Copyright (c) 2003 Mathias Froehlich <Mathias.Froehlich@web.de>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/

#ifndef IPDEVICEWIDGET_H
#define IPDEVICEWIDGET_H

class QString;
class QWidget;
class QGridLayout;
class QLabel;
class QLineEdit;
class QSpinBox;

class IpDeviceWidget : public QWidget
{
  Q_OBJECT
public:
  IpDeviceWidget( QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
  ~IpDeviceWidget();

  QString peer() const;
  int ipPort() const;
  
public slots:
  void setPeer( const QString& );
  void setIpPort( int );
  void checkConfiguration();

signals:
  void configurationReady( bool );

private:
  QGridLayout* mLayout;
  QLabel* mHostnameText;
  QLineEdit* mHostnameInput;
  QLabel* mPortNumberText;
  QSpinBox* mPortNumberInput;
};

#endif
