/*****************************************************************************
 *   Copyright (C) 2003 by Mattia Merzi <merzi@it.it>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *****************************************************************************/

#ifndef DIALOG_CLASS_H
#define DIALOG_CLASS_H

#include <qvariant.h>
#include <qdialog.h>

#include "DeviceClass.h"

class QVBoxLayout;
class QHBoxLayout;
class QGridLayout;
class QPushButton;
class QButtonGroup;
class QListBox;
class QListBoxItem;
class QLineEdit;
class QLabel;

/*
 * This is the Device Class selection dialog.
 */
class DeviceClassDialog : public QDialog
{
    Q_OBJECT

public:
    DeviceClassDialog( QWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0 );
    ~DeviceClassDialog();

    QPushButton* pushbutton_ok;
    QButtonGroup* buttongroup_device_class;
    QListBox* listbox_minor;
    QListBox* listbox_major;
    QButtonGroup* buttongroup_service_classes;
    QListBox* listbox_services;
    QPushButton* pushbutton_cancel;
    QLineEdit* lineedit_hex;
    QLabel* label_hex;

    void lineedit_hex_update();
    void setServiceValue(uint8_t _service_val) { service_val = _service_val; }
    void setMajorValue(uint8_t _major_val) { major_val = _major_val; }
    void setMinorValue(uint8_t _minor_val) { minor_val = _minor_val; }
    uint8_t getServiceValue() { return service_val; }
    uint8_t getMajorValue() { return major_val; }
    uint8_t getMinorValue() { return minor_val; }

private:
    uint8_t service_val;
    uint8_t minor_val;
    uint8_t major_val;
    void setDeviceClassValues();

protected:

protected slots:
    virtual void languageChange();
    virtual void listbox_major_selected();
    virtual void listbox_minor_selected( QListBoxItem* );
    virtual void listbox_services_selected();
};

#endif // DIALOG_CLASS_H
