//-*-c++-*-
/***************************************************************************
 *   Copyright (C) 2004 by Fred Schaettgen <kdebluetooth@schaettgen.de>*
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#ifndef PAGEDDEVICESWIDGET_H
#define PAGEDDEVICESWIDGET_H

#include <pageddevicesbase.h>
#include <map>

class QTime;

/**
@author Fred Schaettgen
*/
class PagedDevicesWidget : public PagedDevicesBase
{
Q_OBJECT
public:
    PagedDevicesWidget(QWidget *parent);

    ~PagedDevicesWidget();
    struct DevInfo {
        int interval;
    };
    std::map<QString, DevInfo> devInfos;

public slots:
    void updateInterface();
    
private slots:
    void addDevice();
    void deleteDevice();
    void selectionChanged();
    void intervalChanged(const QTime& time);
    
signals:
    void dirty();
};

#endif
