//-*-c++-*-
/***************************************************************************
 *   Copyright (C) 2003 by Fred Schaettgen                                 *
 *   kbluetoothd@schaettgen.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef HCIDEVMONITOR_H
#define HCIDEVMONITOR_H

#include <qobject.h>
#include <qguardedptr.h>

namespace KBluetooth {
    class HciSocket;
}

class HciDevMonitor : public QObject
{
Q_OBJECT
public:
    HciDevMonitor(QObject *parent);
    ~HciDevMonitor();
public slots:
    void start();
signals:
    void hciDeviceLost();
    void hciDeviceFound();
    void hciNoStartupDevice();
private slots:
    void slotHciSocketClosed();
    void slotTimeout();
private:
    bool ignoreSocketError;
    bool alertedNoStartupDevice;
    QGuardedPtr<KBluetooth::HciSocket> hciSocket;
};

#endif
