//-*-c++-*-
/***************************************************************************
 *   Copyright (C) 2003 by Fred Schaettgen                                 *
 *   kbluetoothd@schaettgen.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef ConnectionDlg_H
#define ConnectionDlg_H

#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <signal.h>
#include <fcntl.h>
#include <errno.h>
#include <ctype.h>

#include <termios.h>
#include <fcntl.h>
#include <getopt.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <asm/types.h>
#include <netinet/in.h>
#include <bluetooth/bluetooth.h>
#include <bluetooth/hci.h>
#include <bluetooth/hci_lib.h>

#include <kdialogbase.h>
#include <libkbluetooth/deviceaddress.h>

class ConnectionMainWidget;
class ConnectionDetailsWidget;
class QTimer;

/**
@author Fred Schaettgen
*/
class ConnectionDlg : public KDialogBase
{
Q_OBJECT
public:
    ConnectionDlg(QWidget* parent);
    ~ConnectionDlg();
private:
    ConnectionMainWidget* mainDlg;
    ConnectionDetailsWidget *detailsDlg;
    KBluetooth::DeviceAddress address;
    QString deviceName;
    QTimer *timer;
    KBluetooth::DeviceAddress selectedAddress;

    void update();
    void updateRssi(int dd, uint16_t conHandle);
    void updateRole(int dd, uint16_t conHandle);
private slots:
    void slotTimer();
    void connectionSelected(int);
    void killCurrentConnection();
};

#endif
