//-*-c++-*-
/***************************************************************************
 *   Copyright (C) 2003 by Fred Schaettgen                                 *
 *   kbluetoothd@schaettgen.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include <pwd.h>
#include <kapplication.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <kpassdlg.h>
#include <kdialogbase.h>
#include <klocale.h>
#include <kdebug.h>
#include <dcopclient.h>
#include <qfile.h>
#include <qfileinfo.h>
#include <qdir.h>
#include <stdlib.h>
#include <iostream>
#include "../../libkbluetooth/configinfo.h"

static const char description[] =
    I18N_NOOP("A KDE KPart Application");

static const char* version = KDEBluetoothConfig::version;

static KCmdLineOptions options[] =
{
    { "+dir", I18N_NOOP("Direction (in|out)"), 0},
    { "+addr", I18N_NOOP("Remote Bluetooth address"), 0},
    { "+[name]", I18N_NOOP("Name of the remote device"), 0},
    KCmdLineLastOption
};

KCmdLineArgs *cmdLineArgs;

QStringList getHomeDirs()
{
    QStringList result;
    passwd *info;
    setpwent();
    while ((info = getpwent()) != NULL) {
        result.append(info->pw_dir);
    }
    return result;
}

QStringList getSessionList(const QString &home)
{
    QStringList result;
    QFileInfo dirInfo(home);
    if(!dirInfo.exists() || !dirInfo.isReadable()) return result;

    QDir d(home);
    d.setFilter(QDir::Files | QDir::Hidden | QDir::NoSymLinks);
    d.setNameFilter(".DCOPserver*");

    const QFileInfoList *list = d.entryInfoList();
    if( !list ) return result;

    QFileInfoListIterator it( *list );
    QFileInfo *fi;

    while ((fi = it.current()) != 0)
    {
        if(fi->isReadable())
            result.append( home+"/"+(fi->fileName()) );
        ++it;
    }
    return result;
}

QString showPinDialog(QString homedir, QString dcopFile,
    bool bIn, QString addr, QString name)
{
    QFileInfo iceauthFile(homedir+"/.ICEauthority");
    if (!iceauthFile.isReadable()) {
        kdWarning() << "Can't read " << homedir << "/.ICEauthority" << endl;
        return QString::null;
    }

    char *envStr = strdup(("ICEAUTHORITY="+homedir+"/.ICEauthority").ascii());
    kdDebug() << envStr << endl;
    putenv(envStr);
    QFile f(dcopFile);
    if (!f.open(IO_ReadOnly))
    {
        kdWarning() << "Can't open " << dcopFile << " for reading!" << endl;
        return QString::null;
    }

    QStringList l( QStringList::split( '\n', f.readAll() ) );
    QString dcopServer = l.first();
    kdDebug() << dcopServer<< endl;

    DCOPClient *client = new DCOPClient();

    // Register the client to receive the dialog result
    /*QCString appId = client->registerAs("kbluepin");
    if (appId) {
        kdDebug() << "registered as" << appId << endl;
    }
    else {
        kdDebug() << "Registration failed." << endl;
    }*/

    client->setServerAddress(dcopServer.ascii());
    if (client->attach() == false) {
		kdDebug() << "DCOPClient::attach failed for " << homedir
  		<< " / " << dcopFile << endl;
        return QString::null;
    }

    const char *function = "pinDialog(bool, QString, QString)";

    QByteArray argData, replyData;
    QCString replyType;
    QDataStream arg(argData, IO_WriteOnly);
    arg << bIn << addr << name;

    if (client->call( "kbluetoothd", "PinServer", function, argData, replyType, replyData))
    {
        QDataStream reply(replyData, IO_ReadOnly);

        if ( replyType != "QString")
        {
            kdWarning() << "unexpected result " << replyType.data() << endl;
            return QString::null;
        }
        QString result;
        reply >> result;
        return result;
    }
    else {
        return QString::null;
    }
}

QString tryAllSessions(bool bIn, QString addr, QString name)
{
    QStringList homes = getHomeDirs();
    for (QStringList::iterator hIt = homes.begin(); hIt != homes.end(); ++hIt) {
        QString homeDir = *hIt;
        QStringList sns = getSessionList(homeDir);
        for (QStringList::iterator sIt = sns.begin(); sIt != sns.end(); ++sIt) {
            QString session = *sIt;
            QString ret = showPinDialog(homeDir, session, bIn, addr, name);
            if (ret.length() > 0) return ret;
        }
    }
    return "";
}


int main(int argc, char **argv)
{
    KAboutData about("kbluepin", I18N_NOOP("kbluepin"), version, description,
                     KAboutData::License_GPL, "(C) 2003 Fred Schaettgen", 0, 0,
                     "kbluepin@schaettgen.de");
    about.addAuthor( "Fred Schaettgen,,,", 0, "fred@arrajadoa" );
    KCmdLineArgs::init(argc, argv, &about);
    KCmdLineArgs::addCmdLineOptions( options );

    // no session.. just start up normally
    cmdLineArgs = KCmdLineArgs::parsedArgs();

    QString dir = "out";
    QString addr = "<unknown>";
    QString name = "<unknown>";
    if (cmdLineArgs->count() > 0) dir = cmdLineArgs->arg(0);
    if (cmdLineArgs->count() > 1) addr = cmdLineArgs->arg(1);
    if (cmdLineArgs->count() > 2) name = cmdLineArgs->arg(2);

    bool bIncoming = (dir != QString("out"));
    kdDebug() << "Dir: " << dir << endl;
    kdDebug() << "Addr: " << addr << endl;
    kdDebug() << "Name: " << name << endl;

    QString ret = tryAllSessions(bIncoming, addr, name);
    if (ret.length() > 0) {
        // This *must* go to stdout, since this
        // will be parsed by Bluez's hcid, which is
        // calling kbluepin.
        std::cout << "PIN:" << ret.utf8() << std::endl;
        return 0;
    }
    else {
        // This *must* go to stdout, since this
        // will be parsed by Bluez's hcid, which is
        // calling kbluepin.
        std::cout << "ERR" << std::endl;
        return 1;
    }
}
