/***************************************************************************
                          irmcsyncconfig.cpp  -  description
                             -------------------
    begin                : Sat Feb 14 2003
    copyright            : (C) 2003 by Simone Gotti
    email                : simone.gotti@email.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "irmcsyncconfig.h"

#include "irmcsynckonnector.h"

#include <kapplication.h>
#include <kdebug.h>
#include <klocale.h>
#include <kdialog.h>

#include <qcombobox.h>
#include <qlabel.h>
#include <qradiobutton.h>
#include <qbuttongroup.h> 


using namespace KBluetooth;

IrMCSyncConfig::IrMCSyncConfig( QWidget *parent, const char *name )
		: KRES::ConfigWidget( parent, name )
{
	initUI();

  m_cmbType->insertItem( i18n( "Bluetooth" ) );
  m_cmbType->insertItem( i18n( "Cabel" ) );

  m_cmbDevice->insertItem( "/dev/ttyS0" );
  m_cmbDevice->insertItem( "/dev/ttyS1" );
  m_cmbDevice->insertItem( "/dev/ttyS2" );
  m_cmbDevice->insertItem( "/dev/ttyS3" );
  m_cmbDevice->insertItem( "/dev/ttyUSB0" );
  m_cmbDevice->insertItem( "/dev/ttyUSB1" );
  m_cmbDevice->insertItem( "/dev/ttyUSB2" );
  m_cmbDevice->insertItem( "/dev/ttyUSB3" );

  m_cmbDeviceSpeed->insertItem( "1200" );
  m_cmbDeviceSpeed->insertItem( "2400" );
  m_cmbDeviceSpeed->insertItem( "4800" );
  m_cmbDeviceSpeed->insertItem( "9600" );
  m_cmbDeviceSpeed->insertItem( "19200" );
  m_cmbDeviceSpeed->insertItem( "38400" );
  m_cmbDeviceSpeed->insertItem( "57600" );
  m_cmbDeviceSpeed->insertItem( "115200" );
}

IrMCSyncConfig::~IrMCSyncConfig()
{
}

void IrMCSyncConfig::loadSettings( KRES::Resource *resource )
{
	kdDebug() << "IrMCSyncConfig::loadSettings()" << endl;

	KSync::ThreadedPlugin *k =
	    dynamic_cast<KSync::ThreadedPlugin *>( resource );
	if ( !k ) {
		kdError() << "IrMCSyncConfig::loadSettings(): Wrong Konnector type." << endl;
		return;
	}

  m_cmbType->setCurrentItem( k->type() );

	m_cmbDeviceBtAddress->insertItem( k->deviceBtAddress(), 0 );
  m_cmbDevice->setCurrentText( k->device() );
  m_cmbDeviceSpeed->setCurrentText( QString::number( k->deviceSpeed() ) );

	m_chkSyncCalendar->setChecked( k->syncCalendar() );
	m_chkSyncAddressBook->setChecked( k->syncAddressBook() );
	
  slotTypeChanged( k->type() );
}

void IrMCSyncConfig::saveSettings( KRES::Resource *resource )
{
	kdDebug() << "IrMCSyncConfig::saveSettings()" << endl;
	KSync::ThreadedPlugin *k =
	    dynamic_cast<KSync::ThreadedPlugin *>( resource );
	if ( !k ) {
		kdError() << "IrMCSyncConfig::loadSettings(): Wrong Konnector type." << endl;
		return;
	}

  k->setType( (KSync::ThreadedPlugin::Type)m_cmbType->currentItem() );

	k->setDeviceBtAddress( m_cmbDeviceBtAddress->currentText() );
  k->setDevice( m_cmbDevice->currentText() );
  k->setDeviceSpeed( m_cmbDeviceSpeed->currentText().toInt() );

	k->setSyncCalendar( m_chkSyncCalendar->isChecked() );
	k->setSyncAddressBook( m_chkSyncAddressBook->isChecked() );

  k->init();
}

void IrMCSyncConfig::initUI()
{
  QGridLayout *layout = new QGridLayout( this, 3, 2, KDialog::marginHint(),
                              KDialog::spacingHint() );
	
  QLabel *label = new QLabel( i18n( "Type:" ), this );
  m_cmbType = new QComboBox( this );

  m_wdgBluetoothPage = createBluetoothPage();
  m_wdgSerialPage = createSerialPage();
  m_wdgSerialPage->hide();

	QButtonGroup *group = new QButtonGroup( 1, Qt::Vertical, this );
  group->setExclusive( true );

	m_chkSyncCalendar = new QRadioButton( i18n( "Sync calendar" ), group );
  group->layout()->add( m_chkSyncCalendar );

	m_chkSyncAddressBook = new QRadioButton( i18n( "Sync addressBook" ), group );
  group->layout()->add( m_chkSyncAddressBook );

  layout->addWidget( label, 0, 0 );
  layout->addWidget( m_cmbType, 0, 1 );
  layout->addMultiCellWidget( m_wdgBluetoothPage, 1, 1, 0, 1 );
  layout->addMultiCellWidget( m_wdgSerialPage, 1, 1, 0, 1 );
  layout->addMultiCellWidget( group, 2, 2, 0, 1 );

  connect( m_cmbType, SIGNAL( activated( int ) ),
           this, SLOT( slotTypeChanged( int ) ) );
}

QWidget *IrMCSyncConfig::createBluetoothPage()
{
  QGroupBox *page = new QGroupBox( this, "BluetoothPage" );

  QGridLayout *layout = new QGridLayout( page, 2, 2, KDialog::marginHint(),
                                         KDialog::spacingHint() );

	QLabel *label = new QLabel( i18n( "Device:" ), page );

	m_cmbDeviceBtAddress = new QComboBox( page );
	m_cmbDeviceBtAddress->setEditable( true );
	
	m_serviceSelector = new ServiceSelectionWidget( page , "0x1104", true, true, false );
	
	// Set The Layout
	layout->addWidget( label, 0, 0 );
	layout->addWidget( m_cmbDeviceBtAddress, 0, 1 );

	layout->addMultiCellWidget( m_serviceSelector, 1, 1, 0, 1 );
	connect( m_serviceSelector, SIGNAL( serviceChanged( KBluetooth::DeviceAddress, uint ) ),
           this, SLOT( slotServiceChanged( KBluetooth::DeviceAddress, uint ) ) );

  return page;
}

QWidget *IrMCSyncConfig::createSerialPage()
{
  QGroupBox *page = new QGroupBox( this, "SerialPage" );

  QGridLayout *layout = new QGridLayout( page, 2, 2, KDialog::marginHint(),
                                         KDialog::spacingHint() );

  QLabel *label = new QLabel( i18n( "Device:" ), page );
  m_cmbDevice = new QComboBox( page );
  m_cmbDevice->setEditable( true );

  layout->addWidget( label, 0, 0 );
  layout->addWidget( m_cmbDevice, 0, 1 );

  label = new QLabel( i18n( "Speed:" ), page );
  m_cmbDeviceSpeed = new QComboBox( page );
  m_cmbDeviceSpeed->setEditable( true );

  layout->addWidget( label, 1, 0 );
  layout->addWidget( m_cmbDeviceSpeed, 1, 1 );

  return page;
}

void IrMCSyncConfig::slotServiceChanged( KBluetooth::DeviceAddress btAddr, uint )
{
	m_cmbDeviceBtAddress->insertItem( QString( btAddr ), 0 );
}

void IrMCSyncConfig::slotTypeChanged( int type )
{
  switch ( type ) {
    case KSync::ThreadedPlugin::Bluetooth:
      m_wdgSerialPage->hide();
      m_wdgBluetoothPage->show();
      break;
    case KSync::ThreadedPlugin::Serial:
      m_wdgBluetoothPage->hide();
      m_wdgSerialPage->show();
      break;
  }
}

#include "irmcsyncconfig.moc"
