/***************************************************************************
                          clientthread.h  -  description
                             -------------------
    begin                : Sat Feb 14 2003
    copyright            : (C) 2003 by Simone Gotti
	
	from the threaded konnector of Mathias Froehlich <Mathias.Froehlich@web.de>
	
    email                : simone.gotti@email.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CLIENTTHREAD_H
#define CLIENTTHREAD_H

#include <qobject.h>
#include <qthread.h>
#include <qmutex.h>
#include <qwaitcondition.h>

#include <synceelist.h>

namespace KSync
{

	/**
	   Client Thread. The Worker OBEX client thread.
	   Note that this QObject is only accessed from the client thread. It is used
	   to report events from the working thread. This QObject will be the parent of
	   all QObjects in the working thread. It is in no way connected to the QObject
	   in the main thread.
	 */
	class ClientThread
				: public QObject
	{
		Q_OBJECT
	public:
		/**
		   Event numbers for the custom event.
		 */
		enum { TerminatedEvent = 46666,
		       FinishedEvent = TerminatedEvent+1,
		       ErrorEvent = TerminatedEvent+2,
		       ProgressEvent = TerminatedEvent+3,
			   SynceeReadedEvent = TerminatedEvent+4,
			   SynceeWritedEvent = TerminatedEvent+5
		     };
		/**
		   Possible commands for the worker.
		 */
		enum Command {
		    ReadSyncees,
		    WriteSyncees,
		    TerminateThread
		};

		/**
		   Constructor.
		 */
		ClientThread( QObject* );
		/**
		   Destructor.
		 */
		~ClientThread();

		/**
		   Worker function of QThread.
		   It runs the requests and posts events.
		 */
		void run();

	protected:

		virtual bool readSyncees() = 0;

		virtual bool writeSyncees() = 0;
		
		KSync::Syncee *mSyncee;
		KSync::Syncee *mReadedSyncee;
		KSync::Syncee *mChangedSyncee;
		KSync::Syncee *mDeletedSyncee;

	private:
		/**
		   Call in run if you have to report an error.
		 */
		void finished();
		
		// They were removed on 2004-10-08, let's what happens now...
		
		// /**
		//   Call in run if you have to report an error.
		// */
		// void error( const KSync::Error* );
		// /**
		//    Call in run if you want to report progress.
		//  */
		// void progress( const KSync::Progress* );
		
		void readSynceesfinished(KSync::Syncee *Syncee);
		
		void writeSynceesfinished();

		/**
		   The object where signals schould be sent to.
		 */
		QObject* mReciver;
		/**
		   The command to process;
		 */
		Command mCommand;
		/**
		   The synceelist to write/read to/from.
		 */
		KSync::SynceeList mSynceeList;

		/**
		   The three variables above are guarded by that lock.
		 */
		QMutex mLock;
		/**
		   Wait for a job.
		 */
		QWaitCondition mWait;
		/**
		   Set if the running request should be stopped.
		 */
		bool mCancel;

		/**
		   The class has to access several private variables.
		 */
		friend class ClientManager;
	};
}

#endif
