/***************************************************************************
 *   Copyright (C) 2005 by Patrick Steiner                                 *
 *   patrick.steiner@a1.net                                                *
 *   Copyright (C) 2005 by Martin Kleinhans                                *
 *   mkleinhans@web.de                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef AMAROKCONTROLLER_H
#define AMAROKCONTROLLER_H

#include "controller.h"
#include <qstringlist.h>
#include <qxml.h>
#include <vector>
#include "dcopcall.h"

class DCOPClient;

class AmarokController : public Controller, public QXmlDefaultHandler
{
Q_OBJECT
public:
    AmarokController(QObject* parent);
    ~AmarokController();
    void commandDINF(unsigned int &bitrate,
        unsigned int &sampleRate, unsigned int &channels);
    void commandFADE();
    void commandFFWD();
    SongInfo commandINFO();
    SongInfo commandINF2();
    void commandLADD(QString filename);
    void commandNEXT();
    void commandPAUS();
    void commandPLAY(QString filename, bool clear = false);
    QStringList commandPLST(int &curPos, bool useFilenames = false);
    void commandPREV();
    void commandREPT(bool repeat);
    void commandRMAL();
    void commandRWND();
    void commandSHFL(bool shuffle);
    void commandSLCT(Q_UINT16 index);
    void commandSTEN();
    void commandSTOP();
    void commandSTRT();
    void commandVOLM(Q_UINT8 volume);
    bool commandFULL();
    void commandSEEK(Q_UINT32 seconds);
    Q_UINT32 commandPLEN();
    bool commandGVOL(Q_UINT8 &volume);
    int currentIndex();

    struct PlaylistEntry {
        int track;
        QString title;
		QString artist;
        QString url;
    };

    bool startElement(const QString &namespaceURI, const QString &localName,
        const QString &qName, const QXmlAttributes &atts );
	bool endElement( const QString &, const QString &, const QString &qn );
	bool characters( const QString &chars );
private:
    DCOPClient* dcopClient;
    QString amarokDCOPApp;
	QString cdata;
	PlaylistEntry curEntry;
    DCOPCall createDCOPCaller(QString sub = "player");
    int getPosition();
    void setPosition(int secPos);
    unsigned int numTracks;
    std::vector<PlaylistEntry> playlistEntries;

};

#endif
