/***************************************************************************
* $Id: ProgressBar.java 140210 2002-03-02 15:36:51Z rdale $
**
* Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
* This file is part of an example program for Qt.  This example
* program may be used, distributed and modified without limitation.
**
****************************************************************************/

import org.kde.qt.*;


class ProgressBar extends QButtonGroup
{

protected QRadioButton slow, normal, fast;
protected QPushButton start, pause, reset;
protected QProgressBar progress;
protected QTimer timer;


/*
  Constructor
 *
  Creates child widgets of the ProgressBar widget
 */

ProgressBar( )
{
	this(null, null);
}

ProgressBar( QWidget parent, String name )
{
    super( 0, Horizontal, "Progress Bar", parent, name );
	timer = new QTimer();
    setMargin( 10 );

    QGridLayout toplayout = new QGridLayout( layout(), 2, 2, 5);

    setRadioButtonExclusive( true );

    // insert three radiobuttons which the user can use
    // to set the speed of the progress and two pushbuttons
    // to start/pause/continue and reset the progress
    slow = new QRadioButton( "&Slow", this );
    normal = new QRadioButton( "&Normal", this );
    fast = new QRadioButton( "&Fast", this );
    QVBoxLayout vb1 = new QVBoxLayout();
    toplayout.addLayout( vb1, 0, 0 );
    vb1.addWidget( slow );
    vb1.addWidget( normal );
    vb1.addWidget( fast );

    // two push buttons, one for start, for for reset.
    start = new QPushButton( "&Start", this );
    reset = new QPushButton( "&Reset", this );
    QVBoxLayout vb2 = new QVBoxLayout();
    toplayout.addLayout( vb2, 0, 1 );
    vb2.addWidget( start );
    vb2.addWidget( reset );

    // Create the progressbar
    progress = new QProgressBar( 100, this );
    //    progress.setStyle( new QMotifStyle() );
    toplayout.addMultiCellWidget( progress, 1, 1, 0, 1 );

    // connect the clicked() SIGNALs of the pushbuttons to SLOTs
    connect( start, SIGNAL(" clicked()"), this, SLOT(" slotStart()") );
    connect( reset, SIGNAL(" clicked()"), this, SLOT(" slotReset()") );

    // connect the timeout() SIGNAL of the progress-timer to a SLOT
    connect( timer, SIGNAL(" timeout()"), this, SLOT(" slotTimeout()") );

    // Let's start with normal speed...
    normal.setChecked( true );


    // some contraints
    start.setFixedWidth( 80 );
    setMinimumWidth( 300 );
}

/*
  SLOT slotStart
 *
  This SLOT is called if the user clicks start/pause/continue
  button
 */

void slotStart()
{
    // If the progress bar is at the beginning...
    if ( progress.progress() == -1 ) {
        // ...set according to the checked speed-radiobutton
        // the number of steps which are needed to complete the process
        if ( slow.isChecked() )
            progress.setTotalSteps( 10000 );
        else if ( normal.isChecked() )
            progress.setTotalSteps( 1000 );
        else
            progress.setTotalSteps( 50 );

        // disable the speed-radiobuttons
        slow.setEnabled( false );
        normal.setEnabled( false );
        fast.setEnabled( false );
    }

    // If the progress is not running...
    if ( !timer.isActive() ) {
        // ...start the timer (and so the progress) with a interval of 1 ms...
        timer.start( 1 );
        // ...and rename the start/pause/continue button to Pause
        start.setText( "&Pause" );
    } else { // if the prgress is running...
        // ...stop the timer (and so the prgress)...
        timer.stop();
        // ...and rename the start/pause/continue button to Continue
        start.setText( "&Continue" );
    }
}

/*
  SLOT slotReset
 *
  This SLOT is called when the user clicks the reset button
 */

void slotReset()
{
    // stop the timer and progress
    timer.stop();

    // rename the start/pause/continue button to Start...
    start.setText( "&Start" );
    // ...and enable this button
    start.setEnabled( true );

    // enable the speed-radiobuttons
    slow.setEnabled( true );
    normal.setEnabled( true );
    fast.setEnabled( true );

    // reset the progressbar
    progress.reset();
}

/*
  SLOT slotTimeout
 *
  This SLOT is called each ms when the timer is
  active (== progress is running)
 */

void slotTimeout()
{
    int p = progress.progress();

    // If the progress is complete...
    if ( p == progress.totalSteps() )  {
        // ...rename the start/pause/continue button to Start...
        start.setText( "&Start" );
        // ...and disable it...
        start.setEnabled( false );
        // ...and return
        return;
    }

    // If the process is not complete increase it
    progress.setProgress( ++p );
}
}
