"""
This program tests/demos some of the KSharedPtr related classes and
methods (KMimeType, KService, etc). It generally tests the *::List
methods for these classes (eg KService::List) since that also tests
the *::Ptr mapped type code (eg KService::Ptr) at the same time.

This version is suitable for KDE >= 3.0.0 (some methods not available
in earlier versions)
"""

"""
Copyright 2003 Jim Bublitz

Terms and Conditions

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
COPYRIGHT HOLDER BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

Except as contained in this notice, the name of the copyright holder shall
not be used in advertising or otherwise to promote the sale, use or other
dealings in this Software without prior written authorization from the
copyright holder.
"""

import sys

from qt import QWidget, QButtonGroup, Qt, QLabel, QListView, QListViewItem

from kdecore import KApplication, KCmdLineArgs, KAboutData, KURL
from kdeui import KMainWindow, KTabCtl, KListBox
from kio import KMimeType, KService, KServiceGroup, KServiceType, KTrader, KServiceTypeProfile

class MainWin (KMainWindow):
    def __init__ (self, *args):
        apply (KMainWindow.__init__, (self,) + args)

        tabctl = KTabCtl (self)
        self.setGeometry (0, 0, 600, 400)
        tabctl.setGeometry (10, 10, 550, 380)

        tabctl.addTab (KMimeTypeTab (tabctl), "KMimeType")
        tabctl.addTab (KServiceTab (tabctl), "KService")
        tabctl.addTab (KSycocaEntryTab (tabctl), "KSycocaEntry")
        tabctl.addTab (KServiceTypeTab (tabctl), "KServiceType")
        tabctl.addTab (OfferListTab (tabctl), "OfferList")

        tabctl.show ()


class OfferListTab (QWidget):
    def __init__ (self, parent, name = ""):
        QWidget.__init__ (self, parent, name)

        self.setGeometry (0, 0, 500, 370)
        lvLbl = QLabel ("Offers - text/html", self)
        lvLbl.setGeometry (10, 10, 150, 20)

        lv = QListView (self)
        lv.setSorting (-1)
        lv.addColumn ("type_", 75)
        lv.addColumn ("name", 100)
        lv.addColumn ("exec_", 200)
        lv.addColumn ("library", 100)
        lv.setGeometry (10, 30, 500, 300)
        lv.setAllColumnsShowFocus (1)

        # insert list items in reverse order

        pref = KServiceTypeProfile.preferredService ("Application", "image/jpeg")
        QListViewItem (lv, pref.type_ (), pref.name (), pref.exec_ (), pref.library ())
        QListViewItem (lv, "Preferred", "--------", "", "")
        QListViewItem (lv, "", "", "", "")

        trader = KTrader.self ()
        slist = trader.query ("image/jpeg", "Type == 'Application'")
        print "KTrader returned:", slist
        for s in slist:
            lvi = QListViewItem (lv, s.type_ (), s.name (), s.exec_ (), s.library ())


        lv.show ()

class KServiceTypeTab (QWidget):
    def __init__ (self, parent, name = ""):
        QWidget.__init__ (self, parent, name)

        self.setGeometry (0, 0, 500, 370)
        lvLbl = QLabel ("All Service Types", self)
        lvLbl.setGeometry (10, 10, 250, 20)

        lv = QListView (self)
        lv.addColumn ("name", 150)
        lv.addColumn ("desktopEntryPath", 300)
        lv.setGeometry (10, 30, 500, 300)
        lv.setAllColumnsShowFocus (1)

        slist = KServiceType.allServiceTypes ()

        for s in slist:
            lvi = QListViewItem (lv, s.name (), s.desktopEntryPath ())

        lv.show ()

class KSycocaEntryTab (QWidget):
    def __init__ (self, parent, name = ""):
        QWidget.__init__ (self, parent, name)

        grp = KServiceGroup.baseGroup ("screensavers")
        self.setGeometry (0, 0, 500, 370)
        lvLbl = QLabel ("Entries - 'screensavers': " + grp.name ().latin1 (), self)
        lvLbl.setGeometry (10, 10, 250, 20)

        lv = QListView (self)
        lv.addColumn ("name", 150)
        lv.addColumn ("entryPath", 300)
        lv.setGeometry (10, 30, 500, 300)
        lv.setAllColumnsShowFocus (1)

        slist = grp.entries (0, 0)

        for s in slist:
            lvi = QListViewItem (lv, s.name (), s.entryPath ())

        lv.show ()

class KServiceTab (QWidget):
    def __init__ (self, parent, name = ""):
        QWidget.__init__ (self, parent, name)

        self.setGeometry (0, 0, 500, 370)
        lvLbl = QLabel ("All Services", self)
        lvLbl.setGeometry (10, 10, 150, 20)

        lv = QListView (self)
        lv.addColumn ("type_", 75)
        lv.addColumn ("name", 100)
        lv.addColumn ("exec_", 200)
        lv.addColumn ("library", 100)
        lv.setGeometry (10, 30, 500, 300)
        lv.setAllColumnsShowFocus (1)

        slist = KService.allServices ()
        for s in slist:
            lvi = QListViewItem (lv, s.type_ (), s.name (), s.exec_ (), s.library ())

        lv.show ()

#        svc = KService.serviceByDesktopName ("kcookiejar")
#        print svc
#        print svc.type_ ()
#        print svc.name ().latin1 ()
#        print svc.exec_ ().latin1 ()
#        print svc.library ()


class KMimeTypeTab (QWidget):
    def __init__ (self, parent, name = ""):
        QWidget.__init__ (self, parent, name)

        self.setGeometry (0, 0, 500, 370)
        lbLbl = QLabel ("All Mimetypes", self)
        lbLbl.setGeometry (10, 10, 150, 20)
        lb = KListBox (self)
        lb.setGeometry (10, 30, 200, 300)
        mlist = KMimeType.allMimeTypes ()
        lblist = []
        for mt in mlist:
            lblist.append (mt.name ().latin1 ())

        lblist.sort ()
        lb.insertStrList (lblist)

        lb.show ()

        x = 250
        y = 10

        mt = KMimeType.mimeType ("text/plain")
        mtlbl = QLabel ("KMimeType.mimeType ('text/plain')", self)
        mtlbl.setGeometry (x, y, 250, 20)
        mtnamelbl = QLabel ("name", self)
        mtnamelbl.setGeometry (x + 15, y + 20, 100, 20)
        mtname = QLabel (mt.name (), self)
        mtname.setGeometry (x + 120, y + 20, 100, 20)
        mtdesklbl = QLabel ("desktopEntryPath", self)
        mtdesklbl.setGeometry (x + 15, y + 40, 100, 20)
        mtdesk = QLabel (mt.desktopEntryPath (), self)
        mtdesk.setGeometry (x + 120, y + 40, 150, 20)

        y = y + 80

        fp = KMimeType.findByPath ("mimetype.py")
        fplbl = QLabel ("KMimeType.findByPath ('mimetype.py')", self)
        fplbl.setGeometry (x, y, 250, 20)
        fpnamelbl = QLabel ("name", self)
        fpnamelbl.setGeometry (x + 15, y + 20, 100, 20)
        fpname = QLabel (fp.name (), self)
        fpname.setGeometry (x + 120, y + 20, 100, 20)
        fpdesklbl = QLabel ("desktopEntryPath", self)
        fpdesklbl.setGeometry (x + 15, y + 40, 100, 20)
        fpdesk = QLabel (fp.desktopEntryPath (), self)
        fpdesk.setGeometry (x + 120, y + 40, 150, 20)

        y = y + 80

        fu = KMimeType.findByURL (KURL ("file://mimetype.py"))
        fulbl = QLabel ("KMimeType.findByURL ('file://mimetype.py')", self)
        fulbl.setGeometry (x, y, 250, 20)
        funamelbl = QLabel ("name", self)
        funamelbl.setGeometry (x + 15, y + 20, 100, 20)
        funame = QLabel (fu.name (), self)
        funame.setGeometry (x + 120, y + 20, 100, 20)
        fudesklbl = QLabel ("desktopEntryPath", self)
        fudesklbl.setGeometry (x + 15, y + 40, 100, 20)
        fudesk = QLabel (fu.desktopEntryPath (), self)
        fudesk.setGeometry (x + 120, y + 40, 150, 20)

        y = y + 80

        fc, acc = KMimeType.findByFileContent ("mimetype.py")
        fclbl = QLabel ("KMimeType.findByFileContent ('mimetype.py')", self)
        fclbl.setGeometry (x, y, 250, 20)
        fcnamelbl = QLabel ("name", self)
        fcnamelbl.setGeometry (x + 15, y + 20, 100, 20)
        fcname = QLabel (fc.name (), self)
        fcname.setGeometry (x + 120, y + 20, 100, 20)
        fcdesklbl = QLabel ("desktopEntryPath", self)
        fcdesklbl.setGeometry (x + 15, y + 40, 100, 20)
        fcdesk = QLabel (fc.desktopEntryPath (), self)
        fcdesk.setGeometry (x + 120, y + 40, 100, 20)
        fcacclbl = QLabel ("accuracy", self)
        fcacclbl.setGeometry (x + 15, y + 60, 100, 20)
        fcacc = QLabel (str (acc), self)
        fcacc.setGeometry (x + 120, y + 60, 150, 20)



#-------------------- main ------------------------------------------------

description = "Test/demo KSharedPtr related methods/classes"
version     = "1.0"
aboutData   = KAboutData ("", "",\
    version, description, KAboutData.License_GPL,\
    "(C) 2003 Jim Bublitz")

KCmdLineArgs.init (sys.argv, aboutData)

KCmdLineArgs.addCmdLineOptions ([("+files", "File to open")])

app = KApplication ()
mainWindow = MainWin (None, "main window")
mainWindow.show()
app.exec_loop()
