#!/usr/bin/env python

"""
Copyright 2004 Jim Bublitz

Terms and Conditions

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
COPYRIGHT HOLDER BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

Except as contained in this notice, the name of the copyright holder shall
not be used in advertising or otherwise to promote the sale, use or other
dealings in this Software without prior written authorization from the
copyright holder.
"""

# This is an example of a DCOP enabled application written in Python, using
# PyKDE and the dcopexport module. Taken from server.py example in kde-bindings
# which was written by Torben Weis and Julian Rockey

import sys
from kdecore import KApplication, KCmdLineArgs, KAboutData
from dcopexport import DCOPExObj
from qt import QString, QStringList

"""
DCOPExObj provides all of the necessary machinery to DCOP-enable
an application: the 'process' method, marshalling/demarshalling,
and the 'features' method

To DCOP-enable an app,

    1. Add a class which subclasses DCOPExObj (ParrotObject in
       this case). Call the DCOPExObj.__init__ method with 'id'.
       If 'id' isn't specified, DCOP will assing a numerical id.
       'id' is the name of the object (eg, how it will be listed
       in kdcop, or returned with a dcopClient.remoteObjects call)

    2. Identify the methods/functions that will be exposed via
       DCOP - they don't have to be methods of the DCOPExObj
       class, as long as the DCOPExObj class can call them. Make
       sure they take/return types that DCOPExObj supports.

    3. For each method, call self.addMethod with the complete
       method signature (return type, name, list of argument
       types, but no argument names) as a string and the
       Python method/function that corresponds.

    4. That's it.
"""

# the class which will expose methods to DCOP - the methods do NOT
# need to be a member of this class.
class DeadParrotObject (DCOPExObj):
    def __init__ (self, id = 'dead parrot'):
        DCOPExObj.__init__ (self, id)

        # the methods available from this app via DCOP
        #     addMethod (<signature>, <Python method>)
        self.addMethod ('QString getParrotType()', self.get_type)
        self.addMethod ('void setParrotType (QString)', self.set_type)
        self.addMethod ('QString squawk()', self.squawk)
        self.addMethod ('QStringList adjectives()', self.adjectives)

        # set up object variables
        self.parrot_type = QString ("Norwegian Blue")

    def get_type (self):
        return self.parrot_type

    def set_type (self, parrot_type):
        self.parrot_type = parrot_type

    def squawk (self):
        return "This parrot, a %s, is pining for the fjords" % (self.parrot_type)

    def adjectives (self):
        adjList = ["passed on", "is no more", "ceased to be", "expired", "gone to meet his maker",
                   "a stiff", "bereft of life", "rests in peace", "metabolic processes are now history",
                   "off the twig", "kicked the bucket", "shuffled off his mortal coil",
                   "run down his curtain", "joined the bleedin' choir invisible", "THIS IS AN EX-PARROT"]
        qadjList = QStringList ()
        for adj in adjList:
            qadjList.append (adj)

        return qadjList

description = "A basic application template"
version     = "1.0"
aboutData   = KAboutData ("testdcopexport", "petshop",\
    version, description, KAboutData.License_GPL,\
    "(C) 2003 whoever the author is")

aboutData.addAuthor ("author1", "whatever they did", "email@somedomain")
aboutData.addAuthor ("author2", "they did something else", "another@email.address")

KCmdLineArgs.init (sys.argv, aboutData)

KCmdLineArgs.addCmdLineOptions ([("+files", "File to open")])

app   = KApplication ()
dcop  = app.dcopClient ()
appid = dcop.registerAs('petshop')
print "DCOP Application: %s starting" % appid

parrot         = DeadParrotObject()
another_parrot = DeadParrotObject('polly')

print """
Run kdcop and look for the 'petshop' application instance.

This program exports the 'deadParrot' and 'polly' objects.
Double-clicking those object's methods will allow you to get or set data.

To end the application, in kdcop choose the MainApplication-Interface
object and double-click the quit() method.
"""

app.exec_loop()


