/*
 * Copyright © 2006-2007 Fredrik Höglund <fredrik@kde.org>
 *
 * QCursor images Copyright © 1992-2006 Trolltech AS.
 *
 * KCursor images Copyright © 1998 Kurt Granroth <granroth@kde.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef BITMAPS_H
#define BITMAPS_H


/* XPM */
static const char * const busy_xpm[] = {
"32 32 3 1",
" 	c None",
".	c #000000",
"+	c #FFFFFF",
".                               ",
"..                              ",
".+.                             ",
".++.                            ",
".+++.                           ",
".++++.                          ",
".+++++.      ...........        ",
".++++++.     .+++++++++.        ",
".+++++++.    ...........        ",
".++++++++.    .+++++++.         ",
".+++++.....   .+++++++.         ",
".++.++.       .+.+.+.+.         ",
".+. .++.       .+.+.+.          ",
"..  .++.        .+.+.           ",
".    .++.        .+.            ",
"     .++.       .+++.           ",
"      .++.     .+++++.          ",
"      .++.    .+++.+++.         ",
"       ..     .++.+.++.         ",
"              .+.+.+.+.         ",
"             ...........        ",
"             .+++++++++.        ",
"             ...........        ",
"                                ",
"                                ",
"                                ",
"                                ",
"                                ",
"                                ",
"                                ",
"                                ",
"                                "};

/* XPM */
static const char * const forbidden_xpm[] = {
"20 20 3 1",
" 	c None",
".	c #FFFFFF",
"+	c #000000",
"       ......       ",
"     ..++++++..     ",
"    .++++++++++.    ",
"   .++++....++++.   ",
"  .+++..    ..+++.  ",
" .+++++.      .+++. ",
" .++.+++.      .++. ",
".+++..+++.     .+++.",
".++.  .+++.     .++.",
".++.   .+++.    .++.",
".++.    .+++.   .++.",
".++.     .+++.  .++.",
".+++.     .+++..+++.",
" .++.      .+++.++. ",
" .+++.      .+++++. ",
"  .+++..     .+++.  ",
"   .++++.....+++.   ",
"    .++++++++++.    ",
"     ..++++++..     ",
"       ......       "};

/* XPM */
static const char * const kde_hand_xpm[] = {
"22 22 3 1",
" 	c None",
".	c #000000",
"+	c #FFFFFF",
"       ..             ",
"      .++.            ",
"      .++.            ",
"      .++.            ",
"      .++.            ",
"      .++.            ",
"      .++....         ",
"      .++.++....      ",
"      .++.++.++..     ",
"    ...++.++.++.+.    ",
"    .+.++.++.++.++.   ",
"   .++.++++++++.++.   ",
"   .++.+++++++++++.   ",
"   .++.+++++++++++.   ",
"   .++++++++++++++.   ",
"   .++++++++++++++.   ",
"    .+++++++++++++.   ",
"    .+++++++++++++.   ",
"     .+++++++++++.    ",
"      .++++++++++.    ",
"      .+++++++++.     ",
"      ...........     "};

/* XPM */
static const char * const size_bdiag_xpm[] = {
"16 16 3 1",
" 	c None",
".	c #FFFFFF",
"+	c #000000",
"                ",
"                ",
"      ......... ",
"       .++++++. ",
"        .+++++. ",
"         .++++. ",
"  .     .+++++. ",
"  ..   .+++.++. ",
"  .+. .+++. .+. ",
"  .++.+++.   .. ",
"  .+++++.     . ",
"  .++++.        ",
"  .+++++.       ",
"  .++++++.      ",
"  .........     ",
"                "};

/* XPM */
static const char * const size_fdiag_xpm[] = {
"16 16 3 1",
" 	c None",
".	c #FFFFFF",
"+	c #000000",
"                ",
"                ",
"  .........     ",
"  .++++++.      ",
"  .+++++.       ",
"  .++++.        ",
"  .+++++.     . ",
"  .++.+++.   .. ",
"  .+. .+++. .+. ",
"  ..   .+++.++. ",
"  .     .+++++. ",
"         .++++. ",
"        .+++++. ",
"       .++++++. ",
"      ......... ",
"                "};

/* XPM */
static const char * const size_hor_xpm[] = {
"16 16 3 1",
" 	c None",
".	c #FFFFFF",
"+	c #000000",
"                ",
"                ",
"      .   .     ",
"     ..   ..    ",
"    .+.   .+.   ",
"   .++.   .++.  ",
"  .+++.....+++. ",
" .+++++++++++++.",
" .+++++++++++++.",
" ..+++.....+++..",
"  ..++.....++.. ",
"   ..+.   .+..  ",
"    ...   ...   ",
"     ..   ..    ",
"      .   .     ",
"                "};

/* XPM */
static const char * const size_ver_xpm[] = {
"16 16 3 1",
" 	c None",
".	c #FFFFFF",
"+	c #000000",
"                ",
"       ...      ",
"      .++..     ",
"     .++++..    ",
"    .++++++..   ",
"   .++++++++..  ",
"  .....++...... ",
"      .++..     ",
"      .++..     ",
"      .++..     ",
"  .....++...... ",
"   .++++++++..  ",
"    .++++++..   ",
"     .++++..    ",
"      .++..     ",
"       ...      "};

/* XPM */
static const char * const split_h_xpm[] = {
"32 32 3 1",
" 	c None",
".	c #FFFFFF",
"+	c #000000",
"                                ",
"                                ",
"                                ",
"                                ",
"                                ",
"                                ",
"             ......             ",
"             .+..+.             ",
"             .+..+.             ",
"             .+..+.             ",
"         .   .+..+.   .         ",
"        ..   .+..+.   ..        ",
"       .+.   .+..+.   .+.       ",
"      .++.....+..+.....++.      ",
"     .+++++++++..+++++++++.     ",
"      .++.....+..+.....++.      ",
"       .+.   .+..+.   .+.       ",
"        ..   .+..+.   ..        ",
"         .   .+..+.   .         ",
"             .+..+.             ",
"             .+..+.             ",
"             .+..+.             ",
"             .+..+.             ",
"                                ",
"                                ",
"                                ",
"                                ",
"                                ",
"                                ",
"                                ",
"                                ",
"                                "};

/* XPM */
static const char * const split_v_xpm[] = {
"32 32 3 1",
" 	c None",
".	c #FFFFFF",
"+	c #000000",
"                                ",
"                                ",
"                                ",
"                                ",
"                                ",
"               .                ",
"              .+.               ",
"             .+++.              ",
"            .+++++.             ",
"           ....+....            ",
"              .+.               ",
"              .+.               ",
"              .+.               ",
"       ........+........        ",
"       .+++++++++++++++.        ",
"       .................        ",
"       .................        ",
"       .+++++++++++++++.        ",
"       ........+........        ",
"              .+.               ",
"              .+.               ",
"              .+.               ",
"           ....+....            ",
"            .+++++.             ",
"             .+++.              ",
"              .+.               ",
"               .                ",
"                                ",
"                                ",
"                                ",
"                                ",
"                                "};

/* XPM */
static const char * const whats_this_xpm[] = {
"32 32 3 1",
" 	c None",
".	c #000000",
"+	c #FFFFFF",
".                               ",
"..          +++++++             ",
".+.        +.......+            ",
".++.      +..++++...+           ",
".+++.    +...+  +...+           ",
".++++.   +...+  +...+           ",
".+++++.  +...+  +...+           ",
".++++++. +...+  +...+           ",
".+++++++. +++  +...+            ",
".++++++++.    +...+             ",
".+++++.....  +...+              ",
".++.++.      +...+              ",
".+. .++.     +...+              ",
"..  .++.     +...+              ",
".    .++.    +++++              ",
"     .++.    +...+              ",
"      .++.   +...+              ",
"      .++.   +++++              ",
"       ..                       ",
"                                ",
"                                ",
"                                ",
"                                ",
"                                ",
"                                ",
"                                ",
"                                ",
"                                ",
"                                ",
"                                ",
"                                ",
"                                "};

/* XPM */
static const char * const working_cursor_xpm[]={
"32 32 3 1",
" 	c None",
"+	c #000000",
".	c #FFFFFF",
"..                              ",
".+.          .++++.             ",
".++.         .++++.             ",
".+++.       .++++++.            ",
".++++.     .+...+..+..          ",
".+++++.    +....+...++          ",
".++++++.   +...++...++          ",
".+++++++.  +..+.....++          ",
".++++++++. .++.....+..          ",
".+++++....  .++++++.            ",
".++.++.      .++++.             ",
".+. .++.     .++++.             ",
"..  .++.                        ",
"     .++.                       ",
"     .++.                       ",
"      ..                        ",
"                                ",
"                                ",
"                                ",
"                                ",
"                                ",
"                                ",
"                                ",
"                                ",
"                                ",
"                                ",
"                                ",
"                                ",
"                                ",
"                                ",
"                                ",
"                                "};

/* XPM */
static const char * const openhand_xpm[] = {
"16 16 3 1",
"       c None",
".      c #000000",
"+      c #FFFFFF",
"       ..       ",
"   .. .++...    ",
"  .++..++.++.   ",
"  .++..++.++. . ",
"   .++.++.++..+.",
"   .++.++.++.++.",
" ..+.+++++++.++.",
".++..++++++++++.",
".+++.+++++++++. ",
" .++++++++++++. ",
"  .+++++++++++. ",
"  .++++++++++.  ",
"   .+++++++++.  ",
"    .+++++++.   ",
"     .++++++.   ",
"                "};

/* XPM */
static const char * const closedhand_xpm[] = {
"16 16 3 1",
"       c None",
".      c #000000",
"+      c #FFFFFF",
"                ",
"                ",
"                ",
"    .. .. ..    ",
"   .++.++.++..  ",
"   .++++++++.+. ",
"    .+++++++++. ",
"   ..+++++++++. ",
"  .+++++++++++. ",
"  .++++++++++.  ",
"   .+++++++++.  ",
"    .+++++++.   ",
"     .++++++.   ",
"     .++++++.   ",
"                ",
"                "};

#endif // BITMAPS_H
