/*  This file is part of the KDE project
    Copyright (C) 2007 Kevin Ottens <ervin@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.

*/

#include "fakestorageaccess.h"

using namespace Solid::Backends::Fake;

FakeStorageAccess::FakeStorageAccess(FakeDevice *device)
    : FakeDeviceInterface(device)
{
    connect(device, SIGNAL(propertyChanged(const QMap<QString, int>&)),
            this, SLOT(onPropertyChanged(const QMap<QString, int>&)));
}

FakeStorageAccess::~FakeStorageAccess()
{

}


bool FakeStorageAccess::isAccessible() const
{
    return fakeDevice()->property("isMounted").toBool();
}

QString FakeStorageAccess::filePath() const
{
    return fakeDevice()->property("mountPoint").toString();
}

bool FakeStorageAccess::setup()
{
    if (fakeDevice()->isBroken() || isAccessible()) {
        return false;
    } else {
        fakeDevice()->setProperty("isMounted", true);
        return true;
    }
}

bool FakeStorageAccess::teardown()
{
    if (fakeDevice()->isBroken() || !isAccessible()) {
        return false;
    } else {
        fakeDevice()->setProperty("isMounted", false);
        return true;
    }
}

void Solid::Backends::Fake::FakeStorageAccess::onPropertyChanged(const QMap<QString,int> &changes)
{
    foreach (QString property, changes.keys()) {
        if (property=="isMounted") {
            emit accessibilityChanged(fakeDevice()->property("isMounted").toBool(), fakeDevice()->udi());
        }
    }
}

#include "backends/fakehw/fakestorageaccess.moc"
