#!/usr/bin/python
###########################################################################
# servertestdialog.py -                                                   #
# ------------------------------                                          #
# copyright : (C) 2004 by Simon Edwards                                   #
# email     : simon@simonzone.com                                         #
#                                                                         #
###########################################################################
#                                                                         #
#   This program is free software; you can redistribute it and/or modify  #
#   it under the terms of the GNU General Public License as published by  #
#   the Free Software Foundation; either version 2 of the License, or     #
#   (at your option) any later version.                                   #
#                                                                         #
###########################################################################
from qt import * # Just use Qt for this.
import os
import sys

os.environ["DISPLAY"] = ":9"

class ServerTestDialog(QDialog):
    def __init__(self):
        QDialog.__init__(self)

        msec = 10000
        margin = 4
        spacing = 4

        self.totaltimer = QTimer(self)
        self.updatetimer = QTimer(self)
        self.msectotal = self.msecremaining = msec
        self.updateinterval = 1000

        self.connect(self.totaltimer, SIGNAL("timeout()"), self.slotInternalTimeout)
        self.connect(self.updatetimer, SIGNAL("timeout()"), self.slotUpdateTime)

        layout = QHBoxLayout(self)
        # create the widgets
        self.mainwidget = QVBox(self, "mainWidget")
        self.mainwidget.setMargin(margin)
        self.mainwidget.setSpacing(spacing)
        
        layout.addWidget(self.mainwidget,1)
        
        label = QLabel(self.mainwidget)
        label.setText("Are these settings acceptable?") # FIXME text
        QWidget(self.mainwidget)
        
        self.timerwidget = QHBox(self.mainwidget, "timerWidget")
        self.timerlabel = QLabel(self.timerwidget)
        self.timerprogress = QProgressBar(self.timerwidget)
        self.timerprogress.setTotalSteps(self.msectotal)
        self.timerprogress.setPercentageVisible(False)

        hbox = QHBox(self.mainwidget)
        self.okbutton = QPushButton("Yes",hbox)
        QWidget(hbox)
        self.cancelbutton = QPushButton("No",hbox)
        self.connect(self.okbutton, SIGNAL("clicked()"), self.slotOk)
        self.connect(self.cancelbutton, SIGNAL("clicked()"), self.slotCancel)
        
        self.slotUpdateTime(False)

    def show(self):
        QDialog.show(self)
        self.totaltimer.start(self.msectotal, True)
        self.updatetimer.start(self.updateinterval, False)

    def exec_loop(self):
        self.totaltimer.start(self.msectotal, True)
        self.updatetimer.start(self.updateinterval, False)
        return QDialog.exec_loop(self)

    def setRefreshInterval(self, msec):
        self.updateinterval = msec;
        if self.updatetimer.isActive():
            self.updatetimer.changeInterval(self.updateinterval)

    def timeoutButton(self):
        return self.buttonontimeout

    def setTimeoutButton(self, newbutton):
        self.buttonontimeout = newbutton

    def slotUpdateTime(self, update=True):
        self.msecremaining -= self.updateinterval
        
        self.timerprogress.setProgress(self.msecremaining)
        self.timerlabel.setText( "Automatically cancelling in %i seconds:" % (self.msecremaining/1000.0) )

    def slotInternalTimeout(self):
        self.reject()

    def slotOk(self):
        self.accept()
        
    def slotCancel(self):
        self.reject()
        
qapp = QApplication(sys.argv)
dialog = ServerTestDialog()
dialog.show()
dialog.exec_loop()

if dialog.result()==QDialog.Accepted:
    sys.exit(0)
else:
    sys.exit(1)
