/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jffi;

import java.nio.Buffer;

public final class ObjectBuffer {
    static final int INDEX_SHIFT = 16;
    static final int INDEX_MASK = 0xFF0000;
    static final int TYPE_SHIFT = 24;
    static final int TYPE_MASK = -16777216;
    static final int PRIM_MASK = 0xF000000;
    static final int FLAGS_SHIFT = 0;
    static final int FLAGS_MASK = 255;
    public static final int IN = 1;
    public static final int OUT = 2;
    public static final int ZERO_TERMINATE = 4;
    public static final int PINNED = 8;
    static final int ARRAY = 0x10000000;
    static final int BUFFER = 0x20000000;
    static final int BYTE = 0x1000000;
    static final int SHORT = 0x2000000;
    static final int INT = 0x3000000;
    static final int LONG = 0x4000000;
    static final int FLOAT = 0x5000000;
    static final int DOUBLE = 0x6000000;
    private Object[] objects = new Object[3];
    private int[] info = new int[this.objects.length * 3];
    private int infoIndex = 0;
    private int objectIndex = 0;

    final int objectCount() {
        return this.objectIndex;
    }

    final int[] info() {
        return this.info;
    }

    final Object[] objects() {
        return this.objects;
    }

    private final void ensureSpace() {
        if (this.objects.length <= this.objectIndex + 1) {
            Object[] newObjects = new Object[this.objects.length << 1];
            System.arraycopy(this.objects, 0, newObjects, 0, this.objectIndex);
            this.objects = newObjects;
            int[] newInfo = new int[this.objects.length * 3];
            System.arraycopy(this.info, 0, newInfo, 0, this.objectIndex * 3);
            this.info = newInfo;
        }
    }

    private static final int makeArrayFlags(int flags, int type, int index) {
        return flags & 0xFF | index << 16 & 0xFF0000 | type;
    }

    private static final int makeBufferFlags(int index) {
        return index << 16 & 0xFF0000 | 0x20000000;
    }

    public void putArray(int index, byte[] array, int offset, int length, int flags) {
        this.putObject(array, offset, length, ObjectBuffer.makeArrayFlags(flags, 0x11000000, index));
    }

    public void putArray(int index, short[] array, int offset, int length, int flags) {
        this.putObject(array, offset, length, ObjectBuffer.makeArrayFlags(flags, 0x12000000, index));
    }

    public void putArray(int index, int[] array, int offset, int length, int flags) {
        this.putObject(array, offset, length, ObjectBuffer.makeArrayFlags(flags, 0x13000000, index));
    }

    public void putArray(int index, long[] array, int offset, int length, int flags) {
        this.putObject(array, offset, length, ObjectBuffer.makeArrayFlags(flags, 0x14000000, index));
    }

    public void putArray(int index, float[] array, int offset, int length, int flags) {
        this.putObject(array, offset, length, ObjectBuffer.makeArrayFlags(flags, 0x15000000, index));
    }

    public void putArray(int index, double[] array, int offset, int length, int flags) {
        this.putObject(array, offset, length, ObjectBuffer.makeArrayFlags(flags, 0x16000000, index));
    }

    public void putDirectBuffer(int index, Buffer obj, int offset, int length) {
        this.putObject(obj, offset, length, ObjectBuffer.makeBufferFlags(index));
    }

    private void putObject(Object array, int offset, int length, int flags) {
        this.ensureSpace();
        this.objects[this.objectIndex++] = array;
        this.info[this.infoIndex++] = flags;
        this.info[this.infoIndex++] = offset;
        this.info[this.infoIndex++] = length;
    }
}

