# -*- coding: UTF-8 -*-

'''oslib tests'''

# (c) 2007 Canonical Ltd.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

import unittest, os

from jockey.oslib import OSLib
import sandbox

class OSLibTest(unittest.TestCase):
    '''OSLib tests'''

    def test_module_blacklisting(self):
        '''module_blacklisted() and blacklist_module()'''

        for m in sandbox.fake_modinfo:
            self.failIf(OSLib.inst.module_blacklisted(m))

            # remove nonexisting entry
            OSLib.inst.blacklist_module(m, False)
            self.failIf(OSLib.inst.module_blacklisted(m))

            # double addition
            OSLib.inst.blacklist_module(m, True)
            self.assert_(OSLib.inst.module_blacklisted(m))
            OSLib.inst.blacklist_module(m, True)
            self.assert_(OSLib.inst.module_blacklisted(m))

        self.assertEqual(open(OSLib.inst.module_blacklist_file).read(), 
            ''.join(['blacklist %s\n' % m for m in sorted(sandbox.fake_modinfo.keys())]))

        # file is removed once it becomes empty
        for m in sandbox.fake_modinfo:
            OSLib.inst.blacklist_module(m, False)
            self.failIf(OSLib.inst.module_blacklisted(m))

        self.failIf(os.path.exists(OSLib.inst.module_blacklist_file))

    def test_module_blacklist_load(self):
        '''module blacklist loading.'''

        f = open(OSLib.inst.module_blacklist_file, 'w')
        try:
            f.write('''blacklist vanilla
# FOO BAR

 blacklist  cherry # we do not like red fruits
# blacklist mint
''')
            f.close()

            OSLib.inst._load_module_blacklist()

            self.assert_(OSLib.inst.module_blacklisted('vanilla'))
            self.assert_(OSLib.inst.module_blacklisted('cherry'))
            self.failIf(OSLib.inst.module_blacklisted('chocolate'))
            self.failIf(OSLib.inst.module_blacklisted('mint'))
            self.failIf(OSLib.inst.module_blacklisted('vanilla3d'))
        finally:
            os.unlink(OSLib.inst.module_blacklist_file)
            OSLib.inst._load_module_blacklist()

    def test_is_admin(self):
        '''is_admin()'''

        # we can write our test suite's cache
        self.assert_(OSLib.inst.is_admin())

        # for the negative case, use /proc/nonexisting; not even root can write
        # there ;)
        old_cache = OSLib.inst.check_cache
        try:
            OSLib.inst.check_cache = '/proc/nonexisting'
            self.failIf(OSLib.inst.is_admin())
        finally:
            OSLib.inst.check_cache = old_cache
