#!/usr/bin/ruby

$KCODE      = 'UTF-8'

require 'Qt'
require 'uri'

require 'ui/IspellDictDlg'


require 'aspell-helper'
require 'aspell-stats'
require 'asp-util'


$aspellSuggestions = true

class MyDlg < IspellDictDlg
	TAB_NOUN = 0
	TAB_VERB = 1
	TAB_ADJ = 2

    def initialize(parent = nil, name = nil, fl = 0)
	  super(parent, name, fl)
	  @stats = Stats.new
	  @origWordMap = Hash.new(0)


	  @wordsHandled = 0
	  @wordsAdded = 0
	  @wordsRemoved = 0
	  @wordsChanged = 0

	  @deletingInput = false

	  @flagToBtns = {
	    # verbs
		'A' => [ rdGroupA, chkNormal ],
		'B' => [ rdGroupA, chkReverse ],
		'I' => [ rdGroupI, chkNormal ],
		'J' => [ rdGroupI, chkReverse ],
		'K' => [ rdGroupK, chkNormal ],
		'L' => [ rdGroupK, chkReverse ],
		'M' => [ rdGroupM, chkNormal ],
		'N' => [ rdGroupM, chkReverse ],
		
		'G' => [ chkComplexFuture, chkNormal ],
		'H' => [ chkComplexFuture, chkReverse ],

		'C' => [ rdImperSoft, chkNormal ],
		'D' => [ rdImperSoft, chkReverse ],

		'E' => [ rdImperHard, chkNormal ],
		'F' => [ rdImperHard, chkReverse ],
		
		# nouns
		'a' => [ rdGroup_a, chkSingle ],
		'b' => [ rdGroup_a, chkPlural ],
		'c' => [ rdGroup_a, chkSingle, chkGen_a ],
		'd' => [ rdGroup_a, chkSingle, chkVocative ],
		'o' => [ rdGroup_a, chkSwitch ],

		'e' => [ rdGroup_e, chkSingle ],
		'f' => [ rdGroup_e, chkPlural ],
		'g' => [ rdGroup_e, chkSingle, chkGen_a ],
		'h' => [ rdGroup_e, chkSingle, chkVocative ],

		'i' => [ rdGroup_i, chkSingle ],
		'j' => [ rdGroup_i, chkPlural ],

		'l' => [ rdGroup_l, chkSingle ],
		'm' => [ rdGroup_l, chkPlural ],
		'q' => [ rdGroup_l, chkSingle, chkGen_a ],

		'p' => [ chkPatronim ],

		# adj & adv
		'V' => [ chkAdjectiveU ],
		'V' => [ chkAdjective ],
		'W' => [ chkAdverb ],
		'Y' => [ chkCompar ]

		# other
#		'Z' => [ chkNegative ]
	  }
	  
	  @checkToFlag = {
		# verb - normal + reverse
		rdGroupA => [ 'A', 'B' ],
		rdGroupI => [ 'I', 'J' ],
		rdGroupK => [ 'K', 'L' ],
		rdGroupM => [ 'M', 'N' ],
		chkComplexFuture => [ 'G', 'H' ],

		rdImperSoft => [ 'C', 'D' ],
		rdImperHard => [ 'E', 'F' ],

		# noun
		rdGroup_a => [ 'a', 'b', 'c', 'o', 'd', 'p' ],
		rdGroup_e => [ 'e', 'f', 'g', 'o', 'h', 'p' ],
		rdGroup_i => [ 'i', 'j', 'k', 'o', 'd', 'p' ],
		rdGroup_l => [ 'l', 'm', 'q', '',  'n', 'p' ],
		
		# adj & adv
		chkAdjectiveU => [ 'U' ],
		chkAdjective => [ 'V' ],
		chkAdverb => [ 'W' ],
		chkCompar => [ 'Y' ],

		# other
		chkNegative => [ 'Z' ]
	  }
	  #@flagToCheck.invert
	end


    slots 'languageChange()',
    'addWord()',
    'addSuggestedWord()',
    'removeWord()',
    'duplicateWord()',
    'getStardict()',
    'getWordBack()',
    'groupChanged(int)',
    'dictChanged()',
    'notDeclined()',
    'rawTextEdited()',
    'save()',
    'suggSelected()',
    'tabChanged(const QString&)',
    'wordSelected()',
    'outputSelected()',
    'showDefinition()',
	'save()',
	'extendWordFlags()',
	'findSimilar()'

  def update_counters
	lblInputCount.setText("Вхідних слів: #{lstInput.count.to_s} (обр. #{@wordsHandled})")
	lblAddedCount.setText("Додано: #{@wordsAdded}, вилучено: #{@wordsRemoved}, змінено: #{@wordsChanged}")
	canSave = (@wordsHandled + @wordsAdded + @wordsRemoved + @wordsChanged > 0)
	btnSave.setEnabled(canSave)
  end

  def save()
	save_changes
	@wordsHandled = 0
	@wordsAdded = 0
	@wordsRemoved = 0
	@wordsChanged = 0
	update_counters
  end

  def extendWordFlags
	txt2 = lstOutput.currentText
	
	return if txt2 == nil
	
	ot = txt2.delete(' ').split(/[:]/)
	dict = ot[0]
	oldStr = ot[1]

	newFlags = get_flags( txtResult.text )

	if oldStr.include?('/')
	  oldFlags = get_flags( oldStr )

	  resultFlags = (oldFlags + newFlags).squeeze

	  newTxt = oldStr.split('/')[0] + '/' + resultFlags
	else
	  newTxt = oldStr + '/' + newFlags
	end
	
	add_word_to_dict(dict, newTxt)
	remove_word_from_dict(dict, oldStr)
	@wordsChanged += 1
	
	cnt = remove_derivatives_from_input(newTxt)
	@wordsHandled += cnt
	
	update_counters
  end

  def showDefinition()
	txt = txtResult.text
	txt = txt.split('/')[0] if txt.include?('/')

#	txtEnc = URI.escape("http://www.slovnyk.net/?swrd=#{txt}")
#	txtEnc = "http://www.slovnyk.net/?swrd=#{txt}".gsub( /'/, "%27" ) #'
	txt = txt.gsub( /'/, "%27" ) #'
	txtEnc = "'http://r2u.org.ua/krym/krym_search.php?word_str=#{txt}&type=ukrq&highlight=on'";
#	runCmd = "dcop `dcop konq* | head -1` konqueror-mainwindow#1 #{txtEnc}"
#	runCmd = "dcop `dcop konq* | head -1` default createNewWindow #{txtEnc}"
#	runCmd = "dcop klauncher klauncher 'kdeinit_exec(QString,QStringList)' konqueror '(' #{txtEnc} ')'"
	runCmd = "xdg-open #{txtEnc}"
#	puts "konqueror #{txtEnc} 2>/dev/null >/dev/null &"
#	cmd = IO.popen("konqueror \"#{txtEnc}\" &", "r+")
	cmd = IO.popen(runCmd, "r+")
    cmd.close
  end

  def outputSelected()

	btnCut.setEnabled( lstOutput.currentItem != -1 )

	txt = txtResult.text
	return if txt.empty? or lstOutput.currentItem == -1
	
	t = txt.split('/')
	word = t[0]
	flags = t[1]

	outText = lstOutput.currentText
	ot = outText.delete(' ').split(/[:\/]/)

	if word == ot[1] and flags != ot[2]
	  btnExtendOutput.setEnabled(true)
	else
	  btnExtendOutput.setEnabled(false)
	end

#	btnCut.setEnabled(ot[3] != nil)
	
  end

  def tabChanged(i)
#	setFlags("")
#	groupChanged(0)
  end


  def setFlags(flags)
	txt = txtResult.text
	return if txt.empty?
	
	if txt.include?("/")
	  txt = /^[^\/A-Za-z]+/.match( txt )[0]
	end
	
	if( ! flags.empty? )
	  txt << "/"
	end
	txtResult.setText( txt << flags )
  end

  def groupChanged(i)
	flagsOn = []

	tab = wordGroupTag.currentPageIndex

	puts "tab: #{tab}"	
	@checkToFlag.each_pair { |btn, flags|
	  if btn.isChecked and get_tab(flags[0]) == tab
		if tab == TAB_VERB
		  flagsOn << flags[0] if chkNormal.isChecked
		  flagsOn << flags[1] if chkReverse.isChecked
		end
		if tab == TAB_NOUN
		  flagsOn << flags[0] if chkSingle.isChecked
		  flagsOn << flags[1] if chkPlural.isChecked
		  flagsOn << flags[2] if flags[2] != nil and chkGen_a.isChecked
		  flagsOn << flags[3] if flags[3] != nil and chkSwitch.isChecked
		  flagsOn << flags[4] if flags[4] != nil and chkVocative.isChecked
		  flagsOn << flags[5] if flags[5] != nil and chkPatronim.isChecked
		end
		if tab == TAB_ADJ
		  flagsOn << flags[0]
		end
	  end
	}
	strFlagsOn = flagsOn.uniq.sort.to_s
	strFlagsOn << 'Z' if chkNegative.isChecked		# append Z always at the end

#	chkSwitch.setEnabled( chkSingle.isChecked || chkPlural.isChecked )
	chkGen_a.setEnabled( chkSingle.isChecked )
	chkPatronim.setEnabled( chkSingle.isChecked )
	chkVocative.setEnabled( chkSingle.isChecked )

	puts "flagsOn: #{flagsOn}"	
	setFlags( strFlagsOn )
  end

  def getStardict
	txt = txtResult.text
	txt = txt.split('/')[0] if txt.include?('/')

#	txtEnc = "#{txt}".gsub( /'/, '\\'' )	#'
	runCmd = "stardict \"#{txt}\" &"
	cmd = IO.popen(runCmd, "r+")
    cmd.close
  end
  
  def getDeclinations
	expands = aspell_expand( txtResult.text )
	lstDeclinations.clear
	for ex in expands
		lstDeclinations.insertItem(ex)
	end
  end

  def removeWord(*k)
	return if lstInput.currentItem == -1
  
	nextItem = lstInput.currentItem < lstInput.count-1 ? lstInput.currentItem : lstInput.currentItem - 1
	
	puts "removing #{lstInput.currentText} from source"
	SrcList.delete( lstInput.currentText )
	lstInput.removeItem( lstInput.currentItem )
	lstInput.setCurrentItem( nextItem )
	lstInput.setSelected( nextItem, true )
	
	@wordsHandled += 1
	update_counters
  end

  def addWord(*k)
#	lstOutput.insertItem( txtResult.text )
#	@origWordMap[ txtResult.text ] = lstInput.currentText
	return if /[0-9]/.match( txtResult.text ) 
	add_word_to_dict( cmbDicts.currentText, txtResult.text )
	@wordsAdded += 1

	cnt = remove_derivatives_from_input( txtResult.text )
	@wordsHandled += cnt

#	txtResult.clear
#	lstOutput.clear
	
	update_counters
  end

  def addSuggestedWord(*k)
	txtResult.setText( lstSuggestions.currentText )
	addWord(k)
  end

  def remove_derivatives_from_input( txt )
	expands = aspell_expand( txt )

	cnt = 0
	@deletingInput = true
	for ex in expands
	  item = lstInput.findItem(ex, 0)
	  if item != nil
		puts "removing #{ex} from source"
		SrcList.delete( item.text )
		lstInput.takeItem( item ) 
		cnt += 1
	  end
	end
	@deletingInput = false

	currItem = lstInput.currentItem
	if currItem != -1
	  lstInput.setSelected( currItem, true )
	end

	cnt
  end

  def getWordBack(*k)
	return if lstOutput.currentItem == -1
	
	outText = lstOutput.currentText
	ot = outText.delete(' ').split(/[:]/)
	txtResult.setText( ot[1] )	
	lstOutput.removeItem( lstOutput.currentItem )

	remove_word_from_dict(ot[0], ot[1])
	@wordsRemoved += 1

	update_counters
  end

  def rawTextEdited()
	noText = txtResult.text == nil or txtResult.text == ''
	btnDefinition.setEnabled( !noText )
	btnStardict.setEnabled( !noText )
	return if noText
  
	getDeclinations
	
#	btnDecline.setEnabled(true)
	btnAdd.setEnabled( txtResult.text.length > 0 )
	btnDefinition.setEnabled( txtResult.text.length > 0 )
	btnStardict.setEnabled( txtResult.text.length > 0 )
	
#	puts get_word(txtResult.text) + "," + get_word(lstSuggestions.currentText)
	changed = (lstSuggestions.currentItem == -1 or get_word(txtResult.text) != get_word(lstSuggestions.currentText))
	btnFindSimilar.setEnabled(changed)
  end

  def suggSelected(*k)
	curText = lstSuggestions.currentText

	txtResult.setText( "" )
	
	matches = /[A-Za-z]+/.match(curText)
	switch_tab( matches[0] ) unless matches == nil

	txtResult.setText( lstSuggestions.currentText )

	populate_similar( get_word(curText) )
  end

  def populate_similar(txt)
	lstOutput.clear
	return if txt.empty?
  
  puts "finding similar for: #{txt}"
	founds = find_in_dicts( txt )
	exactMatchIndex = -1

	for found in founds
	  lstOutput.insertItem( "#{found[0]} : #{found[1]}" )

	  if get_word(found[1]) == txt
		exactMatchIndex = lstOutput.count - 1
#		lstOutput.setSelected( lstOutput.count - 1, true )
	  end
	end
	lstOutput.setCurrentItem( exactMatchIndex )
  end

  def findSimilar(*k)
	curText = txtResult.text
	populate_similar( get_word(curText) )
  end

  def wordSelected(*k)
	return if @deletingInput
  
	str = lstInput.currentText
	
puts "selected word: #{str}"	
	txtResult.setText('')

	suggestions = @stats.suggestions_by_suffix(str)

	lstSuggestions.clear
	lstSuggestions.insertItem(str)

	if suggestions != 0
	  first = true
	  for sugg in suggestions
		if sugg != nil
		  lstSuggestions.insertItem(str + "/" + sugg[0])
		  if first
			lstSuggestions.setSelected( lstSuggestions.count() - 1, true )
			first = false
		  end
		end
	  end
	else
	  suggestions = []
	  lstSuggestions.setSelected( 0, true )
	end
	
	if $aspellSuggestions
	  munches = aspell_munch( str )
	  for munch in munches
		if munch != nil and munch != str && ! suggestions.include?(munch)
		  lstSuggestions.insertItem( munch ) 
		end
	  end
	end
  end


  def switch_tab(flag)

	tab = get_tab(flag)
	return if @flagToBtns[ flag ] == nil

	for btn in @flagToBtns[ flag ]
	  btn.setChecked( true ) unless btn == nil
	end

	wordGroupTag.setCurrentPage(tab) if tab != nil
  end
  
  def get_tab(flag)
    if "abcdefghijklmnp".include?(flag)
	  tab = TAB_NOUN
    end
    if "ABIJKLMNGHCDEF".include?(flag)
	  tab = TAB_VERB
    end
    if "UVWY".include?(flag)
	  tab = TAB_ADJ
	end
	
	tab
  end

  def fill_dialog()
	for item in SrcList
	  lstInput.insertItem( item );
	end

	for item in DictList
	  if item != "base-abbr.lst" && item != "pronouns.lst"
		cmbDicts.insertItem( item );
		if item == "base.lst"
		  cmbDicts.setCurrentItem( cmbDicts.count - 1 )
		end
	  end
	end
  end

  def closeEvent( event )

	if @wordsHandled > 0 || @wordsAdded > 0 || @wordsRemoved > 0 || @wordsChanged > 0

	  if Qt::MessageBox.warning(self, "Підтвердження виходу", "Існують незбережені зміни! Що будемо робити?", "Повернутися", "Вийти") != 1
		return	  
	  end
		
	end

	event.accept()
  end

end

def split(str)
  if str.include?('/')
	str.split('/')
  else
	[ str, '' ]
  end
end

def split3(str)
  if str.include?('/')
	str.split('/') << '/'
  else
	[ str, '', '' ]
  end
end

def get_word(str)
  split(str)[0]
end

def get_flags(str)
  split(str)[1]
end


inputFile = nil

if ARGV.length >= 2 and ARGV[0] == '-f'
  inputFile = ARGV[1]
  if ! File.exist?(inputFile)
	exit 1
  end
end
puts "source file #{inputFile}"

if ARGV.length >= 3 and ARGV[2] == '-nas'
  $aspellSuggestions = false
end


load_source_list(inputFile)

a = Qt::Application.new(ARGV)
w = MyDlg.new

w.fill_dialog
w.update_counters

a.mainWidget = w
w.show
a.exec
