/* player-controller.c generated by valac 0.9.8, the Vala compiler
 * generated from player-controller.vala, do not modify */

/*
This service primarily controls PulseAudio and is driven by the sound indicator menu on the panel.
Copyright 2010 Canonical Ltd.

Authors:
    Conor Curran <conor.curran@canonical.com>

This program is free software: you can redistribute it and/or modify it 
under the terms of the GNU General Public License version 3, as published 
by the Free Software Foundation.

This program is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranties of 
MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along 
with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <libdbusmenu-glib/client.h>
#include <libdbusmenu-glib/menuitem-proxy.h>
#include <libdbusmenu-glib/menuitem.h>
#include <libdbusmenu-glib/server.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>


#define TYPE_PLAYER_CONTROLLER (player_controller_get_type ())
#define PLAYER_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PLAYER_CONTROLLER, PlayerController))
#define PLAYER_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PLAYER_CONTROLLER, PlayerControllerClass))
#define IS_PLAYER_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PLAYER_CONTROLLER))
#define IS_PLAYER_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PLAYER_CONTROLLER))
#define PLAYER_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PLAYER_CONTROLLER, PlayerControllerClass))

typedef struct _PlayerController PlayerController;
typedef struct _PlayerControllerClass PlayerControllerClass;
typedef struct _PlayerControllerPrivate PlayerControllerPrivate;

#define TYPE_PLAYER_ITEM (player_item_get_type ())
#define PLAYER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PLAYER_ITEM, PlayerItem))
#define PLAYER_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PLAYER_ITEM, PlayerItemClass))
#define IS_PLAYER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PLAYER_ITEM))
#define IS_PLAYER_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PLAYER_ITEM))
#define PLAYER_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PLAYER_ITEM, PlayerItemClass))

typedef struct _PlayerItem PlayerItem;
typedef struct _PlayerItemClass PlayerItemClass;

#define TYPE_MPRIS2_CONTROLLER (mpris2_controller_get_type ())
#define MPRIS2_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MPRIS2_CONTROLLER, Mpris2Controller))
#define MPRIS2_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MPRIS2_CONTROLLER, Mpris2ControllerClass))
#define IS_MPRIS2_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MPRIS2_CONTROLLER))
#define IS_MPRIS2_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MPRIS2_CONTROLLER))
#define MPRIS2_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MPRIS2_CONTROLLER, Mpris2ControllerClass))

typedef struct _Mpris2Controller Mpris2Controller;
typedef struct _Mpris2ControllerClass Mpris2ControllerClass;

#define PLAYER_CONTROLLER_TYPE_WIDGET_ORDER (player_controller_widget_order_get_type ())

#define PLAYER_CONTROLLER_TYPE_STATE (player_controller_state_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_TITLE_MENUITEM (title_menuitem_get_type ())
#define TITLE_MENUITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TITLE_MENUITEM, TitleMenuitem))
#define TITLE_MENUITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TITLE_MENUITEM, TitleMenuitemClass))
#define IS_TITLE_MENUITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TITLE_MENUITEM))
#define IS_TITLE_MENUITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TITLE_MENUITEM))
#define TITLE_MENUITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TITLE_MENUITEM, TitleMenuitemClass))

typedef struct _TitleMenuitem TitleMenuitem;
typedef struct _TitleMenuitemClass TitleMenuitemClass;

#define TYPE_METADATA_MENUITEM (metadata_menuitem_get_type ())
#define METADATA_MENUITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_METADATA_MENUITEM, MetadataMenuitem))
#define METADATA_MENUITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_METADATA_MENUITEM, MetadataMenuitemClass))
#define IS_METADATA_MENUITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_METADATA_MENUITEM))
#define IS_METADATA_MENUITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_METADATA_MENUITEM))
#define METADATA_MENUITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_METADATA_MENUITEM, MetadataMenuitemClass))

typedef struct _MetadataMenuitem MetadataMenuitem;
typedef struct _MetadataMenuitemClass MetadataMenuitemClass;

#define TYPE_TRANSPORT_MENUITEM (transport_menuitem_get_type ())
#define TRANSPORT_MENUITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRANSPORT_MENUITEM, TransportMenuitem))
#define TRANSPORT_MENUITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRANSPORT_MENUITEM, TransportMenuitemClass))
#define IS_TRANSPORT_MENUITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRANSPORT_MENUITEM))
#define IS_TRANSPORT_MENUITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRANSPORT_MENUITEM))
#define TRANSPORT_MENUITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRANSPORT_MENUITEM, TransportMenuitemClass))

typedef struct _TransportMenuitem TransportMenuitem;
typedef struct _TransportMenuitemClass TransportMenuitemClass;

#define TRANSPORT_MENUITEM_TYPE_STATE (transport_menuitem_state_get_type ())

struct _PlayerController {
	GObject parent_instance;
	PlayerControllerPrivate * priv;
	gint current_state;
	GeeArrayList* custom_items;
	Mpris2Controller* mpris_bridge;
};

struct _PlayerControllerClass {
	GObjectClass parent_class;
};

struct _PlayerControllerPrivate {
	DbusmenuMenuitem* root_menu;
	char* _name;
	GAppInfo* _app_info;
	gint _menu_offset;
};

typedef enum  {
	PLAYER_CONTROLLER_WIDGET_ORDER_SEPARATOR,
	PLAYER_CONTROLLER_WIDGET_ORDER_TITLE,
	PLAYER_CONTROLLER_WIDGET_ORDER_METADATA,
	PLAYER_CONTROLLER_WIDGET_ORDER_TRANSPORT
} PlayerControllerwidget_order;

typedef enum  {
	PLAYER_CONTROLLER_STATE_OFFLINE,
	PLAYER_CONTROLLER_STATE_INSTANTIATING,
	PLAYER_CONTROLLER_STATE_READY,
	PLAYER_CONTROLLER_STATE_CONNECTED,
	PLAYER_CONTROLLER_STATE_DISCONNECTED
} PlayerControllerstate;

typedef enum  {
	TRANSPORT_MENUITEM_STATE_PLAYING,
	TRANSPORT_MENUITEM_STATE_PAUSED
} TransportMenuitemstate;


static gpointer player_controller_parent_class = NULL;

GType player_controller_get_type (void) G_GNUC_CONST;
GType player_item_get_type (void) G_GNUC_CONST;
GType mpris2_controller_get_type (void) G_GNUC_CONST;
#define PLAYER_CONTROLLER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PLAYER_CONTROLLER, PlayerControllerPrivate))
enum  {
	PLAYER_CONTROLLER_DUMMY_PROPERTY,
	PLAYER_CONTROLLER_NAME,
	PLAYER_CONTROLLER_APP_INFO,
	PLAYER_CONTROLLER_MENU_OFFSET
};
GType player_controller_widget_order_get_type (void) G_GNUC_CONST;
GType player_controller_state_get_type (void) G_GNUC_CONST;
#define PLAYER_CONTROLLER_WIDGET_QUANTITY 4
PlayerController* player_controller_new (DbusmenuMenuitem* root, const char* client_name, gint offset, PlayerControllerstate initial_state);
PlayerController* player_controller_construct (GType object_type, DbusmenuMenuitem* root, const char* client_name, gint offset, PlayerControllerstate initial_state);
static char* player_controller_format_client_name (const char* client_name);
void player_controller_set_name (PlayerController* self, const char* value);
void player_controller_set_menu_offset (PlayerController* self, gint value);
static void player_controller_construct_widgets (PlayerController* self);
static void player_controller_establish_mpris_connection (PlayerController* self);
void player_controller_update_layout (PlayerController* self);
void player_controller_update_state (PlayerController* self, PlayerControllerstate new_state);
const char* player_controller_get_name (PlayerController* self);
void player_controller_activate (PlayerController* self);
void player_controller_instantiate (PlayerController* self);
GAppInfo* player_controller_get_app_info (PlayerController* self);
Mpris2Controller* mpris2_controller_new (PlayerController* ctrl);
Mpris2Controller* mpris2_controller_construct (GType object_type, PlayerController* ctrl);
void player_controller_determine_state (PlayerController* self);
void player_controller_vanish (PlayerController* self);
void player_controller_hibernate (PlayerController* self);
void player_item_reset (PlayerItem* self, GeeHashSet* attrs);
GeeHashSet* transport_menuitem_attributes_format (void);
GeeHashSet* metadata_menuitem_attributes_format (void);
GType title_menuitem_get_type (void) G_GNUC_CONST;
void title_menuitem_toggle_active_triangle (TitleMenuitem* self, gboolean update);
gboolean player_item_populated (PlayerItem* self, GeeHashSet* attrs);
PlayerItem* player_item_new (const char* type);
PlayerItem* player_item_construct (GType object_type, const char* type);
TitleMenuitem* title_menuitem_new (PlayerController* parent);
TitleMenuitem* title_menuitem_construct (GType object_type, PlayerController* parent);
MetadataMenuitem* metadata_menuitem_new (void);
MetadataMenuitem* metadata_menuitem_construct (GType object_type);
GType metadata_menuitem_get_type (void) G_GNUC_CONST;
TransportMenuitem* transport_menuitem_new (PlayerController* parent);
TransportMenuitem* transport_menuitem_construct (GType object_type, PlayerController* parent);
GType transport_menuitem_get_type (void) G_GNUC_CONST;
gint player_controller_get_menu_offset (PlayerController* self);
gboolean mpris2_controller_connected (Mpris2Controller* self);
GType transport_menuitem_state_get_type (void) G_GNUC_CONST;
void transport_menuitem_change_play_state (TransportMenuitem* self, TransportMenuitemstate update);
void player_controller_set_app_info (PlayerController* self, GAppInfo* value);
static void player_controller_finalize (GObject* obj);
static void player_controller_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void player_controller_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);



GType player_controller_widget_order_get_type (void) {
	static volatile gsize player_controller_widget_order_type_id__volatile = 0;
	if (g_once_init_enter (&player_controller_widget_order_type_id__volatile)) {
		static const GEnumValue values[] = {{PLAYER_CONTROLLER_WIDGET_ORDER_SEPARATOR, "PLAYER_CONTROLLER_WIDGET_ORDER_SEPARATOR", "separator"}, {PLAYER_CONTROLLER_WIDGET_ORDER_TITLE, "PLAYER_CONTROLLER_WIDGET_ORDER_TITLE", "title"}, {PLAYER_CONTROLLER_WIDGET_ORDER_METADATA, "PLAYER_CONTROLLER_WIDGET_ORDER_METADATA", "metadata"}, {PLAYER_CONTROLLER_WIDGET_ORDER_TRANSPORT, "PLAYER_CONTROLLER_WIDGET_ORDER_TRANSPORT", "transport"}, {0, NULL, NULL}};
		GType player_controller_widget_order_type_id;
		player_controller_widget_order_type_id = g_enum_register_static ("PlayerControllerwidget_order", values);
		g_once_init_leave (&player_controller_widget_order_type_id__volatile, player_controller_widget_order_type_id);
	}
	return player_controller_widget_order_type_id__volatile;
}


GType player_controller_state_get_type (void) {
	static volatile gsize player_controller_state_type_id__volatile = 0;
	if (g_once_init_enter (&player_controller_state_type_id__volatile)) {
		static const GEnumValue values[] = {{PLAYER_CONTROLLER_STATE_OFFLINE, "PLAYER_CONTROLLER_STATE_OFFLINE", "offline"}, {PLAYER_CONTROLLER_STATE_INSTANTIATING, "PLAYER_CONTROLLER_STATE_INSTANTIATING", "instantiating"}, {PLAYER_CONTROLLER_STATE_READY, "PLAYER_CONTROLLER_STATE_READY", "ready"}, {PLAYER_CONTROLLER_STATE_CONNECTED, "PLAYER_CONTROLLER_STATE_CONNECTED", "connected"}, {PLAYER_CONTROLLER_STATE_DISCONNECTED, "PLAYER_CONTROLLER_STATE_DISCONNECTED", "disconnected"}, {0, NULL, NULL}};
		GType player_controller_state_type_id;
		player_controller_state_type_id = g_enum_register_static ("PlayerControllerstate", values);
		g_once_init_leave (&player_controller_state_type_id__volatile, player_controller_state_type_id);
	}
	return player_controller_state_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static char* string_strip (const char* self) {
	char* result = NULL;
	char* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_result_ = g_strdup (self);
	g_strstrip (_result_);
	result = _result_;
	return result;
}


PlayerController* player_controller_construct (GType object_type, DbusmenuMenuitem* root, const char* client_name, gint offset, PlayerControllerstate initial_state) {
	PlayerController * self;
	DbusmenuMenuitem* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
	GeeArrayList* _tmp3_;
	g_return_val_if_fail (root != NULL, NULL);
	g_return_val_if_fail (client_name != NULL, NULL);
	self = (PlayerController*) g_object_new (object_type, NULL);
	self->priv->root_menu = (_tmp0_ = _g_object_ref0 (root), _g_object_unref0 (self->priv->root_menu), _tmp0_);
	player_controller_set_name (self, _tmp2_ = player_controller_format_client_name (_tmp1_ = string_strip (client_name)));
	_g_free0 (_tmp2_);
	_g_free0 (_tmp1_);
	self->custom_items = (_tmp3_ = gee_array_list_new (TYPE_PLAYER_ITEM, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL), _g_object_unref0 (self->custom_items), _tmp3_);
	self->current_state = (gint) initial_state;
	player_controller_set_menu_offset (self, offset);
	player_controller_construct_widgets (self);
	player_controller_establish_mpris_connection (self);
	player_controller_update_layout (self);
	return self;
}


PlayerController* player_controller_new (DbusmenuMenuitem* root, const char* client_name, gint offset, PlayerControllerstate initial_state) {
	return player_controller_construct (TYPE_PLAYER_CONTROLLER, root, client_name, offset, initial_state);
}


void player_controller_update_state (PlayerController* self, PlayerControllerstate new_state) {
	g_return_if_fail (self != NULL);
	g_debug ("player-controller.vala:69: update_state - player controller %s : new s" \
"tate %i", self->priv->_name, (gint) new_state);
	self->current_state = (gint) new_state;
	player_controller_update_layout (self);
}


void player_controller_activate (PlayerController* self) {
	g_return_if_fail (self != NULL);
	player_controller_establish_mpris_connection (self);
}


void player_controller_instantiate (PlayerController* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_debug ("player-controller.vala:87: instantiate in player controller for %s", self->priv->_name);
	{
		g_app_info_launch (self->priv->_app_info, NULL, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch4_g_error;
		}
		player_controller_update_state (self, PLAYER_CONTROLLER_STATE_INSTANTIATING);
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("player-controller.vala:93: Failed to launch app %s with error message:" \
" %s", self->priv->_name, _error_->message);
			_g_error_free0 (_error_);
		}
	}
	__finally4:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void player_controller_establish_mpris_connection (PlayerController* self) {
	Mpris2Controller* _tmp0_;
	g_return_if_fail (self != NULL);
	if (self->current_state != PLAYER_CONTROLLER_STATE_READY) {
		g_debug ("player-controller.vala:100: establish_mpris_connection - Not ready to " \
"connect");
		return;
	}
	self->mpris_bridge = (_tmp0_ = mpris2_controller_new (self), _g_object_unref0 (self->mpris_bridge), _tmp0_);
	player_controller_determine_state (self);
}


void player_controller_vanish (PlayerController* self) {
	g_return_if_fail (self != NULL);
	{
		GeeIterator* _item_it;
		_item_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->custom_items);
		while (TRUE) {
			DbusmenuMenuitem* item;
			if (!gee_iterator_next (_item_it)) {
				break;
			}
			item = (DbusmenuMenuitem*) ((PlayerItem*) gee_iterator_get (_item_it));
			dbusmenu_menuitem_child_delete (self->priv->root_menu, item);
			_g_object_unref0 (item);
		}
		_g_object_unref0 (_item_it);
	}
}


void player_controller_hibernate (PlayerController* self) {
	PlayerItem* _tmp0_;
	GeeHashSet* _tmp1_;
	PlayerItem* _tmp2_;
	GeeHashSet* _tmp3_;
	PlayerItem* _tmp4_;
	TitleMenuitem* title;
	g_return_if_fail (self != NULL);
	player_controller_update_state (self, PLAYER_CONTROLLER_STATE_OFFLINE);
	player_item_reset (_tmp0_ = (PlayerItem*) gee_abstract_list_get ((GeeAbstractList*) self->custom_items, (gint) PLAYER_CONTROLLER_WIDGET_ORDER_TRANSPORT), _tmp1_ = transport_menuitem_attributes_format ());
	_g_object_unref0 (_tmp1_);
	_g_object_unref0 (_tmp0_);
	player_item_reset (_tmp2_ = (PlayerItem*) gee_abstract_list_get ((GeeAbstractList*) self->custom_items, (gint) PLAYER_CONTROLLER_WIDGET_ORDER_METADATA), _tmp3_ = metadata_menuitem_attributes_format ());
	_g_object_unref0 (_tmp3_);
	_g_object_unref0 (_tmp2_);
	title = (_tmp4_ = (PlayerItem*) gee_abstract_list_get ((GeeAbstractList*) self->custom_items, (gint) PLAYER_CONTROLLER_WIDGET_ORDER_TITLE), IS_TITLE_MENUITEM (_tmp4_) ? ((TitleMenuitem*) _tmp4_) : NULL);
	title_menuitem_toggle_active_triangle (title, FALSE);
	_g_object_unref0 (title);
}


void player_controller_update_layout (PlayerController* self) {
	PlayerItem* _tmp2_;
	PlayerItem* _tmp3_;
	GeeHashSet* _tmp4_;
	PlayerItem* _tmp5_;
	g_return_if_fail (self != NULL);
	if (self->current_state != PLAYER_CONTROLLER_STATE_CONNECTED) {
		PlayerItem* _tmp0_;
		PlayerItem* _tmp1_;
		dbusmenu_menuitem_property_set_bool ((DbusmenuMenuitem*) (_tmp0_ = (PlayerItem*) gee_abstract_list_get ((GeeAbstractList*) self->custom_items, (gint) PLAYER_CONTROLLER_WIDGET_ORDER_TRANSPORT)), DBUSMENU_MENUITEM_PROP_VISIBLE, FALSE);
		_g_object_unref0 (_tmp0_);
		dbusmenu_menuitem_property_set_bool ((DbusmenuMenuitem*) (_tmp1_ = (PlayerItem*) gee_abstract_list_get ((GeeAbstractList*) self->custom_items, (gint) PLAYER_CONTROLLER_WIDGET_ORDER_METADATA)), DBUSMENU_MENUITEM_PROP_VISIBLE, FALSE);
		_g_object_unref0 (_tmp1_);
		return;
	}
	dbusmenu_menuitem_property_set_bool ((DbusmenuMenuitem*) (_tmp2_ = (PlayerItem*) gee_abstract_list_get ((GeeAbstractList*) self->custom_items, (gint) PLAYER_CONTROLLER_WIDGET_ORDER_METADATA)), DBUSMENU_MENUITEM_PROP_VISIBLE, player_item_populated (_tmp3_ = (PlayerItem*) gee_abstract_list_get ((GeeAbstractList*) self->custom_items, (gint) PLAYER_CONTROLLER_WIDGET_ORDER_METADATA), _tmp4_ = metadata_menuitem_attributes_format ()));
	_g_object_unref0 (_tmp4_);
	_g_object_unref0 (_tmp3_);
	_g_object_unref0 (_tmp2_);
	dbusmenu_menuitem_property_set_bool ((DbusmenuMenuitem*) (_tmp5_ = (PlayerItem*) gee_abstract_list_get ((GeeAbstractList*) self->custom_items, (gint) PLAYER_CONTROLLER_WIDGET_ORDER_TRANSPORT)), DBUSMENU_MENUITEM_PROP_VISIBLE, TRUE);
	_g_object_unref0 (_tmp5_);
}


static void player_controller_construct_widgets (PlayerController* self) {
	PlayerItem* _tmp0_;
	TitleMenuitem* title_menu_item;
	MetadataMenuitem* metadata_item;
	TransportMenuitem* transport_item;
	g_return_if_fail (self != NULL);
	gee_abstract_collection_add ((GeeAbstractCollection*) self->custom_items, _tmp0_ = player_item_new (DBUSMENU_CLIENT_TYPES_SEPARATOR));
	_g_object_unref0 (_tmp0_);
	title_menu_item = title_menuitem_new (self);
	gee_abstract_collection_add ((GeeAbstractCollection*) self->custom_items, (PlayerItem*) title_menu_item);
	metadata_item = metadata_menuitem_new ();
	gee_abstract_collection_add ((GeeAbstractCollection*) self->custom_items, (PlayerItem*) metadata_item);
	transport_item = transport_menuitem_new (self);
	gee_abstract_collection_add ((GeeAbstractCollection*) self->custom_items, (PlayerItem*) transport_item);
	{
		GeeIterator* _item_it;
		_item_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->custom_items);
		while (TRUE) {
			PlayerItem* item;
			if (!gee_iterator_next (_item_it)) {
				break;
			}
			item = (PlayerItem*) gee_iterator_get (_item_it);
			dbusmenu_menuitem_child_add_position (self->priv->root_menu, (DbusmenuMenuitem*) item, (guint) (self->priv->_menu_offset + gee_abstract_list_index_of ((GeeAbstractList*) self->custom_items, item)));
			_g_object_unref0 (item);
		}
		_g_object_unref0 (_item_it);
	}
	_g_object_unref0 (transport_item);
	_g_object_unref0 (metadata_item);
	_g_object_unref0 (title_menu_item);
}


static glong string_get_length (const char* self) {
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	result = g_utf8_strlen (self, (gssize) (-1));
	return result;
}


static char* string_slice (const char* self, glong start, glong end) {
	char* result = NULL;
	glong string_length;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	const char* start_string;
	g_return_val_if_fail (self != NULL, NULL);
	string_length = string_get_length (self);
	if (start < 0) {
		start = string_length + start;
	}
	if (end < 0) {
		end = string_length + end;
	}
	if (start >= 0) {
		_tmp0_ = start <= string_length;
	} else {
		_tmp0_ = FALSE;
	}
	g_return_val_if_fail (_tmp0_, NULL);
	if (end >= 0) {
		_tmp1_ = end <= string_length;
	} else {
		_tmp1_ = FALSE;
	}
	g_return_val_if_fail (_tmp1_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	start_string = g_utf8_offset_to_pointer (self, start);
	result = g_strndup (start_string, ((gchar*) g_utf8_offset_to_pointer (start_string, end - start)) - ((gchar*) start_string));
	return result;
}


static char* player_controller_format_client_name (const char* client_name) {
	char* result = NULL;
	char* formatted;
	g_return_val_if_fail (client_name != NULL, NULL);
	formatted = g_strdup (client_name);
	if (g_utf8_strlen (formatted, -1) > 1) {
		char* _tmp0_;
		char* _tmp1_;
		char* _tmp2_;
		formatted = (_tmp2_ = g_strconcat (_tmp0_ = g_utf8_strup (client_name, (gssize) 1), _tmp1_ = string_slice (client_name, (glong) 1, g_utf8_strlen (client_name, -1)), NULL), _g_free0 (formatted), _tmp2_);
		_g_free0 (_tmp1_);
		_g_free0 (_tmp0_);
		g_debug ("player-controller.vala:165: PlayerController->format_client_name - : %" \
"s", formatted);
	}
	result = formatted;
	return result;
}


void player_controller_determine_state (PlayerController* self) {
	g_return_if_fail (self != NULL);
	if (mpris2_controller_connected (self->mpris_bridge) == TRUE) {
		PlayerItem* _tmp0_;
		TitleMenuitem* title;
		PlayerItem* _tmp1_;
		TransportMenuitem* transport;
		player_controller_update_state (self, PLAYER_CONTROLLER_STATE_CONNECTED);
		title = (_tmp0_ = (PlayerItem*) gee_abstract_list_get ((GeeAbstractList*) self->custom_items, (gint) PLAYER_CONTROLLER_WIDGET_ORDER_TITLE), IS_TITLE_MENUITEM (_tmp0_) ? ((TitleMenuitem*) _tmp0_) : NULL);
		title_menuitem_toggle_active_triangle (title, TRUE);
		transport = (_tmp1_ = (PlayerItem*) gee_abstract_list_get ((GeeAbstractList*) self->custom_items, (gint) PLAYER_CONTROLLER_WIDGET_ORDER_TRANSPORT), IS_TRANSPORT_MENUITEM (_tmp1_) ? ((TransportMenuitem*) _tmp1_) : NULL);
		transport_menuitem_change_play_state (transport, TRANSPORT_MENUITEM_STATE_PAUSED);
		_g_object_unref0 (transport);
		_g_object_unref0 (title);
	} else {
		player_controller_update_state (self, PLAYER_CONTROLLER_STATE_DISCONNECTED);
	}
}


const char* player_controller_get_name (PlayerController* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_name;
	return result;
}


void player_controller_set_name (PlayerController* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_name = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_name), _tmp0_);
	g_object_notify ((GObject *) self, "name");
}


GAppInfo* player_controller_get_app_info (PlayerController* self) {
	GAppInfo* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_app_info;
	return result;
}


void player_controller_set_app_info (PlayerController* self, GAppInfo* value) {
	GAppInfo* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_app_info = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_app_info), _tmp0_);
	g_object_notify ((GObject *) self, "app-info");
}


gint player_controller_get_menu_offset (PlayerController* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_menu_offset;
	return result;
}


void player_controller_set_menu_offset (PlayerController* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_menu_offset = value;
	g_object_notify ((GObject *) self, "menu-offset");
}


static void player_controller_class_init (PlayerControllerClass * klass) {
	player_controller_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (PlayerControllerPrivate));
	G_OBJECT_CLASS (klass)->get_property = player_controller_get_property;
	G_OBJECT_CLASS (klass)->set_property = player_controller_set_property;
	G_OBJECT_CLASS (klass)->finalize = player_controller_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLAYER_CONTROLLER_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLAYER_CONTROLLER_APP_INFO, g_param_spec_object ("app-info", "app-info", "app-info", G_TYPE_APP_INFO, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLAYER_CONTROLLER_MENU_OFFSET, g_param_spec_int ("menu-offset", "menu-offset", "menu-offset", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void player_controller_instance_init (PlayerController * self) {
	self->priv = PLAYER_CONTROLLER_GET_PRIVATE (self);
	self->current_state = (gint) PLAYER_CONTROLLER_STATE_OFFLINE;
}


static void player_controller_finalize (GObject* obj) {
	PlayerController * self;
	self = PLAYER_CONTROLLER (obj);
	_g_object_unref0 (self->priv->root_menu);
	_g_free0 (self->priv->_name);
	_g_object_unref0 (self->custom_items);
	_g_object_unref0 (self->mpris_bridge);
	_g_object_unref0 (self->priv->_app_info);
	G_OBJECT_CLASS (player_controller_parent_class)->finalize (obj);
}


GType player_controller_get_type (void) {
	static volatile gsize player_controller_type_id__volatile = 0;
	if (g_once_init_enter (&player_controller_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PlayerControllerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) player_controller_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PlayerController), 0, (GInstanceInitFunc) player_controller_instance_init, NULL };
		GType player_controller_type_id;
		player_controller_type_id = g_type_register_static (G_TYPE_OBJECT, "PlayerController", &g_define_type_info, 0);
		g_once_init_leave (&player_controller_type_id__volatile, player_controller_type_id);
	}
	return player_controller_type_id__volatile;
}


static void player_controller_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	PlayerController * self;
	self = PLAYER_CONTROLLER (object);
	switch (property_id) {
		case PLAYER_CONTROLLER_NAME:
		g_value_set_string (value, player_controller_get_name (self));
		break;
		case PLAYER_CONTROLLER_APP_INFO:
		g_value_set_object (value, player_controller_get_app_info (self));
		break;
		case PLAYER_CONTROLLER_MENU_OFFSET:
		g_value_set_int (value, player_controller_get_menu_offset (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void player_controller_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	PlayerController * self;
	self = PLAYER_CONTROLLER (object);
	switch (property_id) {
		case PLAYER_CONTROLLER_NAME:
		player_controller_set_name (self, g_value_get_string (value));
		break;
		case PLAYER_CONTROLLER_APP_INFO:
		player_controller_set_app_info (self, g_value_get_object (value));
		break;
		case PLAYER_CONTROLLER_MENU_OFFSET:
		player_controller_set_menu_offset (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




