#ifndef BCM43xx_VSTACK_H_
#define BCM43xx_VSTACK_H_

#include <linux/types.h>


/* A generic implementation of a value-stack to
 * backup random values and restore them in random order.
 */

struct bcm43xx_wldev;

enum bcm43xx_vstack_type {
	BCM43xx_VSTACK_PHY	= 0x0,
	BCM43xx_VSTACK_RADIO	= 0x1,
	BCM43xx_VSTACK_ILT	= 0x2,
	BCM43xx_VSTACK_MMIO	= 0x3,
};

struct bcm43xx_vstack_item {
	u16 offset_type;
	u16 value;
};

struct bcm43xx_vstack {
	struct bcm43xx_vstack_item *items;
	struct bcm43xx_wldev *dev;
	u8 nr_items;
	u8 top;
};

/* Static allocation.
 * Note that stacksize must be < 255.
 */
#define BCM43xx_VSTACK_STATIC(bcm, stackname, stacksize)		\
	struct bcm43xx_vstack_item stackname##_items[(stacksize)];	\
	struct bcm43xx_vstack stackname = {				\
		.items		= stackname##_items,			\
		.nr_items	= (stacksize),				\
		.top		= 0,					\
		.bcm		= (bcm),				\
	};

/* Dynamic allocation.
 * Note that size must be < 255.
 */
int bcm43xx_vstack_alloc(struct bcm43xx_wldev *dev,
			 struct bcm43xx_vstack *stack,
			 u8 size,
			 gfp_t gfp_flags);
void bcm43xx_vstack_free(struct bcm43xx_vstack *stack);
void bcm43xx_vstack_cleanup(struct bcm43xx_vstack *stack);

/* Stack save/restore */
void bcm43xx_phy_stacksave(struct bcm43xx_vstack *stack,
			   u16 offset);
void bcm43xx_phy_stackrestore(struct bcm43xx_vstack *stack,
			      u16 offset);

void bcm43xx_radio_stacksave(struct bcm43xx_vstack *stack,
			     u16 offset);
void bcm43xx_radio_stackrestore(struct bcm43xx_vstack *stack,
				u16 offset);

void bcm43xx_ilt_stacksave(struct bcm43xx_vstack *stack,
			   u16 offset);
void bcm43xx_ilt_stackrestore(struct bcm43xx_vstack *stack,
			      u16 offset);

void bcm43xx_mmio_stacksave(struct bcm43xx_vstack *stack,
			    u16 offset);
void bcm43xx_mmio_stackrestore(struct bcm43xx_vstack *stack,
			       u16 offset);

/* Lowlevel save/restore. */
void bcm43xx_vstack_save(struct bcm43xx_vstack *stack,
			 enum bcm43xx_vstack_type type,
			 u16 offset, u16 value);
u16 bcm43xx_vstack_restore(struct bcm43xx_vstack *stack,
			   enum bcm43xx_vstack_type type,
			   u16 offset);

#endif /* BCM43xx_VSTACK_H_ */
