/*
 * things we only need in the kernel when cfg80211 is modular.
 *
 * Copyright 2007	Johannes Berg <johannes@sipsolutions.net>
 */

#include "wext.h"

EXPORT_SYMBOL_GPL(wext_standard_ioctl);
EXPORT_SYMBOL_GPL(wext_standard_ioctl_num);
EXPORT_SYMBOL_GPL(get_wireless_stats);

struct cfg80211_ioctl_ops cfg80211_ioctl_ops;
EXPORT_SYMBOL_GPL(cfg80211_ioctl_ops);

int call_cfg80211_wext_ioctl(struct ifreq *ifr, unsigned int cmd)
{
	int err = -ENOSYS;

	if (!try_module_get(cfg80211_ioctl_ops.module))
		return -ENOSYS;

	if (cfg80211_ioctl_ops.do_wext_ioctl)
		err = cfg80211_ioctl_ops.do_wext_ioctl(ifr, cmd);

	module_put(cfg80211_ioctl_ops.module);

	return err;
}
