/*
 * Line6 PODxt Pro USB driver - 0.5
 *
 * Copyright (C) 2004, 2005 Markus Grabner (grabner@icg.tu-graz.ac.at)
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation, version 2.
 *
 */

#ifndef CONFIG_H
#define CONFIG_H


#include <linux/version.h>


/**
   Development tools.
*/
#define DO_DEBUG_MESSAGES   1
#define DO_URB_DUMP_SEND    0
#define DO_URB_DUMP_RECEIVE 0
#define CREATE_RAW_FILE     0

/**
   Character device settings.
*/
#define USE_CHARACTER_DEVICE 0
#if USE_CHARACTER_DEVICE
#define PODXTPRO_CHRDEV_MAJOR 234
#define PODXTPRO_CHRDEV_NAME "pod"
#endif

/**
   In Linux 2.6.12 and later, the device_attribute is passed to the sysfs
   get/set functions.
*/
#if LINUX_VERSION_CODE >= 132620
#define DEVICE_ATTRIBUTE struct device_attribute *attr,
#else
#define DEVICE_ATTRIBUTE
#endif


#endif
