/*
 * Copyright (C) 2011 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Ken VanDine <ken@vandine.org>
 */

public class StatusBar : Gtk.InfoBar
{
  private string _message;
  private Gtk.Label _message_label;
  private Gtk.Container _content_area;

  private Gwibber.Service _service;

  private bool _showing = false;

  public bool showing {
    get {
      return _showing;
    }
    set {
      _showing = value;
      if (_showing)
      {
        show ();
        queue_draw ();
      }
      else
      {
        hide ();
        queue_draw ();
      }
    }
  }

  public string message {
    get {
      return _message;
    }
    set {
      if (_message != value)
      {
        _message = value;
        _message_label.set_markup ("<b>" + _message + "</b>");
      }
    }
  }

  public StatusBar ()
  {
    Object ();
  }

  construct
  {
    _message = "";
    set_no_show_all (true);
    set_message_type (Gtk.MessageType.OTHER);
    _content_area = get_content_area () as Gtk.Container;
    _message_label = new Gtk.Label (message);
    _message_label.set_alignment (0.0f, 0.5f);
    _message_label.set_use_markup (true);
    _content_area.add (_message_label);
    _message_label.show ();

    notify["showing"].connect (()=>
    {
    });
  }
  
  public void reset () 
  {
    message = "";
    var _action_area = get_action_area () as Gtk.Container;
    foreach (var _w in _action_area.get_children ())
    {
      if (_w is Gtk.Widget)
        _w.destroy ();
    }
  }
}
