import gtk, pango, webkit, gnomekeyring
import urllib, urllib2, json, urlparse, uuid
from oauth import oauth

from gtk import Builder
from gwibber.microblog.util import resources
import gettext
from gettext import gettext as _
if hasattr(gettext, 'bind_textdomain_codeset'):
    gettext.bind_textdomain_codeset('gwibber','UTF-8')
gettext.textdomain('gwibber')

gtk.gdk.threads_init()

sigmeth = oauth.OAuthSignatureMethod_HMAC_SHA1()

CLIENT_ID = "BA0GOA0K3PTRS1KUJ5TTZ1P3GDRH3VJEEXY4N44ROPUJYKPW"
CLIENT_SECRET = "TS1LGTEZSJATQG22K5SXNASF021KPXI5LJTBQOVTX4JGOTYH"
REDIRECT_URI = "http://gwibber.com/0/auth.html"

class AccountWidget(gtk.VBox):
  """AccountWidget: A widget that provides a user interface for configuring foursquare accounts in Gwibber
  """
  
  def __init__(self, account=None, dialog=None):
    """Creates the account pane for configuring Foursquare accounts"""
    gtk.VBox.__init__( self, False, 20 )
    self.ui = gtk.Builder()
    self.ui.set_translation_domain ("gwibber")
    self.ui.add_from_file (resources.get_ui_asset("gwibber-accounts-foursquare.ui"))
    self.ui.connect_signals(self)
    self.vbox_settings = self.ui.get_object("vbox_settings")
    self.pack_start(self.vbox_settings, False, False)
    self.show_all()

    self.account = account or {}
    self.dialog = dialog
    has_secret_key = True
    if self.account.has_key("id"):
      try:
        value = gnomekeyring.find_items_sync(gnomekeyring.ITEM_GENERIC_SECRET, {"id": str("%s/%s" % (self.account["id"], "secret_token"))})[0].secret
      except gnomekeyring.NoMatchError:
        has_secret_key = False

    try:
      if self.account.has_key("access_token") and self.account.has_key("secret_token") and self.account.has_key("username") and has_secret_key and not self.dialog.condition:
        self.ui.get_object("hbox_foursquare_auth").hide()
        self.ui.get_object("foursquare_auth_done_label").set_label(_("%s has been authorized by Foursquare") % self.account["username"])
        self.ui.get_object("hbox_foursquare_auth_done").show()
      else:
        self.ui.get_object("hbox_foursquare_auth_done").hide()
        if self.dialog.ui:
          self.dialog.ui.get_object('vbox_create').hide()
    except:
      self.ui.get_object("hbox_foursquare_auth_done").hide()
      if self.dialog.ui:
        self.dialog.ui.get_object("vbox_create").hide()


  def on_foursquare_auth_clicked(self, widget, data=None):
    self.winsize = self.window.get_size()

    web = webkit.WebView()
    web.get_settings().set_property("enable-plugins", False)
    web.load_html_string(_("<p>Please wait...</p>"), "file:///")
    
    url = 'https://foursquare.com/oauth2/authenticate?client_id=' + CLIENT_ID + '&response_type=code&display=touch&redirect_uri='+ REDIRECT_URI
 
    web.load_uri(url)
    web.set_size_request(500, 400)
    web.connect("title-changed", self.on_foursquare_auth_title_change)

    self.scroll = gtk.ScrolledWindow()
    self.scroll.add(web)

    self.pack_start(self.scroll, True, True, 0)
    self.show_all()

    self.ui.get_object("vbox1").hide()
    self.ui.get_object("vbox_advanced").hide()
    self.dialog.infobar.set_message_type(gtk.MESSAGE_INFO)

  def on_foursquare_auth_title_change(self, web=None, title=None, data=None):
    saved = False
    if title.get_title() == "Success":

      if hasattr(self.dialog, "infobar_content_area"):
        for child in self.dialog.infobar_content_area.get_children(): child.destroy()
      self.dialog.infobar_content_area = self.dialog.infobar.get_content_area()
      self.dialog.infobar_content_area.show()
      self.dialog.infobar.show()

      message_label = gtk.Label(_("Verifying"))
      message_label.set_use_markup(True)
      message_label.set_ellipsize(pango.ELLIPSIZE_END)
      self.dialog.infobar_content_area.add(message_label)
      self.dialog.infobar.show_all()
      self.scroll.hide()
      
      #Get the code from the callback uri (it's formatted as http://gwibber.com/0/auth.html/?code=CODE)
      url = web.get_main_frame().get_uri()
      data = urlparse.parse_qs(url.split("?", 1)[1])
      self.code = data["code"][0]
      
      self.ui.get_object("vbox1").show()
      self.ui.get_object("vbox_advanced").show()

      #Exchange the code for an access token
      url = "https://foursquare.com/oauth2/access_token?client_id=" + CLIENT_ID + "&client_secret=" + CLIENT_SECRET + "&grant_type=authorization_code&redirect_uri=" + REDIRECT_URI + "&code=" + self.code
      self.access_token = json.load(urllib2.urlopen(url))['access_token']
      self.account["access_token"] = self.access_token
      self.account["secret_token"] = self.access_token
      
      #Make a request with our new token for the user's own data
      url = "https://api.foursquare.com/v2/users/self?oauth_token=" + self.access_token
      data = json.load(urllib2.urlopen(url))
      fullname = ""
      if data["response"]["user"].has_key("firstName"):
         fullname += data["response"]["user"]["firstName"] + " "
      if data["response"]["user"].has_key("lastName"):
        fullname += data["response"]["user"]["lastName"]
      self.account["username"] = fullname
      self.account["user_id"] = data["response"]["user"]["id"]

      if isinstance(data, dict):
        data = data["response"]["user"]
        if data.has_key("id"):
          saved = self.dialog.on_edit_account_save()
        else:
          print "Failed"
          self.dialog.infobar.set_message_type(gtk.MESSAGE_ERROR)
          message_label.set_text(_("Authorization failed. Please try again.")) 
      else:
        print "Failed"
        self.dialog.infobar.set_message_type(gtk.MESSAGE_ERROR)
        message_label.set_text(_("Authorization failed. Please try again."))

      if saved: 
        message_label.set_text(_("Successful"))
        self.dialog.infobar.set_message_type(gtk.MESSAGE_INFO)
        #self.dialog.infobar.hide()

      self.ui.get_object("hbox_foursquare_auth").hide()
      self.ui.get_object("foursquare_auth_done_label").set_label(_("%s has been authorized by Foursquare") % str(self.account["username"]))
      self.ui.get_object("hbox_foursquare_auth_done").show()
      if self.dialog.ui and self.account.has_key("id") and not saved:
        self.dialog.ui.get_object("vbox_save").show()
      elif self.dialog.ui and not saved:
        self.dialog.ui.get_object("vbox_create").show()

    self.window.resize(*self.winsize)

    if title.get_title() == "Failure":
      web.hide()
      self.dialog.infobar.set_message_type(gtk.MESSAGE_ERROR)
      message_label.set_text(_("Authorization failed. Please try again."))
      self.dialog.infobar.show_all()

      self.ui.get_object("vbox1").show()
      self.ui.get_object("vbox_advanced").show()
      self.window.resize(*self.winsize)
