/*
 * Copyright (C) 2011 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.

 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Ken VanDine <ken@vandine.org>
 */

public class SearchesItem : TabBarItem
{
  private Gtk.Alignment _align;
  private Gtk.HBox box;
  private Gtk.HBox _view;
  private GwibberGtk.SearchView _search_view;
  private GwibberGtk.StreamView _stream_view;
  public Gwibber.Streams streams { get; construct; }
  private Gtk.Label _title;
  private ulong active_hander_id;
  private Gtk.Entry _entry;
  private Gwibber.Searches _searches;

  public SearchesItem (Gwibber.Streams streams)
  {
    Object (stream:"search", icon_name:"stock_search", tooltip:_("Searches"), streams:streams);
  }

  construct
  {
    // View
    _view = new Gtk.HBox(true, 0);
    _view.set_no_show_all(true);
    _view.show();

    _search_view = new GwibberGtk.SearchView ();
    _search_view.show_all ();
    
    _stream_view = new GwibberGtk.StreamView ();
    _stream_view.set_no_show_all (true);
    _stream_view.notify["prepared"].connect (() => {
      _stream_view.set_no_show_all (false);
      _stream_view.show_all ();
    });

    _searches = new Gwibber.Searches ();

    _view.pack_start(_search_view, true, true, 0);
    _view.pack_start(_stream_view, true, true, 0);


    // Toolbar
    _align = new Gtk.Alignment (0.5f, 0.5f, 1.0f, 1.0f);

    box = new Gtk.HBox (false, 12);
    _align.add (box);

    _entry = new Gtk.Entry ();
    _entry.set_icon_from_stock (Gtk.EntryIconPosition.SECONDARY, "gtk-clear");

    _entry.icon_press.connect ((pos, event) => {
      if (pos == Gtk.EntryIconPosition.SECONDARY)
      _entry.set_text ("");
    });

    _entry.key_press_event.connect ((t, e)=>
    {
      if (e.keyval == 65307) // Escape
      {
        _entry.set_text ("");
        return true;
      }
      return false;
    });

    Gdk.Color fg_color;
    Gdk.Color.parse ("black", out fg_color);

    _entry.modify_fg (Gtk.StateType.NORMAL, fg_color);

    _entry.activate.connect (() =>
    {
      string query = _entry.get_text ();
      if (!(query.has_prefix ("#")))
        query = "#" + query;
      _entry.set_text ("");
      _searches.create (query, query);
    });

    _entry.show_all ();
    box.pack_start (_entry, false, false, 0);
    _entry.size_allocate.connect_after (()=> { queue_draw (); });

    _title = new Gtk.Label ("");
    box.pack_start (_title, false, false, 4);

    _searches.updated.connect((id) => {
      var search_map = _searches.lookup (id);
      var name = search_map["name"];
      _stream_view.hide ();
      var filtered_model = streams.transient_filter_model (streams.transient_model, id);
      _stream_view.model = filtered_model;
      _stream_view.stream = stream;
      _search_view.hide ();
      _title.set_markup("<b>" + name + "</b>");
      _title.show ();
      raise (this);
      _stream_view.show_all ();
      _stream_view.showing = true;
    });

    _search_view.show_transient.connect((id, name) => {
      _stream_view.hide ();
      var filtered_model = streams.transient_filter_model (streams.transient_model, id);
      _stream_view.model = filtered_model;
      _stream_view.stream = stream;
      _search_view.hide ();
      _title.set_markup("<b>" + name + "</b>");
      _title.show ();
      raise (this);
      _stream_view.show_all ();
      _stream_view.showing = true;
    });


    var but = new TabWidgets.Button (_("Saved Searches"));
    but.clicked.connect(() => {
      _stream_view.hide ();
      _search_view.show_all ();
      _title.hide ();
      });
    box.pack_end (but, false, false, 0);

    active_hander_id = notify["active"].connect(() => {
      if (active)
      {
        _search_view.showing = true;
        if (active_hander_id > 0)
          disconnect (active_hander_id);
      }
    });

    _stream_view.notify["showing"].connect (() => {
      if (_stream_view.showing)
        _search_view.hide ();
    });

    _search_view.notify["showing"].connect (() => {
      if (_search_view.showing)
        _stream_view.hide ();
    });


    _align.show_all ();
  }

  [Signal (action=true)]
  public virtual signal void raise (TabBarItem item)
  {
  }

  public override Gtk.Widget? get_toolbar ()
  {
    return _align;
  }
  
  public override Gtk.Widget? get_view ()
  {
    return _view;
  }
}
