/*****************************************************************************
 *
 * grail - Gesture Recognition And Instantiation Library
 *
 * Copyright (C) 2010-2011 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or (at your
 * option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 ****************************************************************************/

#ifndef GRAIL_IMPL_H
#define GRAIL_IMPL_H

#define MTDEV_NO_LEGACY_API
#define GRAIL_NO_LEGACY_API

#include <grail.h>
#include <oif/frame-mtdev.h>
#include "evbuf.h"
#include "grailbuf.h"

#define DIM_TOUCH		32
#define DIM_TOUCH_BYTES		((DIM_TOUCH + 7) >> 3)
#define GRAIL_ID_MAX		0xffff

#define MIN(a, b) ((a) < (b) ? (a) : (b))
#define MAX(a, b) ((a) > (b) ? (a) : (b))

typedef void *grail_select_callback;

/*
 * In this implementation, there can be N one-gestures, N (N - 1) / 2
 * two-gestures, and one global gesture.
 */
static inline int get_slot_count(int n)
{
	return n + n * (n - 1) / 2 + 1;
}

int create_grail2(struct grail_impl *x,
		  oif_frame_handle fh,
		  unsigned int num_frames,
		  void *select,
		  unsigned int version,
		  unsigned int control_size,
		  unsigned int frame_size,
		  unsigned int slot_size);

void destroy_grail2(struct grail_impl *x);

struct grail_impl {
	struct evemu_device *evemu;
	struct mtdev *mtdev;
	oif_frame_handle fh;
	const struct oif_frame *touch;
	struct evbuf evbuf;
	struct grailbuf gbuf;
	int filter_abs;
	int ongoing;
	int gesture;
	FILE *fptest;
	/* new stuff below */
	struct grail_control *ctl;
	grail_select_callback select;
	int num_frames;
	int num_slots;
	int num_touches;
	int nextframe;
	int seqid;
	unsigned int control_size;
	unsigned int frame_size;
	unsigned int slot_size;
	struct grail_frame **frames;
};

#endif
