/* Copyright (C) 2004 Bart
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#ifndef GPARTED_CORE
#define GPARTED_CORE

#include "../include/Operation.h"
#include "../include/ext2.h"
#include "../include/ext3.h"
#include "../include/fat16.h"
#include "../include/fat32.h"
#include "../include/linux_swap.h"
#include "../include/reiserfs.h"
#include "../include/ntfs.h"
#include "../include/xfs.h"
#include "../include/jfs.h"
#include "../include/hfs.h"
#include "../include/hfsplus.h"
#include "../include/reiser4.h"

#include <vector>
#include <fstream>

namespace GParted
{

class GParted_Core
{
public:
	GParted_Core( ) ;
	void find_supported_filesystems( ) ; 
	void get_devices( std::vector<Device> & devices ) ;
	
	int get_estimated_time( const Operation & operation ) ;

	void Apply_Operation_To_Disk( Operation & operation );
	
	bool Create( const Device & device, Partition & new_partition ) ;
	bool format( const Partition & partition ) ;
	bool Delete( const Partition & partition ) ;
	bool Resize( const Device & device, const Partition & partition_old, const Partition & partition_new ) ; 
	bool Copy( const Glib::ustring & src_part_path, Partition & partition_dest ) ; 

	bool Set_Disklabel( const Glib::ustring & device_path, const Glib::ustring & disklabel ) ;

	const std::vector<FS> & get_filesystems( ) const ;
	const FS & get_fs( GParted::FILESYSTEM filesystem ) const ;
	Glib::RefPtr<Gtk::TextBuffer> get_textbuffer( ) ;
	std::vector<Glib::ustring> get_disklabeltypes( ) ;

private:
	GParted::FILESYSTEM get_filesystem() ; 
	void set_device_partitions( Device & device ) ;
	void init_maps() ;
	void set_mountpoints( std::vector<Partition> & partitions ) ;
	void set_short_paths( std::vector<Partition> & partitions ) ;
	void set_used_sectors( std::vector<Partition> & partitions ) ;
	void insert_unallocated( const Glib::ustring & device_path, std::vector<Partition> & partitions, Sector start, Sector end, bool inside_extended ) ;
	Glib::ustring get_short_path( const Glib::ustring & real_path ) ;
	void LP_Set_Used_Sectors( Partition & partition );
	Glib::ustring Get_Flags( ) ;
	int Create_Empty_Partition( Partition & new_partition, bool copy = false ) ;
	bool Resize_Container_Partition( const Partition & partition_old, const Partition & partition_new, bool fixed_start ) ;
	bool Resize_Normal_Using_Libparted( const Partition & partition_old, const Partition & partition_new ) ;

	void Show_Error( Glib::ustring message ) ;
	void set_proper_filesystem( const FILESYSTEM & filesystem ) ;
	bool set_partition_type( const Partition & partition ) ;
	bool wait_for_node( const Glib::ustring & node ) ;
	bool erase_filesystem_signatures( const Partition & partition ) ;
		
	bool open_device( const Glib::ustring & device_path ) ;
	bool open_device_and_disk( const Glib::ustring & device_path, bool strict = true ) ;
	void close_device_and_disk( ) ;
	bool commit( ) ;

	Glib::RefPtr<Gtk::TextBuffer> textbuffer;
	
	std::vector<FS> FILESYSTEMS ;
	FileSystem * p_filesystem ;
	std::vector <PedPartitionFlag> flags;
	Glib::ustring temp ;
	Partition partition_temp ;
	FS fs ;
	
	std::map<Glib::ustring, Glib::ustring> mount_info ;
	std::map<Glib::ustring, Glib::ustring> short_paths ;
	std::map<Glib::ustring, Glib::ustring>::iterator iter ;

	PedDevice *lp_device ;
	PedDisk *lp_disk ;
	PedPartition *lp_partition ;
};

} //GParted


#endif //GPARTED_CORE
