/* gnome-sudoku.c generated by valac 0.26.0.30-a52f5a, the Vala compiler
 * generated from gnome-sudoku.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * Copyright © 2014 Parin Porecha
 * Copyright © 2014 Michael Catanzaro
 *
 * This file is part of GNOME Sudoku.
 *
 * GNOME Sudoku is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * GNOME Sudoku is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME Sudoku. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include "libsudoku.h"
#include <stdlib.h>
#include <string.h>
#include <locale.h>
#include <glib/gi18n-lib.h>
#include <stdio.h>
#include <gdk/gdk.h>
#include <gee.h>


#define TYPE_SUDOKU (sudoku_get_type ())
#define SUDOKU(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU, Sudoku))
#define SUDOKU_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU, SudokuClass))
#define IS_SUDOKU(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU))
#define IS_SUDOKU_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU))
#define SUDOKU_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU, SudokuClass))

typedef struct _Sudoku Sudoku;
typedef struct _SudokuClass SudokuClass;
typedef struct _SudokuPrivate SudokuPrivate;

#define TYPE_SUDOKU_VIEW (sudoku_view_get_type ())
#define SUDOKU_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_VIEW, SudokuView))
#define SUDOKU_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_VIEW, SudokuViewClass))
#define IS_SUDOKU_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_VIEW))
#define IS_SUDOKU_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_VIEW))
#define SUDOKU_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_VIEW, SudokuViewClass))

typedef struct _SudokuView SudokuView;
typedef struct _SudokuViewClass SudokuViewClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block1Data Block1Data;
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;

#define TYPE_SUDOKU_PRINTER (sudoku_printer_get_type ())
#define SUDOKU_PRINTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_PRINTER, SudokuPrinter))
#define SUDOKU_PRINTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_PRINTER, SudokuPrinterClass))
#define IS_SUDOKU_PRINTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_PRINTER))
#define IS_SUDOKU_PRINTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_PRINTER))
#define SUDOKU_PRINTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_PRINTER, SudokuPrinterClass))

typedef struct _SudokuPrinter SudokuPrinter;
typedef struct _SudokuPrinterClass SudokuPrinterClass;

#define TYPE_PRINT_DIALOG (print_dialog_get_type ())
#define PRINT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PRINT_DIALOG, PrintDialog))
#define PRINT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PRINT_DIALOG, PrintDialogClass))
#define IS_PRINT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PRINT_DIALOG))
#define IS_PRINT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PRINT_DIALOG))
#define PRINT_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PRINT_DIALOG, PrintDialogClass))

typedef struct _PrintDialog PrintDialog;
typedef struct _PrintDialogClass PrintDialogClass;
typedef struct _Block4Data Block4Data;

struct _Sudoku {
	GtkApplication parent_instance;
	SudokuPrivate * priv;
};

struct _SudokuClass {
	GtkApplicationClass parent_class;
};

struct _SudokuPrivate {
	GSettings* settings;
	gboolean is_maximized;
	gint window_width;
	gint window_height;
	GtkApplicationWindow* window;
	SudokuGame* game;
	SudokuView* view;
	GtkHeaderBar* headerbar;
	GtkStack* main_stack;
	GtkBox* game_box;
	GtkBox* undo_redo_box;
	GtkButton* back_button;
	SudokuSaver* saver;
	GSimpleAction* undo_action;
	GSimpleAction* redo_action;
	GSimpleAction* clear_action;
	GSimpleAction* print_action;
	GSimpleAction* print_multiple_action;
	gboolean show_possibilities;
	gchar* desktop;
};

struct _Block1Data {
	int _ref_count_;
	Sudoku* self;
	SudokuBoard* board;
};

struct _Block2Data {
	int _ref_count_;
	Block1Data * _data1_;
	GtkMessageDialog* dialog;
};

struct _Block3Data {
	int _ref_count_;
	Sudoku* self;
	GtkMessageDialog* dialog;
};

struct _Block4Data {
	int _ref_count_;
	Sudoku* self;
	PrintDialog* print_dialog;
};


static gpointer sudoku_parent_class = NULL;

GType sudoku_get_type (void) G_GNUC_CONST;
GType sudoku_view_get_type (void) G_GNUC_CONST;
#define SUDOKU_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SUDOKU, SudokuPrivate))
enum  {
	SUDOKU_DUMMY_PROPERTY
};
static void sudoku_new_game_cb (Sudoku* self);
static void _sudoku_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_start_game_cb (Sudoku* self, GSimpleAction* action, GVariant* difficulty);
static void _sudoku_start_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_reset_cb (Sudoku* self);
static void _sudoku_reset_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_back_cb (Sudoku* self);
static void _sudoku_back_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_undo_cb (Sudoku* self);
static void _sudoku_undo_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_redo_cb (Sudoku* self);
static void _sudoku_redo_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_print_cb (Sudoku* self);
static void _sudoku_print_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_print_multiple_cb (Sudoku* self);
static void _sudoku_print_multiple_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_help_cb (Sudoku* self);
static void _sudoku_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_about_cb (Sudoku* self);
static void _sudoku_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void _g_application_quit_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
Sudoku* sudoku_new (void);
Sudoku* sudoku_construct (GType object_type);
static gint sudoku_real_handle_local_options (GApplication* base, GVariantDict* options);
static gboolean sudoku_is_desktop (Sudoku* self, const gchar* name);
static void sudoku_real_startup (GApplication* base);
static void __lambda21_ (Sudoku* self);
void sudoku_view_set_show_warnings (SudokuView* self, gboolean value);
static void ___lambda21__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static gboolean sudoku_window_configure_event_cb (Sudoku* self, GdkEventConfigure* event);
static gboolean _sudoku_window_configure_event_cb_gtk_widget_configure_event (GtkWidget* _sender, GdkEventConfigure* event, gpointer self);
static gboolean sudoku_window_state_event_cb (Sudoku* self, GdkEventWindowState* event);
static gboolean _sudoku_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self);
static void sudoku_start_game (Sudoku* self, SudokuBoard* board);
static void sudoku_show_new_game_screen (Sudoku* self);
static void sudoku_real_activate (GApplication* base);
static void sudoku_real_shutdown (GApplication* base);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
SudokuView* sudoku_view_new (SudokuGame* game);
SudokuView* sudoku_view_construct (GType object_type, SudokuGame* game);
void sudoku_view_set_show_possibilities (SudokuView* self, gboolean value);
static void __lambda14_ (Sudoku* self);
static void ___lambda14__sudoku_game_cell_changed (SudokuGame* _sender, gint row, gint col, gint old_val, gint new_val, gpointer self);
static void __lambda15_ (Block1Data* _data1_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda16_ (Block2Data* _data2_, gint response_id);
static void ___lambda16__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static void ___lambda15__sudoku_board_completed (SudokuBoard* _sender, gpointer self);
static void __lambda13_ (Sudoku* self, GObject* obj, GAsyncResult* res);
static void ___lambda13__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void __lambda17_ (Block3Data* _data3_, gint response_id);
void sudoku_view_clear (SudokuView* self);
static void ___lambda17__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
GType sudoku_printer_get_type (void) G_GNUC_CONST;
SudokuPrinter* sudoku_printer_new (GeeList* boards, GtkWindow* window);
SudokuPrinter* sudoku_printer_construct (GType object_type, GeeList* boards, GtkWindow* window);
GtkPrintOperationResult sudoku_printer_print_sudoku (SudokuPrinter* self);
GType print_dialog_get_type (void) G_GNUC_CONST;
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
PrintDialog* print_dialog_new (SudokuSaver* saver, GtkWindow* window);
PrintDialog* print_dialog_construct (GType object_type, SudokuSaver* saver, GtkWindow* window);
static void __lambda20_ (Block4Data* _data4_);
static void ___lambda20__print_dialog_finished (PrintDialog* _sender, gpointer self);
gint sudoku_main (gchar** args, int args_length1);
static void sudoku_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GActionEntry SUDOKU_action_entries[11] = {{"new-game", _sudoku_new_game_cb_gsimple_action_activate_callback}, {"start-game", _sudoku_start_game_cb_gsimple_action_activate_callback, "i"}, {"reset", _sudoku_reset_cb_gsimple_action_activate_callback}, {"back", _sudoku_back_cb_gsimple_action_activate_callback}, {"undo", _sudoku_undo_cb_gsimple_action_activate_callback}, {"redo", _sudoku_redo_cb_gsimple_action_activate_callback}, {"print", _sudoku_print_cb_gsimple_action_activate_callback}, {"print-multiple", _sudoku_print_multiple_cb_gsimple_action_activate_callback}, {"help", _sudoku_help_cb_gsimple_action_activate_callback}, {"about", _sudoku_about_cb_gsimple_action_activate_callback}, {"quit", _g_application_quit_gsimple_action_activate_callback}};
static const GOptionEntry SUDOKU_option_entries[3] = {{"version", 'v', 0, G_OPTION_ARG_NONE, NULL, "Show release version", NULL}, {"show-possible-values", 's', 0, G_OPTION_ARG_NONE, NULL, "Show the possible values for each cell", NULL}, {NULL}};
static const gchar* SUDOKU_authors[6] = {"Robert Ancell <robert.ancell@gmail.com>", "Christopher Baines <cbaines8@gmail.com>", "Thomas M. Hinkle <Thomas_Hinkle@alumni.brown.edu>", "Parin Porecha <parinporecha@gmail.com>", "John Stowers <john.stowers@gmail.com>", NULL};

static void _sudoku_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_new_game_cb ((Sudoku*) self);
#line 234 "gnome-sudoku.c"
}


static void _sudoku_start_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_start_game_cb ((Sudoku*) self, action, parameter);
#line 241 "gnome-sudoku.c"
}


static void _sudoku_reset_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_reset_cb ((Sudoku*) self);
#line 248 "gnome-sudoku.c"
}


static void _sudoku_back_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_back_cb ((Sudoku*) self);
#line 255 "gnome-sudoku.c"
}


static void _sudoku_undo_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_undo_cb ((Sudoku*) self);
#line 262 "gnome-sudoku.c"
}


static void _sudoku_redo_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_redo_cb ((Sudoku*) self);
#line 269 "gnome-sudoku.c"
}


static void _sudoku_print_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_print_cb ((Sudoku*) self);
#line 276 "gnome-sudoku.c"
}


static void _sudoku_print_multiple_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_print_multiple_cb ((Sudoku*) self);
#line 283 "gnome-sudoku.c"
}


static void _sudoku_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_help_cb ((Sudoku*) self);
#line 290 "gnome-sudoku.c"
}


static void _sudoku_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_about_cb ((Sudoku*) self);
#line 297 "gnome-sudoku.c"
}


static void _g_application_quit_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_application_quit ((GApplication*) self);
#line 304 "gnome-sudoku.c"
}


Sudoku* sudoku_construct (GType object_type) {
	Sudoku * self = NULL;
#line 86 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	setlocale (LC_ALL, "");
#line 87 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
#line 88 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
#line 89 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	textdomain (GETTEXT_PACKAGE);
#line 91 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self = (Sudoku*) g_object_new (object_type, "application-id", "org.gnome.sudoku", "flags", G_APPLICATION_FLAGS_NONE, NULL);
#line 92 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_application_add_main_option_entries ((GApplication*) self, SUDOKU_option_entries);
#line 84 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	return self;
#line 324 "gnome-sudoku.c"
}


Sudoku* sudoku_new (void) {
#line 84 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	return sudoku_construct (TYPE_SUDOKU);
#line 331 "gnome-sudoku.c"
}


static gint sudoku_real_handle_local_options (GApplication* base, GVariantDict* options) {
	Sudoku * self;
	gint result = 0;
	GVariantDict* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GVariantDict* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
#line 95 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self = (Sudoku*) base;
#line 95 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_val_if_fail (options != NULL, 0);
#line 97 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = options;
#line 97 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = g_variant_dict_contains (_tmp0_, "version");
#line 97 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp1_) {
#line 352 "gnome-sudoku.c"
		FILE* _tmp2_ = NULL;
#line 100 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp2_ = stderr;
#line 100 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		fprintf (_tmp2_, "gnome-sudoku %s\n", VERSION);
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		result = EXIT_SUCCESS;
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		return result;
#line 362 "gnome-sudoku.c"
	}
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = options;
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = g_variant_dict_contains (_tmp3_, "show-possible-values");
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp4_) {
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		self->priv->show_possibilities = TRUE;
#line 372 "gnome-sudoku.c"
	}
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	result = -1;
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	return result;
#line 378 "gnome-sudoku.c"
}


static gboolean sudoku_is_desktop (Sudoku* self, const gchar* name) {
	gboolean result = FALSE;
	gchar* desktop_name_list = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar** _tmp4_ = NULL;
	gchar** _tmp5_ = NULL;
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_val_if_fail (name != NULL, FALSE);
#line 112 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = g_getenv ("XDG_CURRENT_DESKTOP");
#line 112 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 112 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	desktop_name_list = _tmp1_;
#line 113 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = desktop_name_list;
#line 113 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp2_ == NULL) {
#line 114 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		result = FALSE;
#line 114 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_free0 (desktop_name_list);
#line 114 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		return result;
#line 411 "gnome-sudoku.c"
	}
#line 116 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = desktop_name_list;
#line 116 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp5_ = _tmp4_ = g_strsplit (_tmp3_, ":", 0);
#line 417 "gnome-sudoku.c"
	{
		gchar** n_collection = NULL;
		gint n_collection_length1 = 0;
		gint _n_collection_size_ = 0;
		gint n_it = 0;
#line 116 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		n_collection = _tmp5_;
#line 116 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		n_collection_length1 = _vala_array_length (_tmp4_);
#line 116 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		for (n_it = 0; n_it < _vala_array_length (_tmp4_); n_it = n_it + 1) {
#line 429 "gnome-sudoku.c"
			gchar* _tmp6_ = NULL;
			gchar* n = NULL;
#line 116 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp6_ = g_strdup (n_collection[n_it]);
#line 116 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			n = _tmp6_;
#line 436 "gnome-sudoku.c"
			{
				const gchar* _tmp7_ = NULL;
				const gchar* _tmp8_ = NULL;
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_tmp7_ = n;
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_tmp8_ = name;
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				if (g_strcmp0 (_tmp7_, _tmp8_) == 0) {
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
					result = TRUE;
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
					_g_free0 (n);
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
					n_collection = (_vala_array_free (n_collection, n_collection_length1, (GDestroyNotify) g_free), NULL);
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
					_g_free0 (desktop_name_list);
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
					return result;
#line 456 "gnome-sudoku.c"
				}
#line 116 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_g_free0 (n);
#line 460 "gnome-sudoku.c"
			}
		}
#line 116 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		n_collection = (_vala_array_free (n_collection, n_collection_length1, (GDestroyNotify) g_free), NULL);
#line 465 "gnome-sudoku.c"
	}
#line 120 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	result = FALSE;
#line 120 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_free0 (desktop_name_list);
#line 120 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	return result;
#line 473 "gnome-sudoku.c"
}


static void __lambda21_ (Sudoku* self) {
	SudokuView* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->view;
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = self->priv->settings;
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = g_settings_get_boolean (_tmp1_, "show-warnings");
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_view_set_show_warnings (_tmp0_, _tmp2_);
#line 489 "gnome-sudoku.c"
}


static void ___lambda21__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	__lambda21_ ((Sudoku*) self);
#line 496 "gnome-sudoku.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	return self ? g_object_ref (self) : NULL;
#line 503 "gnome-sudoku.c"
}


static gboolean _sudoku_window_configure_event_cb_gtk_widget_configure_event (GtkWidget* _sender, GdkEventConfigure* event, gpointer self) {
	gboolean result;
	result = sudoku_window_configure_event_cb ((Sudoku*) self, event);
#line 162 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	return result;
#line 512 "gnome-sudoku.c"
}


static gboolean _sudoku_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self) {
	gboolean result;
	result = sudoku_window_state_event_cb ((Sudoku*) self, event);
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	return result;
#line 521 "gnome-sudoku.c"
}


static void sudoku_real_startup (GApplication* base) {
	Sudoku * self;
	GSettings* _tmp0_ = NULL;
	GAction* action = NULL;
	GSettings* _tmp1_ = NULL;
	GAction* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar** _tmp4_ = NULL;
	gchar** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	gchar* _tmp6_ = NULL;
	gchar** _tmp7_ = NULL;
	gchar** _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	gchar* _tmp9_ = NULL;
	gchar** _tmp10_ = NULL;
	gchar** _tmp11_ = NULL;
	gint _tmp11__length1 = 0;
	gchar* _tmp12_ = NULL;
	gchar** _tmp13_ = NULL;
	gchar** _tmp14_ = NULL;
	gint _tmp14__length1 = 0;
	gchar* _tmp15_ = NULL;
	gchar** _tmp16_ = NULL;
	gchar** _tmp17_ = NULL;
	gint _tmp17__length1 = 0;
	gchar* _tmp18_ = NULL;
	gchar** _tmp19_ = NULL;
	gchar** _tmp20_ = NULL;
	gint _tmp20__length1 = 0;
	gchar* _tmp21_ = NULL;
	gchar** _tmp22_ = NULL;
	gchar** _tmp23_ = NULL;
	gint _tmp23__length1 = 0;
	GtkCssProvider* css_provider = NULL;
	GtkCssProvider* _tmp24_ = NULL;
	GdkScreen* _tmp30_ = NULL;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp31_ = NULL;
	GtkBuilder* _tmp32_ = NULL;
	GObject* _tmp33_ = NULL;
	GtkApplicationWindow* _tmp34_ = NULL;
	GtkApplicationWindow* _tmp35_ = NULL;
	GtkApplicationWindow* _tmp36_ = NULL;
	GtkApplicationWindow* _tmp37_ = NULL;
	GSettings* _tmp38_ = NULL;
	gint _tmp39_ = 0;
	GSettings* _tmp40_ = NULL;
	gint _tmp41_ = 0;
	GSettings* _tmp42_ = NULL;
	gboolean _tmp43_ = FALSE;
	GtkApplicationWindow* _tmp45_ = NULL;
	GtkBuilder* _tmp46_ = NULL;
	GObject* _tmp47_ = NULL;
	GtkHeaderBar* _tmp48_ = NULL;
	GtkBuilder* _tmp49_ = NULL;
	GObject* _tmp50_ = NULL;
	GtkStack* _tmp51_ = NULL;
	GtkBuilder* _tmp52_ = NULL;
	GObject* _tmp53_ = NULL;
	GtkBox* _tmp54_ = NULL;
	GtkBuilder* _tmp55_ = NULL;
	GObject* _tmp56_ = NULL;
	GtkBox* _tmp57_ = NULL;
	GtkBuilder* _tmp58_ = NULL;
	GObject* _tmp59_ = NULL;
	GtkButton* _tmp60_ = NULL;
	GAction* _tmp61_ = NULL;
	GSimpleAction* _tmp62_ = NULL;
	GAction* _tmp63_ = NULL;
	GSimpleAction* _tmp64_ = NULL;
	GAction* _tmp65_ = NULL;
	GSimpleAction* _tmp66_ = NULL;
	GAction* _tmp67_ = NULL;
	GSimpleAction* _tmp68_ = NULL;
	GAction* _tmp69_ = NULL;
	GSimpleAction* _tmp70_ = NULL;
	gboolean _tmp71_ = FALSE;
	SudokuSaver* _tmp80_ = NULL;
	SudokuGame* savegame = NULL;
	SudokuSaver* _tmp81_ = NULL;
	SudokuGame* _tmp82_ = NULL;
	SudokuGame* _tmp83_ = NULL;
	GError * _inner_error_ = NULL;
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self = (Sudoku*) base;
#line 125 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	G_APPLICATION_CLASS (sudoku_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
#line 127 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_action_map_add_action_entries ((GActionMap*) self, SUDOKU_action_entries, G_N_ELEMENTS (SUDOKU_action_entries), self);
#line 129 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = g_settings_new ("org.gnome.sudoku");
#line 129 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->settings);
#line 129 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->settings = _tmp0_;
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = self->priv->settings;
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = g_settings_create_action (_tmp1_, "show-warnings");
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	action = _tmp2_;
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_signal_connect_object ((GObject*) action, "notify::state", (GCallback) ___lambda21__g_object_notify, self, 0);
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_action_map_add_action ((GActionMap*) self, action);
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = g_strdup ("<Primary>n");
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = g_new0 (gchar*, 1 + 1);
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_[0] = _tmp3_;
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp5_ = _tmp4_;
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp5__length1 = 1;
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.new-game", _tmp5_);
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp5_ = (_vala_array_free (_tmp5_, _tmp5__length1, (GDestroyNotify) g_free), NULL);
#line 136 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp6_ = g_strdup ("<Primary>p");
#line 136 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp7_ = g_new0 (gchar*, 1 + 1);
#line 136 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp7_[0] = _tmp6_;
#line 136 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp8_ = _tmp7_;
#line 136 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp8__length1 = 1;
#line 136 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.print", _tmp8_);
#line 136 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp8_ = (_vala_array_free (_tmp8_, _tmp8__length1, (GDestroyNotify) g_free), NULL);
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp9_ = g_strdup ("<Primary>q");
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp10_ = g_new0 (gchar*, 1 + 1);
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp10_[0] = _tmp9_;
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp11_ = _tmp10_;
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp11__length1 = 1;
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.quit", _tmp11_);
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp11_ = (_vala_array_free (_tmp11_, _tmp11__length1, (GDestroyNotify) g_free), NULL);
#line 138 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp12_ = g_strdup ("<Primary>r");
#line 138 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp13_ = g_new0 (gchar*, 1 + 1);
#line 138 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp13_[0] = _tmp12_;
#line 138 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp14_ = _tmp13_;
#line 138 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp14__length1 = 1;
#line 138 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.reset", _tmp14_);
#line 138 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp14_ = (_vala_array_free (_tmp14_, _tmp14__length1, (GDestroyNotify) g_free), NULL);
#line 139 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp15_ = g_strdup ("<Primary>z");
#line 139 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp16_ = g_new0 (gchar*, 1 + 1);
#line 139 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp16_[0] = _tmp15_;
#line 139 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp17_ = _tmp16_;
#line 139 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp17__length1 = 1;
#line 139 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.undo", _tmp17_);
#line 139 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp17_ = (_vala_array_free (_tmp17_, _tmp17__length1, (GDestroyNotify) g_free), NULL);
#line 140 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp18_ = g_strdup ("<Primary><Shift>z");
#line 140 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp19_ = g_new0 (gchar*, 1 + 1);
#line 140 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp19_[0] = _tmp18_;
#line 140 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp20_ = _tmp19_;
#line 140 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp20__length1 = 1;
#line 140 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.redo", _tmp20_);
#line 140 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp20_ = (_vala_array_free (_tmp20_, _tmp20__length1, (GDestroyNotify) g_free), NULL);
#line 141 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp21_ = g_strdup ("F1");
#line 141 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp22_ = g_new0 (gchar*, 1 + 1);
#line 141 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp22_[0] = _tmp21_;
#line 141 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp23_ = _tmp22_;
#line 141 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp23__length1 = 1;
#line 141 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.help", _tmp23_);
#line 141 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp23_ = (_vala_array_free (_tmp23_, _tmp23__length1, (GDestroyNotify) g_free), NULL);
#line 143 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_window_set_default_icon_name ("gnome-sudoku");
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp24_ = gtk_css_provider_new ();
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	css_provider = _tmp24_;
#line 735 "gnome-sudoku.c"
	{
		gchar* data = NULL;
		gchar* _tmp25_ = NULL;
		gint _tmp26_ = 0;
		gint _tmp27_ = 0;
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp25_ = g_strdup ("GtkButtonBox { -GtkButtonBox-child-internal-pad-x:0; }\n" \
"                          GtkBox#start_box { margin:0 80px 0 80px; }");
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		data = _tmp25_;
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp26_ = strlen (data);
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp27_ = _tmp26_;
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_css_provider_load_from_data (css_provider, data, (gssize) _tmp27_, &_inner_error_);
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_g_free0 (data);
#line 755 "gnome-sudoku.c"
			goto __catch0_g_error;
		}
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_free0 (data);
#line 760 "gnome-sudoku.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp28_ = NULL;
		const gchar* _tmp29_ = NULL;
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		e = _inner_error_;
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_inner_error_ = NULL;
#line 155 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp28_ = e;
#line 155 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp29_ = _tmp28_->message;
#line 155 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_warning ("gnome-sudoku.vala:155: Error loading css styles: %s", _tmp29_);
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_error_free0 (e);
#line 780 "gnome-sudoku.c"
	}
	__finally0:
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_object_unref0 (css_provider);
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_object_unref0 (action);
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_clear_error (&_inner_error_);
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		return;
#line 795 "gnome-sudoku.c"
	}
#line 157 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp30_ = gdk_screen_get_default ();
#line 157 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_style_context_add_provider_for_screen (_tmp30_, (GtkStyleProvider*) css_provider, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp31_ = gtk_builder_new_from_resource ("/org/gnome/sudoku/ui/gnome-sudoku.ui");
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	builder = _tmp31_;
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp32_ = builder;
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp33_ = gtk_builder_get_object (_tmp32_, "sudoku_app");
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp34_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, gtk_application_window_get_type (), GtkApplicationWindow));
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->window);
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->window = _tmp34_;
#line 162 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp35_ = self->priv->window;
#line 162 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_signal_connect_object ((GtkWidget*) _tmp35_, "configure-event", (GCallback) _sudoku_window_configure_event_cb_gtk_widget_configure_event, self, 0);
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp36_ = self->priv->window;
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_signal_connect_object ((GtkWidget*) _tmp36_, "window-state-event", (GCallback) _sudoku_window_state_event_cb_gtk_widget_window_state_event, self, 0);
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp37_ = self->priv->window;
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp38_ = self->priv->settings;
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp39_ = g_settings_get_int (_tmp38_, "window-width");
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp40_ = self->priv->settings;
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp41_ = g_settings_get_int (_tmp40_, "window-height");
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_window_set_default_size ((GtkWindow*) _tmp37_, _tmp39_, _tmp41_);
#line 165 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp42_ = self->priv->settings;
#line 165 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp43_ = g_settings_get_boolean (_tmp42_, "window-is-maximized");
#line 165 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp43_) {
#line 841 "gnome-sudoku.c"
		GtkApplicationWindow* _tmp44_ = NULL;
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp44_ = self->priv->window;
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_window_maximize ((GtkWindow*) _tmp44_);
#line 847 "gnome-sudoku.c"
	}
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp45_ = self->priv->window;
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_application_add_window ((GtkApplication*) self, (GtkWindow*) _tmp45_);
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp46_ = builder;
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp47_ = gtk_builder_get_object (_tmp46_, "headerbar");
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp48_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, gtk_header_bar_get_type (), GtkHeaderBar));
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->headerbar);
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->headerbar = _tmp48_;
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp49_ = builder;
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp50_ = gtk_builder_get_object (_tmp49_, "main_stack");
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp51_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, gtk_stack_get_type (), GtkStack));
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->main_stack);
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->main_stack = _tmp51_;
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp52_ = builder;
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp53_ = gtk_builder_get_object (_tmp52_, "game_box");
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp54_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp53_, gtk_box_get_type (), GtkBox));
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->game_box);
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->game_box = _tmp54_;
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp55_ = builder;
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp56_ = gtk_builder_get_object (_tmp55_, "undo_redo_box");
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp57_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp56_, gtk_box_get_type (), GtkBox));
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->undo_redo_box);
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->undo_redo_box = _tmp57_;
#line 174 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp58_ = builder;
#line 174 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp59_ = gtk_builder_get_object (_tmp58_, "back_button");
#line 174 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp60_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp59_, gtk_button_get_type (), GtkButton));
#line 174 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->back_button);
#line 174 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->back_button = _tmp60_;
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp61_ = g_action_map_lookup_action ((GActionMap*) self, "undo");
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp62_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp61_, g_simple_action_get_type (), GSimpleAction));
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->undo_action);
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->undo_action = _tmp62_;
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp63_ = g_action_map_lookup_action ((GActionMap*) self, "redo");
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp64_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp63_, g_simple_action_get_type (), GSimpleAction));
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->redo_action);
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->redo_action = _tmp64_;
#line 178 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp65_ = g_action_map_lookup_action ((GActionMap*) self, "reset");
#line 178 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp66_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp65_, g_simple_action_get_type (), GSimpleAction));
#line 178 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->clear_action);
#line 178 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->clear_action = _tmp66_;
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp67_ = g_action_map_lookup_action ((GActionMap*) self, "print");
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp68_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp67_, g_simple_action_get_type (), GSimpleAction));
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->print_action);
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->print_action = _tmp68_;
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp69_ = g_action_map_lookup_action ((GActionMap*) self, "print-multiple");
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp70_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp69_, g_simple_action_get_type (), GSimpleAction));
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->print_multiple_action);
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->print_multiple_action = _tmp70_;
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp71_ = sudoku_is_desktop (self, "Unity");
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (!_tmp71_) {
#line 947 "gnome-sudoku.c"
		GtkHeaderBar* _tmp72_ = NULL;
		GtkApplicationWindow* _tmp73_ = NULL;
		GtkHeaderBar* _tmp74_ = NULL;
#line 184 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp72_ = self->priv->headerbar;
#line 184 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_header_bar_set_show_close_button (_tmp72_, TRUE);
#line 185 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp73_ = self->priv->window;
#line 185 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp74_ = self->priv->headerbar;
#line 185 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_window_set_titlebar ((GtkWindow*) _tmp73_, (GtkWidget*) _tmp74_);
#line 961 "gnome-sudoku.c"
	} else {
		GtkBox* vbox = NULL;
		GtkBuilder* _tmp75_ = NULL;
		GObject* _tmp76_ = NULL;
		GtkBox* _tmp77_ = NULL;
		GtkBox* _tmp78_ = NULL;
		GtkHeaderBar* _tmp79_ = NULL;
#line 189 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp75_ = builder;
#line 189 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp76_ = gtk_builder_get_object (_tmp75_, "vbox");
#line 189 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp77_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp76_, gtk_box_get_type (), GtkBox));
#line 189 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		vbox = _tmp77_;
#line 190 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp78_ = vbox;
#line 190 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp79_ = self->priv->headerbar;
#line 190 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_box_pack_start (_tmp78_, (GtkWidget*) _tmp79_, FALSE, FALSE, (guint) 0);
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_object_unref0 (vbox);
#line 985 "gnome-sudoku.c"
	}
#line 193 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp80_ = sudoku_saver_new ();
#line 193 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->saver);
#line 193 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->saver = _tmp80_;
#line 194 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp81_ = self->priv->saver;
#line 194 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp82_ = sudoku_saver_get_savedgame (_tmp81_);
#line 194 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	savegame = _tmp82_;
#line 195 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp83_ = savegame;
#line 195 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp83_ != NULL) {
#line 1003 "gnome-sudoku.c"
		SudokuGame* _tmp84_ = NULL;
		SudokuBoard* _tmp85_ = NULL;
#line 196 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp84_ = savegame;
#line 196 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp85_ = _tmp84_->board;
#line 196 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_start_game (self, _tmp85_);
#line 1012 "gnome-sudoku.c"
	} else {
#line 198 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_show_new_game_screen (self);
#line 1016 "gnome-sudoku.c"
	}
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (savegame);
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (builder);
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (css_provider);
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (action);
#line 1026 "gnome-sudoku.c"
}


static void sudoku_real_activate (GApplication* base) {
	Sudoku * self;
	GtkApplicationWindow* _tmp0_ = NULL;
#line 201 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self = (Sudoku*) base;
#line 203 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->window;
#line 203 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_window_present ((GtkWindow*) _tmp0_);
#line 1039 "gnome-sudoku.c"
}


static void sudoku_real_shutdown (GApplication* base) {
	Sudoku * self;
	SudokuGame* _tmp0_ = NULL;
	GSettings* _tmp24_ = NULL;
	gint _tmp25_ = 0;
	GSettings* _tmp26_ = NULL;
	gint _tmp27_ = 0;
	GSettings* _tmp28_ = NULL;
	gboolean _tmp29_ = FALSE;
	GError * _inner_error_ = NULL;
#line 206 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self = (Sudoku*) base;
#line 208 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->game;
#line 208 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp0_ != NULL) {
#line 1059 "gnome-sudoku.c"
		gboolean _tmp1_ = FALSE;
		SudokuGame* _tmp2_ = NULL;
		SudokuBoard* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp11_ = FALSE;
		SudokuGame* _tmp12_ = NULL;
		SudokuBoard* _tmp13_ = NULL;
		gboolean _tmp14_ = FALSE;
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp2_ = self->priv->game;
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp3_ = _tmp2_->board;
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp4_ = sudoku_board_is_empty (_tmp3_);
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		if (!_tmp4_) {
#line 1076 "gnome-sudoku.c"
			SudokuGame* _tmp5_ = NULL;
			SudokuBoard* _tmp6_ = NULL;
			gboolean _tmp7_ = FALSE;
			gboolean _tmp8_ = FALSE;
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp5_ = self->priv->game;
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp6_ = _tmp5_->board;
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp7_ = sudoku_board_get_complete (_tmp6_);
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp8_ = _tmp7_;
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp1_ = !_tmp8_;
#line 1091 "gnome-sudoku.c"
		} else {
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp1_ = FALSE;
#line 1095 "gnome-sudoku.c"
		}
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		if (_tmp1_) {
#line 1099 "gnome-sudoku.c"
			SudokuSaver* _tmp9_ = NULL;
			SudokuGame* _tmp10_ = NULL;
#line 211 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp9_ = self->priv->saver;
#line 211 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp10_ = self->priv->game;
#line 211 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			sudoku_saver_save_game (_tmp9_, _tmp10_);
#line 1108 "gnome-sudoku.c"
		}
#line 213 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp12_ = self->priv->game;
#line 213 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp13_ = _tmp12_->board;
#line 213 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp14_ = sudoku_board_is_empty (_tmp13_);
#line 213 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		if (_tmp14_) {
#line 1118 "gnome-sudoku.c"
			SudokuSaver* _tmp15_ = NULL;
			SudokuGame* _tmp16_ = NULL;
			SudokuGame* _tmp17_ = NULL;
#line 213 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp15_ = self->priv->saver;
#line 213 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp16_ = sudoku_saver_get_savedgame (_tmp15_);
#line 213 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp17_ = _tmp16_;
#line 213 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp11_ = _tmp17_ != NULL;
#line 213 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_g_object_unref0 (_tmp17_);
#line 1132 "gnome-sudoku.c"
		} else {
#line 213 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp11_ = FALSE;
#line 1136 "gnome-sudoku.c"
		}
#line 213 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		if (_tmp11_) {
#line 1140 "gnome-sudoku.c"
			GFile* file = NULL;
			const gchar* _tmp18_ = NULL;
			const gchar* _tmp19_ = NULL;
			GFile* _tmp20_ = NULL;
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp18_ = sudoku_saver_get_savegame_file ();
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp19_ = _tmp18_;
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp20_ = g_file_new_for_path (_tmp19_);
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			file = _tmp20_;
#line 1153 "gnome-sudoku.c"
			{
				GFile* _tmp21_ = NULL;
#line 219 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_tmp21_ = file;
#line 219 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				g_file_delete (_tmp21_, NULL, &_inner_error_);
#line 219 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1162 "gnome-sudoku.c"
					goto __catch1_g_error;
				}
			}
			goto __finally1;
			__catch1_g_error:
			{
				GError* e = NULL;
				GError* _tmp22_ = NULL;
				const gchar* _tmp23_ = NULL;
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				e = _inner_error_;
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_inner_error_ = NULL;
#line 223 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_tmp22_ = e;
#line 223 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_tmp23_ = _tmp22_->message;
#line 223 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				g_warning ("gnome-sudoku.vala:223: Failed to delete saved game: %s", _tmp23_);
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_g_error_free0 (e);
#line 1184 "gnome-sudoku.c"
			}
			__finally1:
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_g_object_unref0 (file);
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				g_clear_error (&_inner_error_);
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				return;
#line 1197 "gnome-sudoku.c"
			}
#line 213 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_g_object_unref0 (file);
#line 1201 "gnome-sudoku.c"
		}
	}
#line 229 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp24_ = self->priv->settings;
#line 229 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp25_ = self->priv->window_width;
#line 229 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_settings_set_int (_tmp24_, "window-width", _tmp25_);
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp26_ = self->priv->settings;
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp27_ = self->priv->window_height;
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_settings_set_int (_tmp26_, "window-height", _tmp27_);
#line 231 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp28_ = self->priv->settings;
#line 231 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp29_ = self->priv->is_maximized;
#line 231 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_settings_set_boolean (_tmp28_, "window-is-maximized", _tmp29_);
#line 233 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	G_APPLICATION_CLASS (sudoku_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
#line 1224 "gnome-sudoku.c"
}


static gboolean sudoku_window_configure_event_cb (Sudoku* self, GdkEventConfigure* event) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 236 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 236 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->is_maximized;
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (!_tmp0_) {
#line 1239 "gnome-sudoku.c"
		GdkEventConfigure* _tmp1_ = NULL;
		gint _tmp2_ = 0;
		GdkEventConfigure* _tmp3_ = NULL;
		gint _tmp4_ = 0;
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp1_ = event;
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp2_ = _tmp1_->width;
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		self->priv->window_width = _tmp2_;
#line 241 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp3_ = event;
#line 241 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp4_ = _tmp3_->height;
#line 241 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		self->priv->window_height = _tmp4_;
#line 1256 "gnome-sudoku.c"
	}
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	result = FALSE;
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	return result;
#line 1262 "gnome-sudoku.c"
}


static gboolean sudoku_window_state_event_cb (Sudoku* self, GdkEventWindowState* event) {
	gboolean result = FALSE;
	GdkEventWindowState* _tmp0_ = NULL;
	GdkWindowState _tmp1_ = 0;
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = event;
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = _tmp0_->changed_mask;
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if ((_tmp1_ & GDK_WINDOW_STATE_MAXIMIZED) != 0) {
#line 1280 "gnome-sudoku.c"
		GdkEventWindowState* _tmp2_ = NULL;
		GdkWindowState _tmp3_ = 0;
#line 250 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp2_ = event;
#line 250 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp3_ = _tmp2_->new_window_state;
#line 250 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		self->priv->is_maximized = (_tmp3_ & GDK_WINDOW_STATE_MAXIMIZED) != 0;
#line 1289 "gnome-sudoku.c"
	}
#line 251 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	result = FALSE;
#line 251 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	return result;
#line 1295 "gnome-sudoku.c"
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
#line 254 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 254 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	return _data1_;
#line 1304 "gnome-sudoku.c"
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 254 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 1313 "gnome-sudoku.c"
		Sudoku* self;
#line 254 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		self = _data1_->self;
#line 254 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_object_unref0 (_data1_->board);
#line 254 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_object_unref0 (self);
#line 254 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_slice_free (Block1Data, _data1_);
#line 1323 "gnome-sudoku.c"
	}
}


static void __lambda14_ (Sudoku* self) {
	GSimpleAction* _tmp0_ = NULL;
	SudokuGame* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GSimpleAction* _tmp3_ = NULL;
	SudokuGame* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	GSimpleAction* _tmp6_ = NULL;
	SudokuGame* _tmp7_ = NULL;
	SudokuBoard* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
#line 283 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->undo_action;
#line 283 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = self->priv->game;
#line 283 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = sudoku_game_is_undostack_null (_tmp1_);
#line 283 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp0_, !_tmp2_);
#line 284 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = self->priv->redo_action;
#line 284 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = self->priv->game;
#line 284 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp5_ = sudoku_game_is_redostack_null (_tmp4_);
#line 284 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp3_, !_tmp5_);
#line 285 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp6_ = self->priv->clear_action;
#line 285 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp7_ = self->priv->game;
#line 285 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp8_ = _tmp7_->board;
#line 285 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp9_ = sudoku_board_is_empty (_tmp8_);
#line 285 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp6_, !_tmp9_);
#line 1365 "gnome-sudoku.c"
}


static void ___lambda14__sudoku_game_cell_changed (SudokuGame* _sender, gint row, gint col, gint old_val, gint new_val, gpointer self) {
#line 282 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	__lambda14_ ((Sudoku*) self);
#line 1372 "gnome-sudoku.c"
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_atomic_int_inc (&_data2_->_ref_count_);
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	return _data2_;
#line 1381 "gnome-sudoku.c"
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
#line 1390 "gnome-sudoku.c"
		Sudoku* self;
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		self = _data2_->_data1_->self;
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_object_unref0 (_data2_->dialog);
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		block1_data_unref (_data2_->_data1_);
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_data2_->_data1_ = NULL;
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_slice_free (Block2Data, _data2_);
#line 1402 "gnome-sudoku.c"
	}
}


static void __lambda16_ (Block2Data* _data2_, gint response_id) {
	Block1Data* _data1_;
	Sudoku* self;
	gint _tmp0_ = 0;
#line 305 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data1_ = _data2_->_data1_;
#line 305 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self = _data1_->self;
#line 306 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = response_id;
#line 306 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	switch (_tmp0_) {
#line 306 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		case 0:
#line 1421 "gnome-sudoku.c"
		{
			SudokuBoard* _tmp1_ = NULL;
			DifficultyCategory _tmp2_ = 0;
			DifficultyCategory _tmp3_ = 0;
			SudokuBoard* _tmp4_ = NULL;
			SudokuBoard* _tmp5_ = NULL;
#line 309 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp1_ = _data1_->board;
#line 309 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp2_ = sudoku_board_get_difficulty_category (_tmp1_);
#line 309 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp3_ = _tmp2_;
#line 309 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp4_ = sudoku_generator_generate_board (_tmp3_);
#line 309 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp5_ = _tmp4_;
#line 309 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			sudoku_start_game (self, _tmp5_);
#line 309 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_g_object_unref0 (_tmp5_);
#line 310 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			break;
#line 1444 "gnome-sudoku.c"
		}
#line 306 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		case 1:
#line 1448 "gnome-sudoku.c"
		{
#line 312 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			sudoku_show_new_game_screen (self);
#line 313 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			break;
#line 1454 "gnome-sudoku.c"
		}
		default:
#line 306 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		break;
#line 1459 "gnome-sudoku.c"
	}
#line 315 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_destroy ((GtkWidget*) _data2_->dialog);
#line 1463 "gnome-sudoku.c"
}


static void ___lambda16__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
#line 305 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	__lambda16_ (self, response_id);
#line 1470 "gnome-sudoku.c"
}


static void __lambda15_ (Block1Data* _data1_) {
	Sudoku* self;
	Block2Data* _data2_;
	SudokuSaver* _tmp15_ = NULL;
	SudokuGame* _tmp16_ = NULL;
	gint minutes = 0;
	SudokuGame* _tmp17_ = NULL;
	gdouble _tmp18_ = 0.0;
	gint _tmp19_ = 0;
	gchar* time_str = NULL;
	const gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	GtkApplicationWindow* _tmp22_ = NULL;
	GtkMessageDialog* _tmp23_ = NULL;
	const gchar* _tmp24_ = NULL;
	const gchar* _tmp25_ = NULL;
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self = _data1_->self;
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data2_ = g_slice_new0 (Block2Data);
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data2_->_ref_count_ = 1;
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data2_->_data1_ = block1_data_ref (_data1_);
#line 1498 "gnome-sudoku.c"
	{
		gint i = 0;
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		i = 0;
#line 1503 "gnome-sudoku.c"
		{
			gboolean _tmp0_ = FALSE;
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp0_ = TRUE;
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			while (TRUE) {
#line 1510 "gnome-sudoku.c"
				gint _tmp2_ = 0;
				SudokuGame* _tmp3_ = NULL;
				SudokuBoard* _tmp4_ = NULL;
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				if (!_tmp0_) {
#line 1518 "gnome-sudoku.c"
					gint _tmp1_ = 0;
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
					_tmp1_ = i;
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
					i = _tmp1_ + 1;
#line 1524 "gnome-sudoku.c"
				}
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_tmp0_ = FALSE;
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_tmp2_ = i;
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_tmp3_ = self->priv->game;
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_tmp4_ = _tmp3_->board;
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_tmp5_ = sudoku_board_get_rows (_tmp4_);
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_tmp6_ = _tmp5_;
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				if (!(_tmp2_ < _tmp6_)) {
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
					break;
#line 1542 "gnome-sudoku.c"
				}
				{
					gint j = 0;
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
					j = 0;
#line 1548 "gnome-sudoku.c"
					{
						gboolean _tmp7_ = FALSE;
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
						_tmp7_ = TRUE;
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
						while (TRUE) {
#line 1555 "gnome-sudoku.c"
							gint _tmp9_ = 0;
							SudokuGame* _tmp10_ = NULL;
							SudokuBoard* _tmp11_ = NULL;
							gint _tmp12_ = 0;
							gint _tmp13_ = 0;
							SudokuView* _tmp14_ = NULL;
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
							if (!_tmp7_) {
#line 1564 "gnome-sudoku.c"
								gint _tmp8_ = 0;
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
								_tmp8_ = j;
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
								j = _tmp8_ + 1;
#line 1570 "gnome-sudoku.c"
							}
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
							_tmp7_ = FALSE;
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
							_tmp9_ = j;
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
							_tmp10_ = self->priv->game;
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
							_tmp11_ = _tmp10_->board;
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
							_tmp12_ = sudoku_board_get_cols (_tmp11_);
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
							_tmp13_ = _tmp12_;
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
							if (!(_tmp9_ < _tmp13_)) {
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
								break;
#line 1588 "gnome-sudoku.c"
							}
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
							_tmp14_ = self->priv->view;
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
							g_object_set ((GtkWidget*) _tmp14_, "can-focus", FALSE, NULL);
#line 1594 "gnome-sudoku.c"
						}
					}
				}
			}
		}
	}
#line 293 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp15_ = self->priv->saver;
#line 293 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp16_ = self->priv->game;
#line 293 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_saver_add_game_to_finished (_tmp15_, _tmp16_, TRUE);
#line 296 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp17_ = self->priv->game;
#line 296 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp18_ = sudoku_game_get_total_time_played (_tmp17_);
#line 296 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp19_ = MAX (1, ((gint) _tmp18_) / 60);
#line 296 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	minutes = _tmp19_;
#line 297 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp20_ = ngettext ("Well done, you completed the puzzle in %d minute", "Well done, you completed the puzzle in %d minutes", (gulong) minutes);
#line 297 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp21_ = g_strdup_printf (_tmp20_, minutes);
#line 297 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	time_str = _tmp21_;
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp22_ = self->priv->window;
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp23_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp22_, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_INFO, GTK_BUTTONS_NONE, time_str);
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_object_ref_sink (_tmp23_);
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data2_->dialog = _tmp23_;
#line 302 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp24_ = _ ("Same difficulty again");
#line 302 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_dialog_add_button ((GtkDialog*) _data2_->dialog, _tmp24_, 0);
#line 303 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp25_ = _ ("New difficulty");
#line 303 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_dialog_add_button ((GtkDialog*) _data2_->dialog, _tmp25_, 1);
#line 305 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_signal_connect_data ((GtkDialog*) _data2_->dialog, "response", (GCallback) ___lambda16__gtk_dialog_response, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
#line 318 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_show ((GtkWidget*) _data2_->dialog);
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_free0 (time_str);
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	block2_data_unref (_data2_);
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data2_ = NULL;
#line 1647 "gnome-sudoku.c"
}


static void ___lambda15__sudoku_board_completed (SudokuBoard* _sender, gpointer self) {
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	__lambda15_ (self);
#line 1654 "gnome-sudoku.c"
}


static void sudoku_start_game (Sudoku* self, SudokuBoard* board) {
	Block1Data* _data1_;
	SudokuBoard* _tmp0_ = NULL;
	SudokuBoard* _tmp1_ = NULL;
	GSimpleAction* _tmp2_ = NULL;
	GSimpleAction* _tmp3_ = NULL;
	SudokuView* _tmp4_ = NULL;
	gboolean _tmp7_ = FALSE;
	const gchar* _tmp8_ = NULL;
	GtkHeaderBar* _tmp22_ = NULL;
	SudokuBoard* _tmp23_ = NULL;
	SudokuGame* _tmp24_ = NULL;
	SudokuGame* _tmp25_ = NULL;
	GTimer* _tmp26_ = NULL;
	SudokuGame* _tmp27_ = NULL;
	SudokuView* _tmp28_ = NULL;
	SudokuView* _tmp29_ = NULL;
	SudokuView* _tmp30_ = NULL;
	gboolean _tmp31_ = FALSE;
	SudokuView* _tmp32_ = NULL;
	GSettings* _tmp33_ = NULL;
	gboolean _tmp34_ = FALSE;
	SudokuView* _tmp35_ = NULL;
	GtkBox* _tmp36_ = NULL;
	SudokuView* _tmp37_ = NULL;
	SudokuGame* _tmp38_ = NULL;
	SudokuGame* _tmp39_ = NULL;
	SudokuBoard* _tmp40_ = NULL;
#line 254 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 254 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (board != NULL);
#line 254 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data1_ = g_slice_new0 (Block1Data);
#line 254 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data1_->_ref_count_ = 1;
#line 254 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data1_->self = g_object_ref (self);
#line 254 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = board;
#line 254 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 254 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (_data1_->board);
#line 254 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data1_->board = _tmp1_;
#line 256 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = self->priv->undo_action;
#line 256 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp2_, FALSE);
#line 257 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = self->priv->redo_action;
#line 257 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp3_, FALSE);
#line 259 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = self->priv->view;
#line 259 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp4_ != NULL) {
#line 1716 "gnome-sudoku.c"
		GtkBox* _tmp5_ = NULL;
		SudokuView* _tmp6_ = NULL;
#line 260 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp5_ = self->priv->game_box;
#line 260 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp6_ = self->priv->view;
#line 260 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_container_remove ((GtkContainer*) _tmp5_, (GtkWidget*) _tmp6_);
#line 1725 "gnome-sudoku.c"
	}
#line 262 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp8_ = self->priv->desktop;
#line 262 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp8_ == NULL) {
#line 262 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp7_ = TRUE;
#line 1733 "gnome-sudoku.c"
	} else {
		const gchar* _tmp9_ = NULL;
#line 262 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp9_ = self->priv->desktop;
#line 262 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp7_ = g_strcmp0 (_tmp9_, "Unity") != 0;
#line 1740 "gnome-sudoku.c"
	}
#line 262 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp7_) {
#line 1744 "gnome-sudoku.c"
		GtkHeaderBar* _tmp10_ = NULL;
		SudokuBoard* _tmp11_ = NULL;
		DifficultyCategory _tmp12_ = 0;
		DifficultyCategory _tmp13_ = 0;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
#line 263 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp10_ = self->priv->headerbar;
#line 263 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp11_ = _data1_->board;
#line 263 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp12_ = sudoku_board_get_difficulty_category (_tmp11_);
#line 263 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp13_ = _tmp12_;
#line 263 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp14_ = difficulty_category_to_string (_tmp13_);
#line 263 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp15_ = _tmp14_;
#line 263 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_header_bar_set_subtitle (_tmp10_, _tmp15_);
#line 263 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_free0 (_tmp15_);
#line 1767 "gnome-sudoku.c"
	} else {
		GtkHeaderBar* _tmp16_ = NULL;
		SudokuBoard* _tmp17_ = NULL;
		DifficultyCategory _tmp18_ = 0;
		DifficultyCategory _tmp19_ = 0;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp16_ = self->priv->headerbar;
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp17_ = _data1_->board;
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp18_ = sudoku_board_get_difficulty_category (_tmp17_);
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp19_ = _tmp18_;
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp20_ = difficulty_category_to_string (_tmp19_);
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp21_ = _tmp20_;
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_header_bar_set_title (_tmp16_, _tmp21_);
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_free0 (_tmp21_);
#line 1791 "gnome-sudoku.c"
	}
#line 266 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp22_ = self->priv->headerbar;
#line 266 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp22_, TRUE);
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp23_ = _data1_->board;
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp24_ = sudoku_game_new (_tmp23_);
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->game);
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->game = _tmp24_;
#line 269 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_back_cb (self);
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp25_ = self->priv->game;
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp26_ = _tmp25_->timer;
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_timer_start (_tmp26_);
#line 273 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp27_ = self->priv->game;
#line 273 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp28_ = sudoku_view_new (_tmp27_);
#line 273 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_object_ref_sink (_tmp28_);
#line 273 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->view);
#line 273 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->view = _tmp28_;
#line 274 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp29_ = self->priv->view;
#line 274 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_set_size_request ((GtkWidget*) _tmp29_, 480, 480);
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp30_ = self->priv->view;
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp31_ = self->priv->show_possibilities;
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_view_set_show_possibilities (_tmp30_, _tmp31_);
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp32_ = self->priv->view;
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp33_ = self->priv->settings;
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp34_ = g_settings_get_boolean (_tmp33_, "show-warnings");
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_view_set_show_warnings (_tmp32_, _tmp34_);
#line 279 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp35_ = self->priv->view;
#line 279 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_show ((GtkWidget*) _tmp35_);
#line 280 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp36_ = self->priv->game_box;
#line 280 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp37_ = self->priv->view;
#line 280 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_box_pack_start (_tmp36_, (GtkWidget*) _tmp37_, TRUE, TRUE, (guint) 0);
#line 282 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp38_ = self->priv->game;
#line 282 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_signal_connect_object (_tmp38_, "cell-changed", (GCallback) ___lambda14__sudoku_game_cell_changed, self, 0);
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp39_ = self->priv->game;
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp40_ = _tmp39_->board;
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_signal_connect_data (_tmp40_, "completed", (GCallback) ___lambda15__sudoku_board_completed, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
#line 254 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	block1_data_unref (_data1_);
#line 254 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data1_ = NULL;
#line 1865 "gnome-sudoku.c"
}


static void sudoku_show_new_game_screen (Sudoku* self) {
	GtkStack* _tmp0_ = NULL;
	GSimpleAction* _tmp1_ = NULL;
	GtkButton* _tmp2_ = NULL;
	SudokuGame* _tmp3_ = NULL;
	GtkBox* _tmp4_ = NULL;
	GSimpleAction* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_ = NULL;
#line 322 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 324 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->main_stack;
#line 324 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_stack_set_visible_child_name (_tmp0_, "start_box");
#line 325 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = self->priv->clear_action;
#line 325 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp1_, FALSE);
#line 326 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = self->priv->back_button;
#line 326 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = self->priv->game;
#line 326 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp2_, _tmp3_ != NULL);
#line 327 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = self->priv->undo_redo_box;
#line 327 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp4_, FALSE);
#line 328 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp5_ = self->priv->print_action;
#line 328 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp5_, FALSE);
#line 330 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp7_ = self->priv->desktop;
#line 330 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp7_ == NULL) {
#line 330 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp6_ = TRUE;
#line 1908 "gnome-sudoku.c"
	} else {
		const gchar* _tmp8_ = NULL;
#line 330 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp8_ = self->priv->desktop;
#line 330 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp6_ = g_strcmp0 (_tmp8_, "Unity") != 0;
#line 1915 "gnome-sudoku.c"
	}
#line 330 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp6_) {
#line 1919 "gnome-sudoku.c"
		GtkHeaderBar* _tmp9_ = NULL;
#line 331 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp9_ = self->priv->headerbar;
#line 331 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_header_bar_set_subtitle (_tmp9_, NULL);
#line 1925 "gnome-sudoku.c"
	} else {
		GtkHeaderBar* _tmp10_ = NULL;
#line 333 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp10_ = self->priv->headerbar;
#line 333 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_widget_set_visible ((GtkWidget*) _tmp10_, FALSE);
#line 1932 "gnome-sudoku.c"
	}
}


static void sudoku_new_game_cb (Sudoku* self) {
#line 336 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_show_new_game_screen (self);
#line 1942 "gnome-sudoku.c"
}


static void __lambda13_ (Sudoku* self, GObject* obj, GAsyncResult* res) {
	GError * _inner_error_ = NULL;
#line 351 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (res != NULL);
#line 1950 "gnome-sudoku.c"
	{
		GeeList* gen_boards = NULL;
		GAsyncResult* _tmp0_ = NULL;
		GeeList* _tmp1_ = NULL;
		GtkButton* _tmp2_ = NULL;
		gpointer _tmp3_ = NULL;
		SudokuBoard* _tmp4_ = NULL;
#line 353 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp0_ = res;
#line 353 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp1_ = sudoku_generator_generate_boards_finish (_tmp0_, &_inner_error_);
#line 353 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gen_boards = _tmp1_;
#line 353 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 353 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			if (_inner_error_->domain == G_THREAD_ERROR) {
#line 1968 "gnome-sudoku.c"
				goto __catch2_g_thread_error;
			}
#line 353 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 353 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			g_clear_error (&_inner_error_);
#line 353 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			return;
#line 1977 "gnome-sudoku.c"
		}
#line 354 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp2_ = self->priv->back_button;
#line 354 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_widget_set_sensitive ((GtkWidget*) _tmp2_, TRUE);
#line 355 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp3_ = gee_list_get (gen_boards, 0);
#line 355 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp4_ = (SudokuBoard*) _tmp3_;
#line 355 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_start_game (self, _tmp4_);
#line 355 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_object_unref0 (_tmp4_);
#line 352 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_object_unref0 (gen_boards);
#line 1993 "gnome-sudoku.c"
	}
	goto __finally2;
	__catch2_g_thread_error:
	{
		GError* e = NULL;
		const gchar* _tmp5_ = NULL;
#line 352 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		e = _inner_error_;
#line 352 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_inner_error_ = NULL;
#line 357 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp5_ = e->message;
#line 357 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_error ("gnome-sudoku.vala:357: Thread error: %s", _tmp5_);
#line 352 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_error_free0 (e);
#line 2010 "gnome-sudoku.c"
	}
	__finally2:
#line 352 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 352 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 352 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_clear_error (&_inner_error_);
#line 352 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		return;
#line 2021 "gnome-sudoku.c"
	}
}


static void ___lambda13__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 351 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	__lambda13_ ((Sudoku*) self, source_object, res);
#line 351 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_object_unref (self);
#line 2031 "gnome-sudoku.c"
}


static void sudoku_start_game_cb (Sudoku* self, GSimpleAction* action, GVariant* difficulty) {
	DifficultyCategory selected_difficulty = 0;
	GVariant* _tmp0_ = NULL;
	gint32 _tmp1_ = 0;
	GtkButton* _tmp2_ = NULL;
#line 341 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 341 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (action != NULL);
#line 347 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = difficulty;
#line 347 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = g_variant_get_int32 (_tmp0_);
#line 347 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	selected_difficulty = (DifficultyCategory) _tmp1_;
#line 349 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = self->priv->back_button;
#line 349 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp2_, FALSE);
#line 351 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_generator_generate_boards_async (1, selected_difficulty, ___lambda13__gasync_ready_callback, g_object_ref (self));
#line 2056 "gnome-sudoku.c"
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
#line 362 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_atomic_int_inc (&_data3_->_ref_count_);
#line 362 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	return _data3_;
#line 2065 "gnome-sudoku.c"
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
#line 362 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
#line 2074 "gnome-sudoku.c"
		Sudoku* self;
#line 362 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		self = _data3_->self;
#line 362 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_object_unref0 (_data3_->dialog);
#line 362 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_object_unref0 (self);
#line 362 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_slice_free (Block3Data, _data3_);
#line 2084 "gnome-sudoku.c"
	}
}


static void __lambda17_ (Block3Data* _data3_, gint response_id) {
	Sudoku* self;
	gint _tmp0_ = 0;
#line 366 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self = _data3_->self;
#line 367 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = response_id;
#line 367 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp0_ == ((gint) GTK_RESPONSE_OK)) {
#line 2098 "gnome-sudoku.c"
		SudokuView* _tmp1_ = NULL;
		SudokuGame* _tmp2_ = NULL;
		GSimpleAction* _tmp3_ = NULL;
		GSimpleAction* _tmp4_ = NULL;
#line 369 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp1_ = self->priv->view;
#line 369 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_view_clear (_tmp1_);
#line 370 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp2_ = self->priv->game;
#line 370 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_game_reset (_tmp2_);
#line 371 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp3_ = self->priv->undo_action;
#line 371 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_simple_action_set_enabled (_tmp3_, FALSE);
#line 372 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp4_ = self->priv->redo_action;
#line 372 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_simple_action_set_enabled (_tmp4_, FALSE);
#line 2119 "gnome-sudoku.c"
	}
#line 374 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_destroy ((GtkWidget*) _data3_->dialog);
#line 2123 "gnome-sudoku.c"
}


static void ___lambda17__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
#line 366 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	__lambda17_ (self, response_id);
#line 2130 "gnome-sudoku.c"
}


static void sudoku_reset_cb (Sudoku* self) {
	Block3Data* _data3_;
	GtkApplicationWindow* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkMessageDialog* _tmp2_ = NULL;
#line 362 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 362 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data3_ = g_slice_new0 (Block3Data);
#line 362 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data3_->_ref_count_ = 1;
#line 362 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data3_->self = g_object_ref (self);
#line 364 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->window;
#line 364 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = _ ("Reset the board to its original state?");
#line 364 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp0_, GTK_DIALOG_MODAL, GTK_MESSAGE_QUESTION, GTK_BUTTONS_OK_CANCEL, _tmp1_);
#line 364 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_object_ref_sink (_tmp2_);
#line 364 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data3_->dialog = _tmp2_;
#line 366 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_signal_connect_data ((GtkDialog*) _data3_->dialog, "response", (GCallback) ___lambda17__gtk_dialog_response, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
#line 377 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_show ((GtkWidget*) _data3_->dialog);
#line 362 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	block3_data_unref (_data3_);
#line 362 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data3_ = NULL;
#line 2165 "gnome-sudoku.c"
}


static void sudoku_back_cb (Sudoku* self) {
	GtkStack* _tmp0_ = NULL;
	GSimpleAction* _tmp1_ = NULL;
	SudokuGame* _tmp2_ = NULL;
	SudokuBoard* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	GtkButton* _tmp5_ = NULL;
	GtkBox* _tmp6_ = NULL;
	GSimpleAction* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	const gchar* _tmp9_ = NULL;
#line 380 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 382 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->main_stack;
#line 382 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_stack_set_visible_child_name (_tmp0_, "frame");
#line 383 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = self->priv->clear_action;
#line 383 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = self->priv->game;
#line 383 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = _tmp2_->board;
#line 383 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = sudoku_board_is_empty (_tmp3_);
#line 383 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp1_, !_tmp4_);
#line 384 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp5_ = self->priv->back_button;
#line 384 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp5_, FALSE);
#line 385 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp6_ = self->priv->undo_redo_box;
#line 385 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp6_, TRUE);
#line 386 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp7_ = self->priv->print_action;
#line 386 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp7_, TRUE);
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp9_ = self->priv->desktop;
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp9_ == NULL) {
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp8_ = TRUE;
#line 2214 "gnome-sudoku.c"
	} else {
		const gchar* _tmp10_ = NULL;
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp10_ = self->priv->desktop;
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp8_ = g_strcmp0 (_tmp10_, "Unity") != 0;
#line 2221 "gnome-sudoku.c"
	}
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp8_) {
#line 2225 "gnome-sudoku.c"
		GtkHeaderBar* _tmp11_ = NULL;
		SudokuGame* _tmp12_ = NULL;
		SudokuBoard* _tmp13_ = NULL;
		DifficultyCategory _tmp14_ = 0;
		DifficultyCategory _tmp15_ = 0;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
#line 389 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp11_ = self->priv->headerbar;
#line 389 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp12_ = self->priv->game;
#line 389 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp13_ = _tmp12_->board;
#line 389 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp14_ = sudoku_board_get_difficulty_category (_tmp13_);
#line 389 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp15_ = _tmp14_;
#line 389 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp16_ = difficulty_category_to_string (_tmp15_);
#line 389 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp17_ = _tmp16_;
#line 389 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_header_bar_set_subtitle (_tmp11_, _tmp17_);
#line 389 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_free0 (_tmp17_);
#line 2251 "gnome-sudoku.c"
	} else {
		GtkHeaderBar* _tmp18_ = NULL;
		SudokuGame* _tmp19_ = NULL;
		SudokuBoard* _tmp20_ = NULL;
		DifficultyCategory _tmp21_ = 0;
		DifficultyCategory _tmp22_ = 0;
		gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
#line 391 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp18_ = self->priv->headerbar;
#line 391 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp19_ = self->priv->game;
#line 391 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp20_ = _tmp19_->board;
#line 391 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp21_ = sudoku_board_get_difficulty_category (_tmp20_);
#line 391 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp22_ = _tmp21_;
#line 391 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp23_ = difficulty_category_to_string (_tmp22_);
#line 391 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp24_ = _tmp23_;
#line 391 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_header_bar_set_title (_tmp18_, _tmp24_);
#line 391 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_free0 (_tmp24_);
#line 2278 "gnome-sudoku.c"
	}
}


static void sudoku_undo_cb (Sudoku* self) {
	GtkStack* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	SudokuGame* _tmp2_ = NULL;
	GSimpleAction* _tmp3_ = NULL;
	SudokuGame* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	SudokuView* _tmp6_ = NULL;
#line 394 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 396 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->main_stack;
#line 396 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = gtk_stack_get_visible_child_name (_tmp0_);
#line 396 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (g_strcmp0 (_tmp1_, "frame") != 0) {
#line 397 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		return;
#line 2301 "gnome-sudoku.c"
	}
#line 398 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = self->priv->game;
#line 398 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_game_undo (_tmp2_);
#line 399 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = self->priv->undo_action;
#line 399 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = self->priv->game;
#line 399 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp5_ = sudoku_game_is_undostack_null (_tmp4_);
#line 399 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp3_, !_tmp5_);
#line 400 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp6_ = self->priv->view;
#line 400 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_queue_draw ((GtkWidget*) _tmp6_);
#line 2319 "gnome-sudoku.c"
}


static void sudoku_redo_cb (Sudoku* self) {
	GtkStack* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	SudokuGame* _tmp2_ = NULL;
	GSimpleAction* _tmp3_ = NULL;
	SudokuGame* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	SudokuView* _tmp6_ = NULL;
#line 403 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 405 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->main_stack;
#line 405 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = gtk_stack_get_visible_child_name (_tmp0_);
#line 405 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (g_strcmp0 (_tmp1_, "frame") != 0) {
#line 406 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		return;
#line 2341 "gnome-sudoku.c"
	}
#line 407 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = self->priv->game;
#line 407 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_game_redo (_tmp2_);
#line 408 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = self->priv->redo_action;
#line 408 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = self->priv->game;
#line 408 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp5_ = sudoku_game_is_redostack_null (_tmp4_);
#line 408 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp3_, !_tmp5_);
#line 409 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp6_ = self->priv->view;
#line 409 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_queue_draw ((GtkWidget*) _tmp6_);
#line 2359 "gnome-sudoku.c"
}


static void sudoku_print_cb (Sudoku* self) {
	GtkStack* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GSimpleAction* _tmp2_ = NULL;
	GSimpleAction* _tmp3_ = NULL;
	GeeArrayList* list = NULL;
	GeeArrayList* _tmp4_ = NULL;
	GeeArrayList* _tmp5_ = NULL;
	SudokuGame* _tmp6_ = NULL;
	SudokuBoard* _tmp7_ = NULL;
	SudokuBoard* _tmp8_ = NULL;
	SudokuBoard* _tmp9_ = NULL;
	SudokuPrinter* printer = NULL;
	GeeArrayList* _tmp10_ = NULL;
	GtkApplicationWindow* _tmp11_ = NULL;
	SudokuPrinter* _tmp12_ = NULL;
	SudokuPrinter* _tmp13_ = NULL;
	GSimpleAction* _tmp14_ = NULL;
	GSimpleAction* _tmp15_ = NULL;
#line 412 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 414 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->main_stack;
#line 414 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = gtk_stack_get_visible_child_name (_tmp0_);
#line 414 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (g_strcmp0 (_tmp1_, "frame") != 0) {
#line 415 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		return;
#line 2392 "gnome-sudoku.c"
	}
#line 416 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = self->priv->print_action;
#line 416 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp2_, FALSE);
#line 417 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = self->priv->print_multiple_action;
#line 417 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp3_, FALSE);
#line 419 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = gee_array_list_new (TYPE_SUDOKU_BOARD, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
#line 419 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	list = _tmp4_;
#line 420 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp5_ = list;
#line 420 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp6_ = self->priv->game;
#line 420 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp7_ = _tmp6_->board;
#line 420 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp8_ = sudoku_board_clone (_tmp7_);
#line 420 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp9_ = _tmp8_;
#line 420 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp5_, _tmp9_);
#line 420 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (_tmp9_);
#line 421 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp10_ = list;
#line 421 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp11_ = self->priv->window;
#line 421 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp12_ = sudoku_printer_new ((GeeList*) _tmp10_, G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_window_get_type (), GtkWindow));
#line 421 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	printer = _tmp12_;
#line 422 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp13_ = printer;
#line 422 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_printer_print_sudoku (_tmp13_);
#line 424 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp14_ = self->priv->print_action;
#line 424 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp14_, TRUE);
#line 425 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp15_ = self->priv->print_multiple_action;
#line 425 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp15_, TRUE);
#line 412 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (printer);
#line 412 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (list);
#line 2444 "gnome-sudoku.c"
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
#line 428 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_atomic_int_inc (&_data4_->_ref_count_);
#line 428 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	return _data4_;
#line 2453 "gnome-sudoku.c"
}


static void block4_data_unref (void * _userdata_) {
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
#line 428 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
#line 2462 "gnome-sudoku.c"
		Sudoku* self;
#line 428 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		self = _data4_->self;
#line 428 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_object_unref0 (_data4_->print_dialog);
#line 428 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_object_unref0 (self);
#line 428 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_slice_free (Block4Data, _data4_);
#line 2472 "gnome-sudoku.c"
	}
}


static void __lambda20_ (Block4Data* _data4_) {
	Sudoku* self;
	GSimpleAction* _tmp0_ = NULL;
	GtkStack* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GSimpleAction* _tmp3_ = NULL;
#line 433 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self = _data4_->self;
#line 434 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_destroy ((GtkWidget*) _data4_->print_dialog);
#line 435 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->print_action;
#line 435 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = self->priv->main_stack;
#line 435 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = gtk_stack_get_visible_child_name (_tmp1_);
#line 435 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp0_, g_strcmp0 (_tmp2_, "frame") == 0);
#line 436 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = self->priv->print_multiple_action;
#line 436 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp3_, TRUE);
#line 2499 "gnome-sudoku.c"
}


static void ___lambda20__print_dialog_finished (PrintDialog* _sender, gpointer self) {
#line 433 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	__lambda20_ (self);
#line 2506 "gnome-sudoku.c"
}


static void sudoku_print_multiple_cb (Sudoku* self) {
	Block4Data* _data4_;
	GSimpleAction* _tmp0_ = NULL;
	GSimpleAction* _tmp1_ = NULL;
	SudokuSaver* _tmp2_ = NULL;
	GtkApplicationWindow* _tmp3_ = NULL;
	PrintDialog* _tmp4_ = NULL;
#line 428 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 428 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data4_ = g_slice_new0 (Block4Data);
#line 428 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data4_->_ref_count_ = 1;
#line 428 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data4_->self = g_object_ref (self);
#line 430 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->print_action;
#line 430 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp0_, FALSE);
#line 431 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = self->priv->print_multiple_action;
#line 431 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp1_, FALSE);
#line 432 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = self->priv->saver;
#line 432 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = self->priv->window;
#line 432 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = print_dialog_new (_tmp2_, (GtkWindow*) _tmp3_);
#line 432 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_object_ref_sink (_tmp4_);
#line 432 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data4_->print_dialog = _tmp4_;
#line 433 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_signal_connect_data (_data4_->print_dialog, "finished", (GCallback) ___lambda20__print_dialog_finished, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
#line 438 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_dialog_run ((GtkDialog*) _data4_->print_dialog);
#line 428 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	block4_data_unref (_data4_);
#line 428 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data4_ = NULL;
#line 2551 "gnome-sudoku.c"
}


static void sudoku_help_cb (Sudoku* self) {
	GError * _inner_error_ = NULL;
#line 441 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 2559 "gnome-sudoku.c"
	{
		GtkApplicationWindow* _tmp0_ = NULL;
		GdkScreen* _tmp1_ = NULL;
		guint32 _tmp2_ = 0U;
#line 445 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp0_ = self->priv->window;
#line 445 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp1_ = gtk_window_get_screen ((GtkWindow*) _tmp0_);
#line 445 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp2_ = gtk_get_current_event_time ();
#line 445 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_show_uri (_tmp1_, "help:gnome-sudoku", _tmp2_, &_inner_error_);
#line 445 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2574 "gnome-sudoku.c"
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
#line 443 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		e = _inner_error_;
#line 443 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_inner_error_ = NULL;
#line 449 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp3_ = e;
#line 449 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp4_ = _tmp3_->message;
#line 449 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_warning ("gnome-sudoku.vala:449: Unable to open help: %s", _tmp4_);
#line 443 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_error_free0 (e);
#line 2596 "gnome-sudoku.c"
	}
	__finally3:
#line 443 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 443 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 443 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_clear_error (&_inner_error_);
#line 443 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		return;
#line 2607 "gnome-sudoku.c"
	}
}


static void sudoku_about_cb (Sudoku* self) {
	GtkApplicationWindow* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
#line 460 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 462 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->window;
#line 462 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = _ ("Sudoku");
#line 462 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = sudoku_generator_qqwing_version ();
#line 462 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = _tmp2_;
#line 462 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = g_strdup_printf ("The popular Japanese logic puzzle\n\nPuzzles generated by QQwing %s", _tmp3_);
#line 462 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp5_ = _tmp4_;
#line 462 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp6_ = _ (_tmp5_);
#line 462 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp7_ = _ ("translator-credits");
#line 462 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_show_about_dialog ((GtkWindow*) _tmp0_, "program-name", _tmp1_, "logo-icon-name", "gnome-sudoku", "version", VERSION, "comments", _tmp6_, "copyright", "Copyright © 2005–2008 Thomas M. Hinkle\n" \
"Copyright © 2010–2011 Robert Ancell\n" \
"Copyright © 2014 Parin Porecha", "license-type", GTK_LICENSE_GPL_2_0, "authors", SUDOKU_authors, "artists", NULL, "translator-credits", _tmp7_, "website", "https://wiki.gnome.org/Apps/Sudoku/", NULL);
#line 462 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_free0 (_tmp5_);
#line 462 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_free0 (_tmp3_);
#line 2645 "gnome-sudoku.c"
}


gint sudoku_main (gchar** args, int args_length1) {
	gint result = 0;
	Sudoku* _tmp0_ = NULL;
	Sudoku* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
#line 479 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = sudoku_new ();
#line 479 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = _tmp0_;
#line 479 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = args;
#line 479 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2__length1 = args_length1;
#line 479 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = g_application_run ((GApplication*) _tmp1_, _tmp2__length1, _tmp2_);
#line 479 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = _tmp3_;
#line 479 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (_tmp1_);
#line 479 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	result = _tmp4_;
#line 479 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	return result;
#line 2675 "gnome-sudoku.c"
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
#line 477 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	return sudoku_main (argv, argc);
#line 2685 "gnome-sudoku.c"
}


static void sudoku_class_init (SudokuClass * klass) {
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_parent_class = g_type_class_peek_parent (klass);
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_type_class_add_private (klass, sizeof (SudokuPrivate));
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	((GApplicationClass *) klass)->handle_local_options = sudoku_real_handle_local_options;
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	((GApplicationClass *) klass)->startup = sudoku_real_startup;
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	((GApplicationClass *) klass)->activate = sudoku_real_activate;
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	((GApplicationClass *) klass)->shutdown = sudoku_real_shutdown;
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	G_OBJECT_CLASS (klass)->finalize = sudoku_finalize;
#line 2704 "gnome-sudoku.c"
}


static void sudoku_instance_init (Sudoku * self) {
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv = SUDOKU_GET_PRIVATE (self);
#line 52 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->show_possibilities = FALSE;
#line 2713 "gnome-sudoku.c"
}


static void sudoku_finalize (GObject* obj) {
	Sudoku * self;
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SUDOKU, Sudoku);
#line 26 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->settings);
#line 31 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->window);
#line 34 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->game);
#line 35 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->view);
#line 37 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->headerbar);
#line 38 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->main_stack);
#line 39 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->game_box);
#line 41 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->undo_redo_box);
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->back_button);
#line 44 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->saver);
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->undo_action);
#line 47 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->redo_action);
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->clear_action);
#line 49 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->print_action);
#line 50 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->print_multiple_action);
#line 54 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_free0 (self->priv->desktop);
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	G_OBJECT_CLASS (sudoku_parent_class)->finalize (obj);
#line 2755 "gnome-sudoku.c"
}


GType sudoku_get_type (void) {
	static volatile gsize sudoku_type_id__volatile = 0;
	if (g_once_init_enter (&sudoku_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SudokuClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Sudoku), 0, (GInstanceInitFunc) sudoku_instance_init, NULL };
		GType sudoku_type_id;
		sudoku_type_id = g_type_register_static (gtk_application_get_type (), "Sudoku", &g_define_type_info, 0);
		g_once_init_leave (&sudoku_type_id__volatile, sudoku_type_id);
	}
	return sudoku_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



