# ToughIconTheme
# Try to load an icon from the current icon theme. if this fails try to load
# from the default gnome theme. if this fails to try to use the buildin
# MISSING_IMAGE stock icon. and as a last fallback set the icon to None

import gtk
import pygtk

class ToughIconTheme:
    def __init__(self):
        self.fallback = gtk.IconTheme()
        self.fallback.set_custom_theme("hicolor")
        self.crystal = gtk.IconTheme()
        self.crystal.set_custom_theme("crystal")
        self.gnome = gtk.IconTheme()
        self.gnome.set_custom_theme("gnome")
        self.default = gtk.icon_theme_get_default()
        self.themes = [self.default, self.gnome, self.fallback, self.crystal]

    def load_icon(self, icon, size=48, flags=0):
        for theme in self.themes:
            try:
                return theme.load_icon(icon, size, flags)
            except:
                continue
        return self.fallback.load_icon(gtk.STOCK_MISSING_IMAGE, size, flags)

    def prepend_search_path(self, path):
        for theme in self.themes:
            try:
                theme.prepend_search_path(path)
            except:
                continue
        return 

    def lookup_icon(self,  name, size, flags=0):
        for theme in self.themes:
            info = theme.lookup_icon(name, size, flags)
            if info != None:
                return info
        return None

    def get_icon_sizes(self, icon_name):
        for theme in self.themes:
            try:
                return theme.get_icon_sizes(icon_name)
            except:
                continue
        return None

    def has_icon(self, icon_name):
        for theme in self.themes:
            if theme.has_icon(icon_name) == True:
                return True
        return False
