// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GLIBMM_UNICODE_H
#define _GLIBMM_UNICODE_H


/* Copyright (C) 2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <glib.h>

// Not used, but we want to get rid of possible <ctype.h> macros.
#include <cctype>

#undef isalnum
#undef isalpha
#undef iscntrl
#undef isdigit
#undef isgraph
#undef islower
#undef isprint
#undef ispunct
#undef isspace
#undef isupper
#undef isxdigit
#undef istitle
#undef isdefined
#undef iswide
#undef toupper
#undef tolower
#undef totitle


namespace Glib
{

/** @addtogroup glibmmEnums glibmm Enums and Flags */

/** 
 * These are the possible character classifications from the
 * Unicode specification.
 * See http://www.unicode.org/Public/UNIDATA/UnicodeData.html.
 * @ingroup glibmmEnums
 */
enum UnicodeType
{
  /** General category "Other, Control" (Cc)
   */
  UNICODE_CONTROL,
  /** General category "Other, Format" (Cf)
   */
  UNICODE_FORMAT,
  /** General category "Other, Not Assigned" (Cn)
   */
  UNICODE_UNASSIGNED,
  /** General category "Other, Private Use" (Co)
   */
  UNICODE_PRIVATE_USE,
  /** General category "Other, Surrogate" (Cs)
   */
  UNICODE_SURROGATE,
  /** General category "Letter, Lowercase" (Ll)
   */
  UNICODE_LOWERCASE_LETTER,
  /** General category "Letter, Modifier" (Lm)
   */
  UNICODE_MODIFIER_LETTER,
  /** General category "Letter, Other" (Lo)
   */
  UNICODE_OTHER_LETTER,
  /** General category "Letter, Titlecase" (Lt)
   */
  UNICODE_TITLECASE_LETTER,
  /** General category "Letter, Uppercase" (Lu)
   */
  UNICODE_UPPERCASE_LETTER,
  /** General category "Mark, Spacing" (Mc)
   */
  UNICODE_SPACING_MARK,
  /** General category "Mark, Enclosing" (Me)
   */
  UNICODE_ENCLOSING_MARK,
  /** General category "Mark, Nonspacing" (Mn)
   */
  UNICODE_NON_SPACING_MARK,
  /** General category "Number, Decimal Digit" (Nd)
   */
  UNICODE_DECIMAL_NUMBER,
  /** General category "Number, Letter" (Nl)
   */
  UNICODE_LETTER_NUMBER,
  /** General category "Number, Other" (No)
   */
  UNICODE_OTHER_NUMBER,
  /** General category "Punctuation, Connector" (Pc)
   */
  UNICODE_CONNECT_PUNCTUATION,
  /** General category "Punctuation, Dash" (Pd)
   */
  UNICODE_DASH_PUNCTUATION,
  /** General category "Punctuation, Close" (Pe)
   */
  UNICODE_CLOSE_PUNCTUATION,
  /** General category "Punctuation, Final quote" (Pf)
   */
  UNICODE_FINAL_PUNCTUATION,
  /** General category "Punctuation, Initial quote" (Pi)
   */
  UNICODE_INITIAL_PUNCTUATION,
  /** General category "Punctuation, Other" (Po)
   */
  UNICODE_OTHER_PUNCTUATION,
  /** General category "Punctuation, Open" (Ps)
   */
  UNICODE_OPEN_PUNCTUATION,
  /** General category "Symbol, Currency" (Sc)
   */
  UNICODE_CURRENCY_SYMBOL,
  /** General category "Symbol, Modifier" (Sk)
   */
  UNICODE_MODIFIER_SYMBOL,
  /** General category "Symbol, Math" (Sm)
   */
  UNICODE_MATH_SYMBOL,
  /** General category "Symbol, Other" (So)
   */
  UNICODE_OTHER_SYMBOL,
  /** General category "Separator, Line" (Zl)
   */
  UNICODE_LINE_SEPARATOR,
  /** General category "Separator, Paragraph" (Zp)
   */
  UNICODE_PARAGRAPH_SEPARATOR,
  /** General category "Separator, Space" (Zs)
   */
  UNICODE_SPACE_SEPARATOR
};


/** 
 * These are the possible line break classifications.
 * 
 * Since new unicode versions may add new types here, applications should be ready 
 * to handle unknown values. They may be regarded as UNICODE_BREAK_UNKNOWN.
 * 
 * See http://www.unicode.org/unicode/reports/tr14/.
 * @ingroup glibmmEnums
 */
enum UnicodeBreakType
{
  /** Mandatory Break (BK)
   */
  UNICODE_BREAK_MANDATORY,
  /** Carriage Return (CR)
   */
  UNICODE_BREAK_CARRIAGE_RETURN,
  /** Line Feed (LF)
   */
  UNICODE_BREAK_LINE_FEED,
  /** Attached Characters and Combining Marks (CM)
   */
  UNICODE_BREAK_COMBINING_MARK,
  /** Surrogates (SG)
   */
  UNICODE_BREAK_SURROGATE,
  /** Zero Width Space (ZW)
   */
  UNICODE_BREAK_ZERO_WIDTH_SPACE,
  /** Inseparable (IN)
   */
  UNICODE_BREAK_INSEPARABLE,
  /** Non-breaking ("Glue") (GL)
   */
  UNICODE_BREAK_NON_BREAKING_GLUE,
  /** Contingent Break Opportunity (CB)
   */
  UNICODE_BREAK_CONTINGENT,
  /** Space (SP)
   */
  UNICODE_BREAK_SPACE,
  /** Break Opportunity After (BA)
   */
  UNICODE_BREAK_AFTER,
  /** Break Opportunity Before (BB)
   */
  UNICODE_BREAK_BEFORE,
  /** Break Opportunity Before and After (B2)
   */
  UNICODE_BREAK_BEFORE_AND_AFTER,
  /** Hyphen (HY)
   */
  UNICODE_BREAK_HYPHEN,
  /** Nonstarter (NS)
   */
  UNICODE_BREAK_NON_STARTER,
  /** Opening Punctuation (OP)
   */
  UNICODE_BREAK_OPEN_PUNCTUATION,
  /** Closing Punctuation (CL)
   */
  UNICODE_BREAK_CLOSE_PUNCTUATION,
  /** Ambiguous Quotation (QU)
   */
  UNICODE_BREAK_QUOTATION,
  /** Exclamation/Interrogation (EX)
   */
  UNICODE_BREAK_EXCLAMATION,
  /** Ideographic (ID)
   */
  UNICODE_BREAK_IDEOGRAPHIC,
  /** Numeric (NU)
   */
  UNICODE_BREAK_NUMERIC,
  /** Infix Separator (Numeric) (IS)
   */
  UNICODE_BREAK_INFIX_SEPARATOR,
  /** Symbols Allowing Break After (SY)
   */
  UNICODE_BREAK_SYMBOL,
  /** Ordinary Alphabetic and Symbol Characters (AL)
   */
  UNICODE_BREAK_ALPHABETIC,
  /** Prefix (Numeric) (PR)
   */
  UNICODE_BREAK_PREFIX,
  /** Postfix (Numeric) (PO)
   */
  UNICODE_BREAK_POSTFIX,
  /** Complex Content Dependent (South East Asian) (SA)
   */
  UNICODE_BREAK_COMPLEX_CONTEXT,
  /** Ambiguous (Alphabetic or Ideographic) (AI)
   */
  UNICODE_BREAK_AMBIGUOUS,
  /** Unknown (XX)
   */
  UNICODE_BREAK_UNKNOWN,
  /** Next Line (NL)
   */
  UNICODE_BREAK_NEXT_LINE,
  /** Word Joiner (WJ)
   */
  UNICODE_BREAK_WORD_JOINER,
  /** Hangul L Jamo (JL)
   */
  UNICODE_BREAK_HANGUL_L_JAMO,
  /** Hangul V Jamo (JV)
   */
  UNICODE_BREAK_HANGUL_V_JAMO,
  /** Hangul T Jamo (JT)
   */
  UNICODE_BREAK_HANGUL_T_JAMO,
  /** Hangul LV Syllable (H2)
   */
  UNICODE_BREAK_HANGUL_LV_SYLLABLE,
  /** Hangul LVT Syllable (H3)
   */
  UNICODE_BREAK_HANGUL_LVT_SYLLABLE,
  /** Closing Parenthesis (CP). @newin{2,28}
   */
  UNICODE_BREAK_CLOSE_PARANTHESIS,
  /** Conditional Japanese Starter (CJ). @newin{2,32}
   */
  UNICODE_BREAK_CONDITIONAL_JAPANESE_STARTER,
  /** Hebrew Letter (HL). @newin{2,32}
   */
  UNICODE_BREAK_HEBREW_LETTER
};


/** 
 * 
 * @ingroup glibmmEnums
 * @par Bitwise operators:
 * <tt>%AsciiType operator|(AsciiType, AsciiType)</tt><br>
 * <tt>%AsciiType operator&(AsciiType, AsciiType)</tt><br>
 * <tt>%AsciiType operator^(AsciiType, AsciiType)</tt><br>
 * <tt>%AsciiType operator~(AsciiType)</tt><br>
 * <tt>%AsciiType& operator|=(AsciiType&, AsciiType)</tt><br>
 * <tt>%AsciiType& operator&=(AsciiType&, AsciiType)</tt><br>
 * <tt>%AsciiType& operator^=(AsciiType&, AsciiType)</tt><br>
 */
enum AsciiType
{
  ASCII_ALNUM = 1 << 0,
  ASCII_ALPHA = 1 << 1,
  ASCII_CNTRL = 1 << 2,
  ASCII_DIGIT = 1 << 3,
  ASCII_GRAPH = 1 << 4,
  ASCII_LOWER = 1 << 5,
  ASCII_PRINT = 1 << 6,
  ASCII_PUNCT = 1 << 7,
  ASCII_SPACE = 1 << 8,
  ASCII_UPPER = 1 << 9,
  ASCII_XDIGIT = 1 << 10
};

/** @ingroup glibmmEnums */
inline AsciiType operator|(AsciiType lhs, AsciiType rhs)
  { return static_cast<AsciiType>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup glibmmEnums */
inline AsciiType operator&(AsciiType lhs, AsciiType rhs)
  { return static_cast<AsciiType>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup glibmmEnums */
inline AsciiType operator^(AsciiType lhs, AsciiType rhs)
  { return static_cast<AsciiType>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup glibmmEnums */
inline AsciiType operator~(AsciiType flags)
  { return static_cast<AsciiType>(~static_cast<unsigned>(flags)); }

/** @ingroup glibmmEnums */
inline AsciiType& operator|=(AsciiType& lhs, AsciiType rhs)
  { return (lhs = static_cast<AsciiType>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup glibmmEnums */
inline AsciiType& operator&=(AsciiType& lhs, AsciiType rhs)
  { return (lhs = static_cast<AsciiType>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup glibmmEnums */
inline AsciiType& operator^=(AsciiType& lhs, AsciiType rhs)
  { return (lhs = static_cast<AsciiType>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }


/** 
 * Defines how a Unicode string is transformed in a canonical
 * form, standardizing such issues as whether a character with
 * an accent is represented as a base character and combining
 * accent or as a single precomposed character. Unicode strings
 * should generally be normalized before comparing them.
 * @ingroup glibmmEnums
 */
enum NormalizeMode
{
  /** standardize differences that do not affect the
   * text content, such as the above-mentioned accent representation
   */
  NORMALIZE_DEFAULT,
  /** another name for NORMALIZE_DEFAULT
   */
  NORMALIZE_NFD = NORMALIZE_DEFAULT,
  /** like NORMALIZE_DEFAULT, but with
   * composed forms rather than a maximally decomposed form
   */
  NORMALIZE_DEFAULT_COMPOSE,
  /** another name for NORMALIZE_DEFAULT_COMPOSE
   */
  NORMALIZE_NFC = NORMALIZE_DEFAULT_COMPOSE,
  /** beyond NORMALIZE_DEFAULT also standardize the
   * "compatibility" characters in Unicode, such as SUPERSCRIPT THREE
   * to the standard forms (in this case DIGIT THREE). Formatting
   * information may be lost but for most text operations such
   * characters should be considered the same
   */
  NORMALIZE_ALL,
  /** another name for NORMALIZE_ALL
   */
  NORMALIZE_NFKD = NORMALIZE_ALL,
  /** like NORMALIZE_ALL, but with composed
   * forms rather than a maximally decomposed form
   */
  NORMALIZE_ALL_COMPOSE,
  /** another name for NORMALIZE_ALL_COMPOSE
   */
  NORMALIZE_NFKC = NORMALIZE_ALL_COMPOSE
};


/** @defgroup Unicode Unicode Manipulation
 * Functions operating on Unicode characters and UTF-8 strings.
 * @{
 */

namespace Unicode
{

inline bool validate(gunichar uc)
  { return (g_unichar_validate(uc) != 0); }
inline bool isalnum(gunichar uc)
  { return (g_unichar_isalnum(uc) != 0); }
inline bool isalpha(gunichar uc)
  { return (g_unichar_isalpha(uc) != 0); }
inline bool iscntrl(gunichar uc)
  { return (g_unichar_iscntrl(uc) != 0); }
inline bool isdigit(gunichar uc)
  { return (g_unichar_isdigit(uc) != 0); }
inline bool isgraph(gunichar uc)
  { return (g_unichar_isgraph(uc) != 0); }
inline bool islower(gunichar uc)
  { return (g_unichar_islower(uc) != 0); }
inline bool isprint(gunichar uc)
  { return (g_unichar_isprint(uc) != 0); }
inline bool ispunct(gunichar uc)
  { return (g_unichar_ispunct(uc) != 0); }
inline bool isspace(gunichar uc)
  { return (g_unichar_isspace(uc) != 0); }
inline bool isupper(gunichar uc)
  { return (g_unichar_isupper(uc) != 0); }
inline bool isxdigit(gunichar uc)
  { return (g_unichar_isxdigit(uc) != 0); }
inline bool istitle(gunichar uc)
  { return (g_unichar_istitle(uc) != 0); }
inline bool isdefined(gunichar uc)
  { return (g_unichar_isdefined(uc) != 0); }
inline bool iswide(gunichar uc)
  { return (g_unichar_iswide(uc) != 0); }

inline gunichar toupper(gunichar uc)
  { return g_unichar_toupper(uc); }
inline gunichar tolower(gunichar uc)
  { return g_unichar_tolower(uc); }
inline gunichar totitle(gunichar uc)
  { return g_unichar_totitle(uc); }

inline int digit_value(gunichar uc)
  { return g_unichar_digit_value(uc); }
inline int xdigit_value(gunichar uc)
  { return g_unichar_xdigit_value(uc); }

inline Glib::UnicodeType type(gunichar uc)
  { return static_cast<Glib::UnicodeType>(static_cast<int>(g_unichar_type(uc))); }

inline Glib::UnicodeBreakType break_type(gunichar uc)
  { return static_cast<Glib::UnicodeBreakType>(static_cast<int>(g_unichar_break_type(uc))); }

} // namespace Unicode


namespace Ascii
{

inline bool isalnum(char c)
  { return g_ascii_isalnum(c); }
inline bool isalpha(char c)
  { return g_ascii_isalpha(c); }
inline bool iscntrl(char c)
  { return g_ascii_iscntrl(c); }
inline bool isdigit(char c)
  { return g_ascii_isdigit(c); }
inline bool isgraph(char c)
  { return g_ascii_isgraph(c); }
inline bool islower(char c)
  { return g_ascii_islower(c); }
inline bool isprint(char c)
  { return g_ascii_isprint(c); }
inline bool ispunct(char c)
  { return g_ascii_ispunct(c); }
inline bool isspace(char c)
  { return g_ascii_isspace(c); }
inline bool isupper(char c)
  { return g_ascii_isupper(c); }
inline bool isxdigit(char c)
  { return g_ascii_isxdigit(c); }

inline char tolower(char c)
  { return g_ascii_tolower(c); }
inline char toupper(char c)
  { return g_ascii_toupper(c); }

inline int digit_value(char c)
  { return g_ascii_digit_value(c); }
inline int xdigit_value(char c)
  { return g_ascii_xdigit_value(c); }

} // namespace Ascii


/** @} group Unicode */

} // namespace Glib


#endif /* _GLIBMM_UNICODE_H */

