static const char* op_c_source =
"                                                                              \n"
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2010 Danny Robson <danny@blubinc.net>                            \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_file_path (path, _(\"File\"), \"\")                                  \n"
"    description    (_(\"Target path and filename, use '-' for stdout.\"))     \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_SINK                                                          \n"
"#define GEGL_OP_C_SOURCE rgbe-save.c                                          \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include \"rgbe/rgbe.h\"                                                      \n"
"                                                                              \n"
"                                                                              \n"
"static const gchar *FORMAT = \"RGB float\";                                   \n"
"                                                                              \n"
"                                                                              \n"
"static gboolean                                                               \n"
"gegl_rgbe_save_process (GeglOperation       *operation,                       \n"
"                        GeglBuffer          *input,                           \n"
"                        const GeglRectangle *rect,                            \n"
"                        gint                 level)                           \n"
"{                                                                             \n"
"  GeglProperties *o       = GEGL_PROPERTIES (operation);                      \n"
"  gfloat     *pixels  = NULL;                                                 \n"
"  gboolean    success = FALSE;                                                \n"
"                                                                              \n"
"  /* Write the scanlines */                                                   \n"
"  pixels = g_malloc (rect->width        *                                     \n"
"                     rect->height       *                                     \n"
"                     sizeof (pixels[0]) *                                     \n"
"                     babl_format_get_n_components (babl_format (FORMAT)));    \n"
"                                                                              \n"
"  gegl_buffer_get (input, rect, 1.0, babl_format (FORMAT), pixels,            \n"
"                   GEGL_AUTO_ROWSTRIDE, GEGL_ABYSS_NONE);                     \n"
"                                                                              \n"
"  if (!rgbe_save_path (o->path, rect->width, rect->height, pixels))           \n"
"      goto cleanup;                                                           \n"
"  success = TRUE;                                                             \n"
"                                                                              \n"
"cleanup:                                                                      \n"
"  g_free (pixels);                                                            \n"
"  return success;                                                             \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass     *operation_class;                                    \n"
"  GeglOperationSinkClass *sink_class;                                         \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  sink_class      = GEGL_OPERATION_SINK_CLASS (klass);                        \n"
"                                                                              \n"
"  sink_class->process = gegl_rgbe_save_process;                               \n"
"  sink_class->needs_full = TRUE;                                              \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",         \"gegl:rgbe-save\",                                     \n"
"    \"title\",        _(\"RGBE File Saver\"),                                 \n"
"    \"categories\" ,  \"output\",                                             \n"
"    \"description\" ,                                                         \n"
"        _(\"RGBE image saver (Radiance HDR format)\"),                        \n"
"    NULL);                                                                    \n"
"                                                                              \n"
"  gegl_extension_handler_register_saver (\".hdr\", \"gegl:rgbe-save\");       \n"
"  gegl_extension_handler_register_saver (\".pic\", \"gegl:rgbe-save\");       \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
