#! /bin/sh

#vendor=$(if dpkg-vendor --derives-from Ubuntu; then echo ubuntu; else echo debian; fi)

cross=c
cross=cross
pkg_all=libgcc-5-dev-powerpc-cross
case "$(dpkg-architecture -qDEB_HOST_ARCH)" in
    arm64)
	pkg_any=gcc-5-arm-linux-gnueabihf-base;;
    *)
	pkg_any=gcc-5-powerpc-linux-gnu-base;;
esac

v_deb_gcc=$(apt-cache policy gcc-5-source | awk '/^ \*\*\*/ {print $2}')

v_deb_gcc_cross=$(apt-cache show --no-all-versions $pkg_all 2>/dev/null | awk '/^Version/ {print $2}')

echo >&2 "gcc: $v_deb_gcc / $v_deb_gcc_cross"

if [ -n "$v_deb_gcc_cross" ]; then
    v_deb_gcc_cross_v=$(echo $v_deb_gcc_cross | sed 's/\(.*\)c[ros]*.*/\1/')
    v_deb_gcc_cross_c=$(echo $v_deb_gcc_cross | sed 's/.*c[ros]*\(.*\)/\1/')
    case "$v_deb_gcc_cross_c=" in
	*.*) v_deb_gcc_cross_c=$(echo $v_deb_gcc_cross_c | awk -F. '{print $1}')
    esac				
else
    v_deb_gcc_cross_v=$v_deb_gcc
    v_deb_gcc_cross_c=0
fi

echo >&2 ""
echo >&2 "old gcc version: $v_deb_gcc_cross_v / $v_deb_gcc_cross_c"

if dpkg --compare-versions $v_deb_gcc gt $v_deb_gcc_cross_v; then
    v_gcc_new_c=1
else
    v_deb_src=$(apt-cache show --no-all-versions $pkg_all | sed -n '/^Source:/s/.*(\(.*\))/\1/p')
    v_src=$(dpkg-parsechangelog| sed -n 's/-*//; s/^Version: \(.*\)/\1/p')
    if dpkg --compare-versions $v_deb_src lt $v_src; then
	v_gcc_new_c=$(expr $v_deb_gcc_cross_c + 1)
    else
	v_gcc_new_c=$v_deb_gcc_cross_c
    fi
fi

echo >&2 ""
echo >&2 "new gcc version: ${v_deb_gcc}${cross}${v_gcc_new_c}"

echo $v_gcc_new_c
