/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/*****************************************************************************/
/* This is an automatically generated file. If you're not                    */
/* nsSiteSecurityService.cpp, you shouldn't be #including it.     */
/*****************************************************************************/

#include <stdint.h>
const PRTime gPreloadListExpirationTime = INT64_C(1435403856272000);

class nsSTSPreload
{
  public:
    const char *mHost;
    const bool mIncludeSubdomains;
};

static const nsSTSPreload kSTSPreloadList[] = {
  { "007sascha.de", true },
  { "0x0a.net", true },
  { "17hats.com", true },
  { "18f.gsa.gov", true },
  { "1a-diamantscheiben.de", true },
  { "1a-vermessung.at", true },
  { "1a-werkstattgeraete.de", true },
  { "2048game.co.uk", true },
  { "302.nyc", true },
  { "accounts.firefox.com", true },
  { "accounts.google.com", true },
  { "aclu.org", false },
  { "activiti.alfresco.com", false },
  { "acus.gov", true },
  { "adamkostecki.de", true },
  { "addvocate.com", true },
  { "adlershop.ch", true },
  { "admin.fedoraproject.org", true },
  { "admin.google.com", true },
  { "admin.stg.fedoraproject.org", true },
  { "adorai.tk", true },
  { "adsfund.org", true },
  { "afp548.com", true },
  { "agrimap.com", true },
  { "ahoyconference.com", true },
  { "ahwatukeefoothillsmontessori.com", true },
  { "aids.gov", true },
  { "aie.de", true },
  { "airlea.com", true },
  { "aiticon.com", true },
  { "ajouin.com", true },
  { "aladdinschools.appspot.com", false },
  { "alainwolf.net", true },
  { "alecvannoten.be", true },
  { "alexsexton.com", true },
  { "alexyang.me", true },
  { "alpha.irccloud.com", false },
  { "anadoluefessporkulubu.org", true },
  { "andreasbreitenlohner.de", true },
  { "anetaben.nl", true },
  { "angularjs.org", true },
  { "anime.my", false },
  { "animurecs.com", true },
  { "ankarakart.com.tr", true },
  { "annahmeschluss.de", true },
  { "annevankesteren.com", true },
  { "annevankesteren.nl", true },
  { "annevankesteren.org", true },
  { "ansdell.net", true },
  { "anycoin.me", true },
  { "apadvantage.com", true },
  { "api.intercom.io", false },
  { "api.lookout.com", false },
  { "api.simple.com", false },
  { "api.xero.com", false },
  { "apis.google.com", true },
  { "apn-einstellungen.de", true },
  { "app.lookout.com", false },
  { "app.manilla.com", true },
  { "app.recurly.com", true },
  { "app.simpletax.ca", false },
  { "app.yinxiang.com", false },
  { "appengine.google.com", true },
  { "apps.facebook.com", false },
  { "apps.fedoraproject.org", true },
  { "apps.stg.fedoraproject.org", true },
  { "aprz.de", true },
  { "archlinux.de", true },
  { "arendburgers.nl", true },
  { "arguggi.co.uk", true },
  { "arivo.com.br", true },
  { "arlen.io", true },
  { "arty.name", true },
  { "ask.fedoraproject.org", true },
  { "ask.stg.fedoraproject.org", true },
  { "atavio.at", true },
  { "atavio.ch", true },
  { "atavio.de", true },
  { "atishchenko.com", true },
  { "atlantischild.hu", true },
  { "atlassian.net", true },
  { "atte.fi", true },
  { "auf-feindgebiet.de", true },
  { "authentication.io", true },
  { "azabani.com", true },
  { "badges.fedoraproject.org", true },
  { "badges.stg.fedoraproject.org", true },
  { "baer.im", true },
  { "balcan-underground.net", true },
  { "baldwinkoo.com", true },
  { "balikonos.cz", true },
  { "bank.simple.com", false },
  { "barslecht.com", true },
  { "barslecht.nl", true },
  { "baruch.me", true },
  { "bassh.net", true },
  { "bautied.de", true },
  { "bayrisch-fuer-anfaenger.de", true },
  { "bccx.com", true },
  { "bcrook.com", false },
  { "beamitapp.com", true },
  { "beastowner.com", true },
  { "beastowner.li", true },
  { "bedeta.de", true },
  { "bedreid.dk", true },
  { "beneathvt.com", true },
  { "benjamin.pe", true },
  { "benjamins.com", true },
  { "bentertain.de", true },
  { "best-wedding-quotes.com", true },
  { "bfelob.gov", true },
  { "bgneuesheim.de", true },
  { "bhatia.at", true },
  { "biathloncup.ru", true },
  { "big-andy.co.uk", true },
  { "bigbrownpromotions.com.au", true },
  { "bit.voyage", true },
  { "bitbucket.org", false },
  { "bitfactory.ws", true },
  { "bitmex.com", true },
  { "bitmon.net", true },
  { "bitpod.de", true },
  { "bjornjohansen.no", true },
  { "bl4ckb0x.com", true },
  { "bl4ckb0x.de", true },
  { "bl4ckb0x.info", true },
  { "bl4ckb0x.net", true },
  { "bl4ckb0x.org", true },
  { "blacklane.com", true },
  { "blessnet.jp", true },
  { "blockchain.info", true },
  { "blocksatz-medien.de", true },
  { "blog.cyveillance.com", true },
  { "blog.gparent.org", true },
  { "blog.linode.com", false },
  { "blog.torproject.org", false },
  { "blubbablasen.de", true },
  { "bodo-wolff.de", true },
  { "bohramt.de", true },
  { "bonigo.de", true },
  { "bookingapp.nl", true },
  { "boxcryptor.com", true },
  { "brage.info", true },
  { "brakemanpro.com", true },
  { "broeselei.at", true },
  { "brossmanit.com", true },
  { "brunosouza.org", true },
  { "buddhistische-weisheiten.org", true },
  { "bugzil.la", true },
  { "bugzilla.mozilla.org", true },
  { "bulktrade.de", true },
  { "business.facebook.com", false },
  { "business.lookout.com", false },
  { "buttercoin.com", true },
  { "buzzconcert.com", true },
  { "bytepark.de", false },
  { "bzv-fr.eu", true },
  { "ca.gparent.org", false },
  { "cackette.com", true },
  { "call.me", true },
  { "camolist.com", true },
  { "cao.gov", true },
  { "caremad.io", true },
  { "carezone.com", false },
  { "cartouche24.eu", true },
  { "cartucce24.it", true },
  { "cdnb.co", true },
  { "celltek-server.de", false },
  { "certible.com", true },
  { "certly.io", true },
  { "cfo.gov", true },
  { "chahub.com", true },
  { "chainmonitor.com", true },
  { "changelab.cc", true },
  { "chatbot.me", true },
  { "check.torproject.org", false },
  { "checkout.google.com", true },
  { "chm.vn", true },
  { "chontalpa.pw", true },
  { "chrisjean.com", true },
  { "chrome-devtools-frontend.appspot.com", true },
  { "chrome.com", false },
  { "chrome.google.com", true },
  { "chromiumcodereview.appspot.com", false },
  { "chulado.com", true },
  { "cio.gov", true },
  { "cktennis.com", true },
  { "clan-ww.com", true },
  { "clapping-rhymes.com", true },
  { "clerkendweller.uk", true },
  { "clintwilson.technology", true },
  { "cloud.google.com", true },
  { "cloudcert.org", true },
  { "cloudns.com.au", true },
  { "cloudsecurityalliance.org", true },
  { "cloudstoragemaus.com", true },
  { "cloudup.com", true },
  { "code-poets.co.uk", true },
  { "code.facebook.com", false },
  { "code.google.com", true },
  { "codepoints.net", true },
  { "codepref.com", true },
  { "codepx.com", true },
  { "codereview.appspot.com", false },
  { "codereview.chromium.org", true },
  { "coffeeetc.co.uk", true },
  { "coinapult.com", true },
  { "comdurav.com", true },
  { "comssa.org.au", true },
  { "config.schokokeks.org", false },
  { "conformal.com", true },
  { "conrad-kostecki.de", true },
  { "controlcenter.gigahost.dk", true },
  { "cor-ser.es", true },
  { "cordial-restaurant.com", true },
  { "cotonea.de", true },
  { "crm.onlime.ch", false },
  { "crowdjuris.com", true },
  { "crypto.cat", false },
  { "cryptobin.org", true },
  { "cryptopartyatx.org", true },
  { "cs50.harvard.edu", true },
  { "cs50.net", true },
  { "cspbuilder.info", true },
  { "csuw.net", true },
  { "cube.de", true },
  { "cupcake.io", true },
  { "cupcake.is", true },
  { "curiosity-driven.org", true },
  { "curlybracket.co.uk", true },
  { "cyanogenmod.xxx", true },
  { "cybershambles.com", true },
  { "cybozu.com", true },
  { "cyon.ch", true },
  { "cyphertite.com", true },
  { "cyprus-company-service.com", true },
  { "czbix.com", true },
  { "daphne.informatik.uni-freiburg.de", true },
  { "darchoods.net", false },
  { "darkpony.ru", true },
  { "darkserver.fedoraproject.org", true },
  { "darkserver.stg.fedoraproject.org", true },
  { "darom.jp", true },
  { "data-abundance.com", true },
  { "data.qld.gov.au", false },
  { "datenkeks.de", true },
  { "daveoc64.co.uk", true },
  { "davidlyness.com", true },
  { "davidnoren.com", true },
  { "dccode.gov", true },
  { "deadbeef.ninja", true },
  { "dealcruiser.nl", true },
  { "debtkit.co.uk", true },
  { "dedimax.de", true },
  { "dee.pe", true },
  { "denh.am", true },
  { "depechemode-live.com", true },
  { "derevtsov.com", false },
  { "derhil.de", true },
  { "detectify.com", false },
  { "developer.mydigipass.com", false },
  { "developers.facebook.com", false },
  { "diamante.ro", true },
  { "die-besten-weisheiten.de", true },
  { "dillonkorman.com", true },
  { "dinamoelektrik.com", true },
  { "dist.torproject.org", false },
  { "dixmag.com", true },
  { "dl.google.com", true },
  { "dlc.viasinc.com", true },
  { "dm.lookout.com", false },
  { "dm.mylookout.com", false },
  { "doc.python.org", true },
  { "docs.google.com", true },
  { "docs.python.org", true },
  { "domains.google.com", true },
  { "donmez.ws", false },
  { "donotcall.gov", true },
  { "dreadbyte.com", true },
  { "drive.google.com", true },
  { "dropbox.com", true },
  { "dylanscott.com.au", true },
  { "dzlibs.io", true },
  { "e-kontakti.fi", true },
  { "e.mail.ru", true },
  { "earmarks.gov", true },
  { "easysimplecrm.com", false },
  { "ebanking.indovinabank.com.vn", false },
  { "ecdn.cz", true },
  { "ecfs.link", true },
  { "ecg.fr", false },
  { "ecosystem.atlassian.net", true },
  { "edit.yahoo.com", false },
  { "eduroam.no", true },
  { "edyou.eu", true },
  { "ef.gy", true },
  { "eff.org", true },
  { "egfl.org.uk", true },
  { "egit.co", true },
  { "eksisozluk.com", true },
  { "electronic-ignition-system.com", true },
  { "elnutricionista.es", true },
  { "emailprivacytester.com", true },
  { "encircleapp.com", true },
  { "encryptallthethings.net", true },
  { "encrypted.google.com", true },
  { "energy-drink-magazin.de", true },
  { "enorekcah.com", true },
  { "entropia.de", false },
  { "errors.zenpayroll.com", false },
  { "espra.com", true },
  { "ethack.org", true },
  { "ethitter.com", true },
  { "eurotramp.com", true },
  { "everhome.de", true },
  { "evstatus.com", true },
  { "exiahost.com", true },
  { "exon.io", true },
  { "expatads.com", true },
  { "explodie.org", true },
  { "extendwings.com", true },
  { "f-droid.org", true },
  { "fabhub.io", true },
  { "facebook.com", false },
  { "factor.cc", false },
  { "fairbill.com", true },
  { "fakturoid.cz", true },
  { "fant.dk", true },
  { "faq.lookout.com", false },
  { "fassadenverkleidung24.de", true },
  { "fastcomcorp.net", true },
  { "federalregister.gov", true },
  { "fedorahosted.org", true },
  { "fedorapeople.org", true },
  { "feedbin.com", false },
  { "ferienhaus-polchow-ruegen.de", false },
  { "fewo-thueringer-wald.de", true },
  { "fiken.no", true },
  { "filedir.com", false },
  { "filip-prochazka.com", true },
  { "finn.io", true },
  { "firebaseio-demo.com", true },
  { "firebaseio.com", true },
  { "firefart.at", true },
  { "firemail.io", true },
  { "firma-offshore.com", true },
  { "firstlook.org", true },
  { "fischer-its.com", true },
  { "fj.simple.com", false },
  { "flamer-scene.com", true },
  { "fleximus.org", false },
  { "floobits.com", true },
  { "florianmitrea.uk", true },
  { "flynn.io", true },
  { "fonetiq.io", true },
  { "food4health.guide", true },
  { "forewordreviews.com", true },
  { "forodeespanol.com", true },
  { "forum.linode.com", false },
  { "forum.quantifiedself.com", true },
  { "fralef.me", false },
  { "frederik-braun.com", true },
  { "freenetproject.org", true },
  { "freeshell.de", true },
  { "freesounding.com", true },
  { "freesounding.ru", true },
  { "freethought.org.au", true },
  { "fronteers.nl", true },
  { "ftccomplaintassistant.gov", true },
  { "fundingempire.com", true },
  { "futos.de", true },
  { "gambitnash.co.uk", true },
  { "gamercredo.com", true },
  { "garron.net", true },
  { "gavick.com", true },
  { "gaytorrent.ru", true },
  { "gemeinfreie-lieder.de", true },
  { "geoip.fedoraproject.org", true },
  { "geoip.stg.fedoraproject.org", true },
  { "gerardozamudio.mx", true },
  { "gernert-server.de", true },
  { "get.zenpayroll.com", false },
  { "getable.com", true },
  { "getcloak.com", false },
  { "getdigitized.net", true },
  { "getfedora.org", true },
  { "getfittedstore.com", true },
  { "getssl.uz", true },
  { "giacomopelagatti.it", true },
  { "github.com", true },
  { "gizzo.sk", true },
  { "glass.google.com", true },
  { "globuli-info.de", true },
  { "glossopnorthendafc.co.uk", true },
  { "gmail.com", false },
  { "gmantra.org", true },
  { "gmcd.co", true },
  { "go.xero.com", false },
  { "gocardless.com", true },
  { "golf-6.com", true },
  { "golf3.de", true },
  { "golf4.de", true },
  { "googlemail.com", false },
  { "googleplex.com", true },
  { "goto.google.com", true },
  { "gplintegratedit.com", true },
  { "gpsfix.cz", true },
  { "grc.com", true },
  { "greensolid.biz", true },
  { "grepular.com", true },
  { "groetzner.net", true },
  { "groups.google.com", true },
  { "gtraxapp.com", true },
  { "guidetoiceland.is", true },
  { "gunnarhafdal.com", true },
  { "guphi.net", true },
  { "guthabenkarten-billiger.de", true },
  { "gw2treasures.com", true },
  { "hack.li", true },
  { "hackerone.com", true },
  { "hansvaneijsden.com", true },
  { "happylifestyle.com", true },
  { "harvestapp.com", true },
  { "hasilocke.de", true },
  { "haste.ch", true },
  { "haufschild.de", true },
  { "hausverbrauch.de", true },
  { "hda.me", true },
  { "heartlandrentals.com", true },
  { "heha.co", false },
  { "heid.ws", true },
  { "heijblok.com", true },
  { "helichat.de", true },
  { "help.simpletax.ca", false },
  { "helpium.de", true },
  { "hemlockhillscabinrentals.com", true },
  { "henriknoerr.com", true },
  { "heppler.net", true },
  { "herocentral.de", true },
  { "hex2013.com", true },
  { "hexony.com", true },
  { "hg.python.org", true },
  { "hicoria.com", true },
  { "history.google.com", true },
  { "honeybadger.io", false },
  { "horseboners.xxx", true },
  { "horza.org", true },
  { "hostedtalkgadget.google.com", true },
  { "hostinginnederland.nl", true },
  { "hostix.de", true },
  { "howrandom.org", true },
  { "howsmyssl.com", true },
  { "howsmytls.com", true },
  { "hpac-portal.com", true },
  { "hrackydomino.cz", true },
  { "hsmr.cc", true },
  { "hsr.gov", true },
  { "hstsfail.appspot.com", true },
  { "html5.org", true },
  { "httpswatch.com", true },
  { "i5y.co.uk", true },
  { "iamcarrico.com", true },
  { "ian.sh", true },
  { "iban.is", true },
  { "id-co.in", true },
  { "id-conf.com", true },
  { "id.atlassian.com", true },
  { "id.mayfirst.org", false },
  { "ideaweb.de", true },
  { "ihrlotto.de", true },
  { "ikkatsu-satei.jp", true },
  { "ilikerainbows.co.uk", true },
  { "imaginary.ca", true },
  { "imouto.my", false },
  { "in.xero.com", false },
  { "inb4.us", true },
  { "inbox.google.com", true },
  { "iniiter.com", true },
  { "inkbunny.net", true },
  { "inleaked.com", true },
  { "innophate-security.com", true },
  { "innophate-security.nl", true },
  { "insouciant.org", true },
  { "instasex.ch", true },
  { "interserved.com", true },
  { "ionas-law.ro", true },
  { "iranianlawschool.com", true },
  { "iridiumbrowser.de", true },
  { "irische-segenswuensche.info", true },
  { "ironfistdesign.com", true },
  { "isitchristmas.com", true },
  { "it-schwerin.de", true },
  { "itdashboard.gov", true },
  { "itsamurai.ru", true },
  { "itshost.ru", true },
  { "izdiwho.com", true },
  { "jackyyf.com", false },
  { "jakub-boucek.cz", true },
  { "janoberst.com", true },
  { "janus-engineering.de", true },
  { "jelmer.co.uk", true },
  { "jelmer.uk", true },
  { "jettshome.org", true },
  { "jfreitag.de", true },
  { "jimshaver.net", true },
  { "jira.com", true },
  { "jitsi.org", false },
  { "jmdekker.it", true },
  { "jmedved.com", true },
  { "johners.me", true },
  { "jonas-keidel.de", true },
  { "jonaswitmer.ch", true },
  { "jonnybarnes.uk", true },
  { "julian-kipka.de", true },
  { "jwilsson.com", true },
  { "jwilsson.me", true },
  { "k-dev.de", true },
  { "kaheim.de", true },
  { "kardize24.pl", true },
  { "karmaspa.se", true },
  { "kartonmodellbau.org", true },
  { "kdex.de", true },
  { "kdyby.org", true },
  { "keeleysam.com", true },
  { "keepa.com", false },
  { "keepclean.me", true },
  { "keeperapp.com", true },
  { "keepersecurity.com", true },
  { "kernel-error.de", true },
  { "kevincox.ca", true },
  { "keycdn.com", true },
  { "keyerror.com", true },
  { "khanovaskola.cz", true },
  { "khmath.com", true },
  { "ki-on.net", true },
  { "kinderbuecher-kostenlos.de", true },
  { "kingmanhall.org", true },
  { "kinogb.net", false },
  { "kinsights.com", false },
  { "kirei.se", true },
  { "kirkforsenate.com", true },
  { "kitsta.com", true },
  { "klarmobil-empfehlen.de", true },
  { "klatschreime.de", true },
  { "klausbrinch.dk", true },
  { "klaxn.com", true },
  { "kleidertauschpartys.de", true },
  { "klingeletest.de", true },
  { "knip.ch", true },
  { "knowledgehook.com", true },
  { "koenvdheuvel.me", true },
  { "kojipkgs.fedoraproject.org", true },
  { "komandakovalchuk.com", true },
  { "konklone.com", true },
  { "koop-bremen.de", true },
  { "koordinate.net", true },
  { "kosho.org", true },
  { "kpebetka.net", true },
  { "kraken.io", true },
  { "kuppingercole.com", true },
  { "kupschke.net", true },
  { "kura.io", true },
  { "laf.in.net", true },
  { "lagerauftrag.info", true },
  { "lancejames.com", true },
  { "lasst-uns-beten.de", true },
  { "lastpass.com", false },
  { "launchkey.com", true },
  { "lavalite.de", true },
  { "lb-toner.de", true },
  { "leadbook.ru", true },
  { "ledgerscope.net", false },
  { "leibniz-remscheid.de", true },
  { "leifdreizler.com", true },
  { "leonardcamacho.me", true },
  { "leonklingele.de", true },
  { "les-corsaires.net", true },
  { "libraryfreedomproject.org", true },
  { "liebel.org", true },
  { "light.mail.ru", true },
  { "lighting-centres.co.uk", true },
  { "lilpwny.com", true },
  { "limpid.nl", true },
  { "lingolia.com", true },
  { "linode.com", false },
  { "linux-admin-california.com", true },
  { "linx.net", true },
  { "lists.mayfirst.org", false },
  { "lists.stg.fedoraproject.org", true },
  { "livej.am", true },
  { "ljs.io", true },
  { "lobste.rs", true },
  { "lockify.com", true },
  { "lodash.com", true },
  { "loenshotel.de", true },
  { "loftboard.eu", true },
  { "logentries.com", false },
  { "login.corp.google.com", true },
  { "login.launchpad.net", true },
  { "login.persona.org", true },
  { "login.sapo.pt", true },
  { "login.ubuntu.com", true },
  { "login.xero.com", false },
  { "login.yahoo.com", false },
  { "lolicore.ch", true },
  { "lookout.com", false },
  { "ludwig.im", true },
  { "luelistan.net", true },
  { "lukonet.com", true },
  { "lumi.do", false },
  { "luneta.nearbuysystems.com", false },
  { "m.facebook.com", false },
  { "m.mail.ru", true },
  { "m0wef.uk", true },
  { "mach-politik.ch", true },
  { "madars.org", true },
  { "maff.scot", false },
  { "magneticanvil.com", true },
  { "mahamed91.pw", true },
  { "mail.de", true },
  { "mail.google.com", true },
  { "mail.yahoo.com", false },
  { "mailbox.org", true },
  { "makeitdynamic.com", true },
  { "makeyourlaws.org", true },
  { "malnex.de", true },
  { "man3s.jp", true },
  { "manage.zenpayroll.com", false },
  { "manageprojects.com", true },
  { "manager.linode.com", false },
  { "mandala-ausmalbilder.de", true },
  { "manicode.com", true },
  { "market.android.com", true },
  { "markusueberallassetmanagement.de", true },
  { "marshut.net", true },
  { "massivum.de", true },
  { "matatall.com", true },
  { "mathiasbynens.be", true },
  { "matteomarescotti.it", true },
  { "mattmccutchen.net", true },
  { "max.gov", true },
  { "mbasic.facebook.com", false },
  { "mbp.banking.co.at", false },
  { "md5file.com", true },
  { "mdfnet.se", true },
  { "meamod.com", true },
  { "mediacru.sh", true },
  { "medium.com", true },
  { "meetfinch.com", true },
  { "mega.co.nz", false },
  { "megaplan.cz", true },
  { "megaplan.ru", true },
  { "meinebo.it", true },
  { "members.mayfirst.org", false },
  { "members.nearlyfreespeech.net", false },
  { "miasarafina.de", true },
  { "michalspacek.cz", true },
  { "mig5.net", true },
  { "mike-bland.com", true },
  { "miketabor.com", true },
  { "mikewest.org", true },
  { "miku.hatsune.my", false },
  { "mimeit.de", true },
  { "minecraftvoter.com", true },
  { "mineover.es", true },
  { "minez-nightswatch.com", true },
  { "minikneet.com", true },
  { "minnesotadata.com", true },
  { "mirrorx.com", true },
  { "miskatonic.org", true },
  { "mkcert.org", true },
  { "mkw.st", true },
  { "mnsure.org", true },
  { "mobilcom-debitel-empfehlen.de", true },
  { "mobile.usaa.com", false },
  { "mokote.com", true },
  { "mondwandler.de", true },
  { "morethanadream.lv", true },
  { "moriz.de", true },
  { "mothereff.in", true },
  { "mountainmusicpromotions.com", true },
  { "mountainroseherbs.com", true },
  { "movlib.org", true },
  { "mpreserver.com", true },
  { "mqas.net", true },
  { "mr-hosting.com", true },
  { "msa-aesch.ch", true },
  { "msc-seereisen.net", true },
  { "mths.be", true },
  { "mtouch.facebook.com", false },
  { "mudcrab.us", true },
  { "mujadin.se", true },
  { "munich-rage.de", true },
  { "musicgamegalaxy.de", true },
  { "mutamatic.com", true },
  { "mutantmonkey.in", true },
  { "mutantmonkey.info", true },
  { "mutantmonkey.sexy", true },
  { "mvno.io", true },
  { "mwe.st", true },
  { "my.onlime.ch", false },
  { "my.usa.gov", true },
  { "my.xero.com", false },
  { "mygadgetguardian.lookout.com", false },
  { "mylookout.com", false },
  { "myni.io", true },
  { "mynigma.org", true },
  { "myplaceonline.com", true },
  { "myvirtualserver.com", true },
  { "nachsenden.info", true },
  { "nameid.org", true },
  { "namepros.com", true },
  { "narodniki.com", true },
  { "nectarleaf.com", true },
  { "neg9.org", false },
  { "neilwynne.com", false },
  { "neko.li", true },
  { "net-safe.info", true },
  { "netera.se", true },
  { "netrider.net.au", true },
  { "netzbit.de", true },
  { "netztest.at", true },
  { "newstarnootropics.com", true },
  { "ng-security.com", true },
  { "nginxnudes.com", true },
  { "nieselregen.com", true },
  { "niloxy.com", true },
  { "nmctest.net", true },
  { "noobs-r-us.co.uk", true },
  { "nos-oignons.net", true },
  { "notalone.gov", true },
  { "nouvelle-vague-saint-cast.fr", true },
  { "nowhere.dk", true },
  { "npw.net", true },
  { "nu3.at", true },
  { "nu3.ch", true },
  { "nu3.co.uk", true },
  { "nu3.com", true },
  { "nu3.de", true },
  { "nu3.dk", true },
  { "nu3.fi", true },
  { "nu3.fr", true },
  { "nu3.no", true },
  { "nu3.se", true },
  { "null-sec.ru", true },
  { "nutsandboltsmedia.com", false },
  { "nwgh.org", true },
  { "nymphetomania.net", true },
  { "oakslighting.co.uk", true },
  { "offshore-firma.org", true },
  { "okmx.de", true },
  { "omitech.co.uk", true },
  { "onedot.nl", true },
  { "onedrive.com", true },
  { "onedrive.live.com", false },
  { "onsitemassageco.com", true },
  { "ooonja.de", true },
  { "openacademies.com", true },
  { "opendesk.cc", true },
  { "oplop.appspot.com", true },
  { "opsmate.com", false },
  { "optimus.io", true },
  { "orbograph-hrcm.com", true },
  { "oscarvk.ch", true },
  { "osterkraenzchen.de", true },
  { "otakuworld.de", true },
  { "ouvirmusica.com.br", true },
  { "ovenapp.io", true },
  { "oversight.io", true },
  { "p.linode.com", false },
  { "packagist.org", false },
  { "pajonzeck.de", true },
  { "palava.tv", true },
  { "parent5446.us", true },
  { "partyvan.eu", true },
  { "partyvan.it", true },
  { "partyvan.nl", true },
  { "partyvan.se", true },
  { "passport.yandex.by", true },
  { "passport.yandex.com", true },
  { "passport.yandex.com.tr", true },
  { "passport.yandex.kz", true },
  { "passport.yandex.ru", true },
  { "passport.yandex.ua", true },
  { "passwd.io", true },
  { "password.codes", true },
  { "passwords.google.com", true },
  { "paste.linode.com", false },
  { "pastebin.linode.com", false },
  { "patt.us", true },
  { "pauladamsmith.com", true },
  { "pay.gigahost.dk", true },
  { "paymentaccuracy.gov", true },
  { "paymill.com", true },
  { "paymill.de", true },
  { "paypal.com", false },
  { "payroll.xero.com", false },
  { "pdf.yt", true },
  { "peercraft.com", true },
  { "pentesterlab.com", true },
  { "perfectionis.me", true },
  { "personaldatabasen.no", true },
  { "pestici.de", true },
  { "pharmaboard.de", true },
  { "phoenix.dj", true },
  { "phoenixlogan.com", true },
  { "phryanjr.com", false },
  { "phurl.de", true },
  { "picksin.club", true },
  { "pieperhome.de", true },
  { "pierre-schmitz.com", true },
  { "pixel.facebook.com", false },
  { "pixi.me", true },
  { "play.google.com", true },
  { "plothost.com", true },
  { "plus.google.com", false },
  { "plus.sandbox.google.com", false },
  { "pmg-offshore-company.com", true },
  { "pmg-purchase.com", true },
  { "pmg-purchase.net", true },
  { "polymathematician.com", true },
  { "polypho.nyc", true },
  { "portal.tirol.gv.at", true },
  { "posteo.de", false },
  { "powerplannerapp.com", true },
  { "prakharprasad.com", true },
  { "prefontaine.name", true },
  { "privategiant.com", true },
  { "profiles.google.com", true },
  { "progressiveplanning.com", true },
  { "projektzentrisch.de", true },
  { "propagandism.org", true },
  { "prowhisky.de", true },
  { "proximato.com", true },
  { "puac.de", true },
  { "pubkey.is", true },
  { "publications.qld.gov.au", false },
  { "puiterwijk.org", true },
  { "pult.co", false },
  { "pwd.ovh", true },
  { "pypa.io", true },
  { "pypi.python.org", true },
  { "python.org", false },
  { "qa.fedoraproject.org", true },
  { "qa.stg.fedoraproject.org", true },
  { "qetesh.de", true },
  { "quuz.org", true },
  { "r3s1stanc3.me", true },
  { "rad-route.de", true },
  { "rafaelcz.de", true },
  { "ragingserenity.com", true },
  { "raiseyourflag.com", true },
  { "rasing.me", true },
  { "raspass.me", true },
  { "ravchat.com", true },
  { "redirect.fedoraproject.org", true },
  { "redirect.stg.fedoraproject.org", true },
  { "redletter.link", true },
  { "redports.org", true },
  { "redteam-pentesting.de", true },
  { "reedloden.com", true },
  { "reg.ru", true },
  { "reishunger.de", true },
  { "release-monitoring.org", true },
  { "reliable-mail.de", true },
  { "research.facebook.com", false },
  { "reserve-online.net", true },
  { "residentsinsurance.co.uk", true },
  { "reviews.anime.my", true },
  { "riccy.org", true },
  { "riesenmagnete.de", true },
  { "rika.me", true },
  { "rippleunion.com", true },
  { "rlalique.com", true },
  { "roland.io", true },
  { "romab.com", true },
  { "romans-place.me.uk", true },
  { "romulusapp.com", true },
  { "room-checkin24.de", true },
  { "rosenkeller.org", true },
  { "roundcube.mayfirst.org", false },
  { "ru-sprachstudio.ch", true },
  { "rudloff.pro", true },
  { "ruudkoot.nl", true },
  { "rws-vertriebsportal.de", true },
  { "s-c.se", true },
  { "saintsrobotics.com", true },
  { "sakaki.anime.my", true },
  { "salaervergleich.com", true },
  { "sale4ru.ru", true },
  { "salserocafe.com", true },
  { "samba.org", true },
  { "samizdat.cz", true },
  { "samuelkeeley.com", true },
  { "sanatfilan.com", false },
  { "sandbox.mydigipass.com", false },
  { "save.gov", true },
  { "saveaward.gov", true },
  { "savetheinternet.eu", true },
  { "savvytime.com", true },
  { "schachburg.de", true },
  { "schokokeks.org", false },
  { "schreiber-netzwerk.eu", true },
  { "schwarzer.it", true },
  { "sciencex.com", true },
  { "scotthelme.co.uk", true },
  { "scrambl.is", true },
  { "scrambler.in", false },
  { "scribe.systems", true },
  { "script.google.com", true },
  { "sdsl-speedtest.de", true },
  { "secure.facebook.com", false },
  { "securesuisse.ch", true },
  { "securify.nl", true },
  { "security-carpet.com", true },
  { "security.google.com", true },
  { "securityheaders.com", true },
  { "secuvera.de", true },
  { "seifried.org", true },
  { "servergno.me", true },
  { "servethecity-karlsruhe.de", true },
  { "shaaaaaaaaaaaaa.com", true },
  { "shakepeers.org", true },
  { "shellsec.pw", true },
  { "shenyuqi.com", true },
  { "sherbers.de", true },
  { "shiinko.com", false },
  { "shipard.com", true },
  { "shodan.io", true },
  { "shopontarget.com", true },
  { "shortdiary.me", true },
  { "sikayetvar.com", true },
  { "silentcircle.com", false },
  { "simbolo.co.uk", false },
  { "simple.com", false },
  { "simpletax.ca", false },
  { "simplia.cz", true },
  { "simplystudio.com", true },
  { "siraweb.org", true },
  { "siriad.com", true },
  { "sites.google.com", true },
  { "sitesten.com", true },
  { "sjoorm.com", true },
  { "skogsbruket.fi", true },
  { "skogskultur.fi", true },
  { "skydrive.live.com", false },
  { "slack.com", true },
  { "slattery.co", true },
  { "slevomat.cz", true },
  { "slidebatch.com", true },
  { "smartcleaningcenter.nl", true },
  { "smartcoin.com.br", true },
  { "smartlend.se", true },
  { "smartship.co.jp", true },
  { "snakehosting.dk", true },
  { "sorz.org", true },
  { "sour.is", true },
  { "southside-crew.com", true },
  { "souvik.me", true },
  { "spartantheatre.org", true },
  { "spawn.cz", true },
  { "spencerbaer.com", true },
  { "spideroak.com", true },
  { "spongepowered.org", true },
  { "spreadsheets.google.com", true },
  { "spreed.me", true },
  { "sprueche-zum-valentinstag.de", true },
  { "sprueche-zur-geburt.info", true },
  { "sprueche-zur-hochzeit.de", true },
  { "sprueche-zur-konfirmation.de", true },
  { "squareup.com", false },
  { "srevilak.net", true },
  { "sro.center", true },
  { "ssl.google-analytics.com", true },
  { "sslmate.com", true },
  { "stage.wepay.com", false },
  { "standardssuck.org", true },
  { "static.wepay.com", false },
  { "staticanime.net", false },
  { "stationary-traveller.eu", true },
  { "steventress.com", true },
  { "stocktrade.de", false },
  { "strasweb.fr", false },
  { "stretchmyan.us", true },
  { "stripe.com", true },
  { "strongest-privacy.com", true },
  { "studienportal.eu", true },
  { "studydrive.net", true },
  { "stulda.cz", true },
  { "subrosa.io", true },
  { "suite73.org", true },
  { "sunjaydhama.com", true },
  { "supplies24.at", true },
  { "supplies24.es", true },
  { "support.mayfirst.org", false },
  { "surkatty.org", true },
  { "survivalmonkey.com", true },
  { "swehack.org", false },
  { "sychov.pro", true },
  { "sylaps.com", true },
  { "sysctl.se", true },
  { "sysdb.io", true },
  { "syss.de", true },
  { "tadigitalstore.com", true },
  { "tageau.com", true },
  { "talk.google.com", true },
  { "talkgadget.google.com", true },
  { "tallshoe.com", true },
  { "tapka.cz", true },
  { "tas2580.net", true },
  { "taskotron.fedoraproject.org", true },
  { "taskotron.stg.fedoraproject.org", true },
  { "tatort-fanpage.de", true },
  { "tauchkater.de", true },
  { "tbspace.de", true },
  { "techhipster.net", true },
  { "tegelsensanitaironline.nl", true },
  { "tekshrek.com", true },
  { "tent.io", true },
  { "terrty.net", true },
  { "testsuite.org", true },
  { "texte-zur-taufe.de", true },
  { "thebimhub.com", true },
  { "thecustomizewindows.com", true },
  { "thepaymentscompany.com", true },
  { "therapynotes.com", false },
  { "theshadestore.com", true },
  { "thetomharling.com", true },
  { "thomastimepieces.com.au", true },
  { "thorncreek.net", false },
  { "thusoy.com", true },
  { "thyngster.com", true },
  { "tickopa.co.uk", true },
  { "tid.jp", true },
  { "timtaubert.de", true },
  { "tinfoilsecurity.com", false },
  { "tinte24.de", true },
  { "tintenfix.net", true },
  { "tipps-fuer-den-haushalt.de", true },
  { "tittelbach.at", true },
  { "tls.li", true },
  { "tmtopup.com", true },
  { "tno.io", true },
  { "tobias-kluge.de", true },
  { "todesschaf.org", true },
  { "tollmanz.com", true },
  { "tomfisher.eu", true },
  { "tomvote.com", true },
  { "toner24.at", true },
  { "toner24.co.uk", true },
  { "toner24.es", true },
  { "toner24.fr", true },
  { "toner24.it", true },
  { "toner24.nl", true },
  { "toner24.pl", true },
  { "tonerdepot.de", true },
  { "tonerjet.at", true },
  { "tonerjet.co.uk", true },
  { "tonerklick.de", true },
  { "tonerkurier.de", true },
  { "tonermaus.de", true },
  { "tonermonster.de", true },
  { "tonex.de", true },
  { "tonex.nl", true },
  { "tonywebster.com", true },
  { "topodin.com", true },
  { "tor2web.org", true },
  { "torproject.org", false },
  { "toshnix.com", true },
  { "touch.facebook.com", false },
  { "touch.mail.ru", true },
  { "tracktivity.com.au", true },
  { "translate.fedoraproject.org", true },
  { "translate.googleapis.com", true },
  { "translate.stg.fedoraproject.org", true },
  { "trauertexte.info", true },
  { "tresorit.com", true },
  { "tribut.de", true },
  { "tucuxi.org", true },
  { "tunebitfm.de", true },
  { "twisto.cz", true },
  { "twitter.com", false },
  { "twitteroauth.com", true },
  { "typingrevolution.com", true },
  { "uae-company-service.com", true },
  { "ub3rk1tten.com", true },
  { "ubertt.org", true },
  { "ukdefencejournal.org.uk", true },
  { "ukhas.net", true },
  { "ukrainians.ch", true },
  { "unison.com", true },
  { "unterfrankenclan.de", true },
  { "uonstaffhub.com", true },
  { "upload.facebook.com", false },
  { "uptrends.com", true },
  { "usaa.com", false },
  { "uspsoig.gov", true },
  { "vaddder.com", true },
  { "vhost.co.id", true },
  { "viasinc.com", false },
  { "visionless.me", false },
  { "vitrado.de", true },
  { "vmoagents.com", false },
  { "vocaloid.my", true },
  { "vortexhobbies.com", true },
  { "vpnzoom.com", true },
  { "vrobert.fr", false },
  { "w-spotlight.appspot.com", true },
  { "wallet.google.com", true },
  { "warrencreative.com", false },
  { "watsonhall.uk", true },
  { "wbg-vs.de", true },
  { "webandmore.de", false },
  { "webandwords.com.au", true },
  { "webassadors.com", false },
  { "webcollect.org.uk", true },
  { "webfilings-eu-mirror.appspot.com", true },
  { "webfilings-eu.appspot.com", true },
  { "webfilings-mirror-hrd.appspot.com", true },
  { "webfilings.appspot.com", true },
  { "weblogzwolle.nl", true },
  { "webmail.gigahost.dk", false },
  { "webmail.onlime.ch", false },
  { "webmail.schokokeks.org", false },
  { "websenat.de", true },
  { "webtalis.nl", true },
  { "webtiles.co.uk", true },
  { "webtrh.cz", true },
  { "weggeweest.nl", true },
  { "welches-kinderfahrrad.de", true },
  { "wepay.com", false },
  { "wepay.in.th", true },
  { "wevahoo.com", true },
  { "wf-bigsky-master.appspot.com", true },
  { "wf-demo-eu.appspot.com", true },
  { "wf-demo-hrd.appspot.com", true },
  { "wf-dogfood-hrd.appspot.com", true },
  { "wf-pentest.appspot.com", true },
  { "wf-staging-hr.appspot.com", true },
  { "wf-training-hrd.appspot.com", true },
  { "wf-training-master.appspot.com", true },
  { "wf-trial-hrd.appspot.com", true },
  { "whatwg.org", true },
  { "whd-guide.de", true },
  { "when-release.ru", true },
  { "wherephoto.com", true },
  { "whocalld.com", true },
  { "wieninternational.at", true },
  { "wiki.python.org", true },
  { "wildbee.org", true },
  { "willnorris.com", true },
  { "wills.co.tt", true },
  { "winhistory-forum.net", true },
  { "wondershift.biz", true },
  { "wootton95.com", true },
  { "wpletter.de", true },
  { "writeapp.me", false },
  { "wubthecaptain.eu", true },
  { "wunderlist.com", true },
  { "wundi.net", true },
  { "www.aclu.org", false },
  { "www.airbnb.com", true },
  { "www.apollo-auto.com", true },
  { "www.banking.co.at", false },
  { "www.braintreepayments.com", false },
  { "www.capitainetrain.com", false },
  { "www.cyveillance.com", true },
  { "www.dropbox.com", true },
  { "www.dropcam.com", false },
  { "www.entropia.de", false },
  { "www.eternalgoth.co.uk", true },
  { "www.etsy.com", true },
  { "www.evernote.com", false },
  { "www.facebook.com", false },
  { "www.gamesdepartment.co.uk", false },
  { "www.getcloak.com", false },
  { "www.gmail.com", false },
  { "www.googlemail.com", false },
  { "www.gov.uk", false },
  { "www.grc.com", true },
  { "www.heliosnet.com", true },
  { "www.honeybadger.io", false },
  { "www.intercom.io", false },
  { "www.irccloud.com", false },
  { "www.lastpass.com", false },
  { "www.ledgerscope.net", false },
  { "www.linode.com", false },
  { "www.lookout.com", false },
  { "www.makeyourlaws.org", true },
  { "www.mydigipass.com", false },
  { "www.mylookout.com", false },
  { "www.noisebridge.net", false },
  { "www.opsmate.com", true },
  { "www.paypal.com", false },
  { "www.python.org", true },
  { "www.roddis.net", true },
  { "www.schokokeks.org", false },
  { "www.simbolo.co.uk", false },
  { "www.simple.com", false },
  { "www.therapynotes.com", false },
  { "www.tinfoilsecurity.com", false },
  { "www.torproject.org", false },
  { "www.twitter.com", false },
  { "www.usaa.com", false },
  { "www.viasinc.com", true },
  { "www.wepay.com", false },
  { "www.zenpayroll.com", false },
  { "wzrd.in", true },
  { "xbrlsuccess.appspot.com", true },
  { "xn--maraa-rta.org", true },
  { "xps2pdf.co.uk", true },
  { "xuntier.ch", true },
  { "y-o-w.com", true },
  { "yahvehyireh.com", true },
  { "yanovich.net", true },
  { "yaporn.tv", false },
  { "yetii.net", true },
  { "yorcom.nl", true },
  { "yoursecondphone.co", true },
  { "ypart.eu", true },
  { "z.ai", true },
  { "zenpayroll.com", false },
  { "zentralwolke.de", true },
  { "zeplin.io", false },
  { "zeropush.com", true },
  { "zhovner.com", false },
  { "zixiao.wang", true },
  { "zlavomat.sk", true },
};
