<?
	/**
	 * Create the images for the Firefox Javascript console in the specified
	 * directory.
	 */
	function createConsole($dir) {
		renderConsole($dir.'console-toolbar.png', 24);
		
		renderBullets($dir, 16);
	}
	
	/**
	 * Render the complete image to a given file.
	 *
	 * The columns are:
	 * All (console), Information, Warning, Error, Clear
	 *
	 * The rows are:
	 * Normal, Hover
	 */
	function renderConsole($filename, $size) {
		// define the icons to render
		$icons = array(
			array(APPS, 'utilities-terminal'),
			array(STATUS, 'dialog-information'),
			array(STATUS, 'dialog-warning'),
			array(STATUS, 'dialog-error'),
			array(ACTIONS, 'edit-clear')
		);
		
		// compose the first rows of the toolbar
		$firstrow = renderRow($icons, $size);
		$highlight = renderHighlight($firstrow);
		
		// create single PNG containing all states
		$states = array($firstrow, $highlight);
		$console =
			renderColumnFromPngs(
				$states, count($icons) * $size, $size);
		copy($console, $filename);
	}
	
	/**
	 * Render the JavaScript console bullets.
	 */
	function renderBullets($dir, $size) {
		$info = getPngFilenameFor(STATUS, 'dialog-information', 16);
		copy($info, $dir.'bullet-question.png');

		$warning = getPngFilenameFor(STATUS, 'dialog-warning', 16);
		copy($warning, $dir.'bullet-warning.png');

		$error = getPngFilenameFor(STATUS, 'dialog-error', 16);
		copy($error, $dir.'bullet-error.png');
	}
	
?>