<?
	/**
	 * Create the images for the Firefox go button in the specified
	 * directory.
	 */
	function createGoButton($dir) {
		renderGo($dir.'Go.png', 20);
		renderGo($dir.'Go-rtl.png', 20, true);
	}
	
	/**
	 * Render the go button with optional Right-To-Left rendering.
	 */
	function renderGo($filename, $netsize, $rtl = false) {
		// add two pixel border around the image
		$size = $netsize - 4;
		
		$original = getPngFilenameFor(ACTIONS, 'go-jump', $size);
		if($rtl) {
			$original = flipHorizontal($original);
		}
		
		$gojump = renderBorder($original, $size, 2);
		$highlight = renderHighlight($gojump);
		$disabled = renderDisabled($gojump);
		
		$states = array($gojump, $highlight, $disabled);
		
		$gobutton = renderRowFromPngs($states, $netsize);
		copy($gobutton, $filename);
	}
	
?>