#include <stdio.h>

#include "e-cal-glue-comp.h"

static void e_cal_glue_component_class_init (ECalGlueComponentClass *klass);
static void e_cal_glue_component_init (ECalGlueComponent *comp, ECalGlueComponentClass *klass);
static void e_cal_glue_component_finalize (GObject *object);

static GObjectClass *parent_class;

/**
 * e_cal_glue_component_get_type:
 *
 * Registers the #ECalGlueComponent class if necessary, and returns the type ID
 * associated to it.
 *
 * Return value: The type ID of the #ECalGlueComponent class.
 **/
GType
e_cal_glue_component_get_type (void)
{
  static GType e_cal_glue_component_type = 0;

  if (!e_cal_glue_component_type) {
    static GTypeInfo info = {
      sizeof (ECalGlueComponentClass),
      (GBaseInitFunc) NULL,
      (GBaseFinalizeFunc) NULL,
      (GClassInitFunc) e_cal_glue_component_class_init,
      NULL, NULL,
      sizeof (ECalGlueComponent),
      0,
      (GInstanceInitFunc) e_cal_glue_component_init
    };
    e_cal_glue_component_type = g_type_register_static (G_TYPE_OBJECT, "ECalGlueComponent", &info, 0);
  }

  return e_cal_glue_component_type;
}

/* Class initialization function for the calendar-glue object */
static void
e_cal_glue_component_class_init (ECalGlueComponentClass *klass)
{
  GObjectClass *object_class;

  object_class = (GObjectClass *) klass;

  parent_class = g_type_class_peek_parent (klass);

  object_class->finalize = e_cal_glue_component_finalize;
}

/* Object initialization function for the calendar-glue object */
static void
e_cal_glue_component_init (ECalGlueComponent *comp, ECalGlueComponentClass *klass)
{
  comp->uid = NULL;
  comp->recur_id = NULL;
  comp->attendee_list = NULL;
  comp->category_list = NULL;
  comp->comment_list = NULL;
  comp->location_list = NULL;
  comp->summary_list = NULL;
  comp->desc_list = NULL;
  comp->dtstart = 0;
  comp->dtend = 0;
  comp->last_modified_date = 0;
  comp->dtstamp = 0;
  comp->created = 0;
  comp->has_recurrence = FALSE;
  comp->rrule_list = NULL;
  comp->exrule_list = NULL;
}

/**
 * e_cal_glue_component_new:
 *
 * Creates a new empty calendar-glue component object.  
 *
 * Return value: A newly-created calendar-glue component object.
 **/
ECalGlueComponent *
e_cal_glue_component_new (void)
{
  return E_CAL_GLUE_COMPONENT (g_object_new (E_TYPE_CAL_GLUE_COMPONENT, NULL));
}

/* Finalize handler for the calendar-glue component object */
static void
e_cal_glue_component_finalize (GObject *object)
{
  ECalGlueComponent *comp;

  g_return_if_fail (object != NULL);
  g_return_if_fail (E_IS_CAL_GLUE_COMPONENT (object));

  comp = E_CAL_GLUE_COMPONENT (object);
  
  if (comp->attendee_list) {
    g_slist_foreach (comp->attendee_list, (GFunc)g_free, NULL);
    g_slist_free (comp->attendee_list);
  }

  if (comp->category_list) {
    g_slist_foreach (comp->category_list, (GFunc)g_free, NULL);
    g_slist_free (comp->category_list);
  }

  if (comp->comment_list) {
    g_slist_foreach (comp->comment_list, (GFunc)g_free, NULL);
    g_slist_free (comp->comment_list);
  }

  if (comp->location_list) {
    g_slist_foreach (comp->location_list, (GFunc)g_free, NULL);
    g_slist_free (comp->location_list);
  }

  if (comp->summary_list) {
    g_slist_foreach (comp->summary_list, (GFunc)g_free, NULL);
    g_slist_free (comp->summary_list);
  }

  if (comp->desc_list) {
    g_slist_foreach (comp->desc_list, (GFunc)g_free, NULL);
    g_slist_free (comp->desc_list);
  }

  if (comp->uid)
    g_free (comp->uid);
  
  if (comp->recur_id)
    g_free (comp->recur_id);

  if (comp->rrule_list) {
    g_slist_foreach (comp->rrule_list, (GFunc)g_free, NULL);
    g_slist_free (comp->rrule_list);
  }

  if (comp->exrule_list) {
    g_slist_foreach (comp->exrule_list, (GFunc)g_free, NULL);
    g_slist_free (comp->exrule_list);
  }

  comp->attendee_list = NULL;
  comp->recur_id = NULL;
  comp->uid = NULL;
  comp->category_list = NULL;
  comp->comment_list = NULL;
  comp->location_list = NULL;
  comp->summary_list = NULL;
  comp->desc_list = NULL;
  comp->dtstart = 0;
  comp->dtend = 0;
  comp->last_modified_date = 0;
  comp->rrule_list = NULL;
  comp->exrule_list = NULL;

  if (G_OBJECT_CLASS (parent_class)->finalize)
    (* G_OBJECT_CLASS (parent_class)->finalize) (object);
}

void
e_cal_glue_component_set_uid (ECalGlueComponent* comp, const char* uid)
{
  g_return_if_fail (comp != NULL);
  g_return_if_fail (uid != NULL);
  
  comp->uid = g_strdup (uid);
}

void
e_cal_glue_component_set_recur_id (ECalGlueComponent* comp, const char* recur_id)
{
  g_return_if_fail (comp != NULL);
  
  comp->recur_id = g_strdup (recur_id);
}

void
e_cal_glue_component_set_attendees (ECalGlueComponent* comp, GSList* l)
{
  g_return_if_fail (comp != NULL);
  g_return_if_fail (l != NULL);
  
  comp->attendee_list = l;
}

void
e_cal_glue_component_set_comments (ECalGlueComponent* comp, GSList* l)
{
  g_return_if_fail (comp != NULL);
  g_return_if_fail (l != NULL);
  
  comp->comment_list = l;
}

void
e_cal_glue_component_set_descriptions (ECalGlueComponent* comp, GSList* l)
{
  g_return_if_fail (comp != NULL);
  g_return_if_fail (l != NULL);
  
  comp->desc_list = l;
}

void
e_cal_glue_component_set_location (ECalGlueComponent* comp, GSList* l)
{
  g_return_if_fail (comp != NULL);
  g_return_if_fail (l != NULL);
  
  comp->location_list = l;
}

void
e_cal_glue_component_set_summaries (ECalGlueComponent* comp, GSList* l)
{
  g_return_if_fail (comp != NULL);
  g_return_if_fail (l != NULL);
  
  comp->summary_list = l;
}

void
e_cal_glue_component_set_categories (ECalGlueComponent* comp, GSList* l)
{
  g_return_if_fail (comp != NULL);
  g_return_if_fail (l != NULL);
  
  comp->category_list = l;
}

void
e_cal_glue_component_set_dtstart (ECalGlueComponent* comp, time_t start)
{
  g_return_if_fail (comp != NULL);
  
  comp->dtstart = start;
}


void
e_cal_glue_component_set_dtend (ECalGlueComponent* comp, time_t end)
{
  g_return_if_fail (comp != NULL);
  
  comp->dtend = end;
}

void
e_cal_glue_component_set_last_modified_date (ECalGlueComponent* comp, 
					     time_t last_modified_date)
{
  g_return_if_fail (comp != NULL);
  
  comp->last_modified_date = last_modified_date;
}

void
e_cal_glue_component_set_dtstamp (ECalGlueComponent* comp, 
				  time_t dtstamp)
{
  g_return_if_fail (comp != NULL);
  
  comp->dtstamp = dtstamp;
}


void
e_cal_glue_component_set_created (ECalGlueComponent* comp, 
				  time_t created)
{
  g_return_if_fail (comp != NULL);
  
  comp->created = created;
}

void
e_cal_glue_component_set_has_recurrences (ECalGlueComponent* comp, gboolean has_recurrence)
{
  g_return_if_fail (comp != NULL);
  
  comp->has_recurrence = has_recurrence;
}

void
e_cal_glue_component_set_rrule_list (ECalGlueComponent* comp, GSList* rrule_list)
{
  g_return_if_fail (comp != NULL);
  comp->rrule_list = rrule_list;
}

void
e_cal_glue_component_set_exrule_list (ECalGlueComponent* comp, GSList* exrule_list)
{
  g_return_if_fail (comp != NULL);
  comp->exrule_list = exrule_list;
}

/* Caller has to free the memory */
char*
e_cal_glue_component_get_uid (ECalGlueComponent* comp)
{
  g_return_val_if_fail (comp != NULL, NULL);
  return g_strdup (comp->uid);
}

/* Caller has to free the memory */
char*
e_cal_glue_component_get_recur_id (ECalGlueComponent* comp)
{
  g_return_val_if_fail (comp != NULL, NULL);
  return g_strdup (comp->recur_id);
}

GSList*
e_cal_glue_component_get_attendees (ECalGlueComponent* comp)
{
  g_return_val_if_fail (comp != NULL, NULL);
  return comp->attendee_list;
}

GSList*
e_cal_glue_component_get_comments (ECalGlueComponent* comp)
{
  g_return_val_if_fail (comp != NULL, NULL);
  return comp->comment_list;
}

GSList*
e_cal_glue_component_get_descriptions (ECalGlueComponent* comp)
{
  g_return_val_if_fail (comp != NULL, NULL);
  return comp->desc_list;
}

GSList*
e_cal_glue_component_get_location (ECalGlueComponent* comp)
{
  g_return_val_if_fail (comp != NULL, NULL);
  return comp->location_list;
}

GSList*
e_cal_glue_component_get_summaries (ECalGlueComponent* comp)
{
  g_return_val_if_fail (comp != NULL, NULL);
  return comp->summary_list;
}

GSList*
e_cal_glue_component_get_categories (ECalGlueComponent* comp)
{
  g_return_val_if_fail (comp != NULL, NULL);
  return comp->category_list;
}

time_t
e_cal_glue_component_get_dtstart (ECalGlueComponent* comp)
{
  g_return_val_if_fail (comp != NULL, 0);
  return comp->dtstart;
}

time_t
e_cal_glue_component_get_dtend (ECalGlueComponent* comp)
{
  g_return_val_if_fail (comp != NULL, 0);
  return comp->dtend;
}

time_t
e_cal_glue_component_get_last_modified_date (ECalGlueComponent* comp)
{
  g_return_val_if_fail (comp != NULL, 0);
  return comp->last_modified_date;
}

time_t
e_cal_glue_component_get_dtstamp (ECalGlueComponent* comp)
{
  g_return_val_if_fail (comp != NULL, 0);
  return comp->dtstamp;
}

time_t
e_cal_glue_component_get_created (ECalGlueComponent* comp)
{
  g_return_val_if_fail (comp != NULL, 0);
  return comp->created;
}

gboolean
e_cal_glue_component_get_has_recurrences (ECalGlueComponent* comp)
{
  g_return_val_if_fail (comp != NULL, FALSE);
  
  return comp->has_recurrence;
}

GSList* 
e_cal_glue_component_get_rrule_list (ECalGlueComponent* comp)
{
  g_return_val_if_fail (comp != NULL, NULL);

  return comp->rrule_list;
}

GSList* 
e_cal_glue_component_get_exrule_list (ECalGlueComponent* comp)
{
  g_return_val_if_fail (comp != NULL, NULL);

  return comp->exrule_list;
}
