/* -*- C++ -*- */
#ifndef TESTUI_APP_H
#define TESTUI_APP_H

#include <kmainwindow.h>
#include <kparts/part.h>
#include <kactionclasses.h>
#include <apt-front/cache/observer.h>
#include <apt-front/cache/component/state.h>
#include <apt-front/cache/component/history.h>
#include <libept/view.h>
#include <libept/commitprogress.h>
#include <libept/application.h>

class QVBox;
class QWidgetStack;
class QSplitter;
class KAction;
class KPushButton;
namespace ept {
class AcqProgressWidget;
}

using namespace aptFront;
using namespace ept;

class TestApp : public KMainWindow, Application {
    Q_OBJECT
public:
    void setupActions();
    ExtTerminalInterface *terminal();
	TestApp();
protected slots:
    void start();
    void update();
    void commit();

    void delayed();

    void undo() { Application::undo(); }
    void redo() { Application::redo(); }
    void checkpoint() { Application::checkpoint(); }

    void setHistoryEnabled( bool );

    void disableNext();
    void disableButtons();
    void setNext( QString str, const char *slot );
protected:
    friend class WaitForLister;

    virtual void notifyPostChange( cache::component::Base * );
    virtual void notifyPreChange( cache::component::Base * );

    QWidgetStack *m_stack;
    QVBox *m_all;
    QHBox *m_buttons;
    QLabel *m_start;
    QLabel *m_bye;
    KPushButton *m_next, *m_quit;

    // stacked widgets
    ept::AcqProgressWidget *m_progress;
    ept::CommitProgress *m_commitProgress;
    ept::Browser *m_list;

    // other stuff
    std::vector<KAction *> m_actions;
    QMap< QString, QString > m_icons;
    KAction *m_undo, *m_redo;
    cache::component::History< cache::component::State > *m_history;
};

class WaitForLister : public QObject {
    Q_OBJECT
public:
    WaitForLister( TestApp *a, const char *s )
        : app( a ), slot( s )
        {
            waiting();
        }
protected slots:
    void waiting();
protected:
    TestApp *app;
    const char *slot;
    
};

#endif
