#include <apt-front/predicate/combinators.h>
#include <apt-front/predicate/factory.h>
#include <klocale.h>
#include <klineedit.h>
#include "filterwidget.h"

using namespace aptFront;
using namespace ept;

void FilterWidget::connectLister( Lister *l ) {
    connect( this, SIGNAL( drop( ListerPredicate ) ),
             l, SLOT( interactiveDrop( ListerPredicate ) ) );
    connect( this, SIGNAL( changed( ListerPredicate ) ),
             l, SLOT( interactiveAnd( ListerPredicate ) ) );
    connect( this, SIGNAL( apply( ListerPredicate ) ),
             l, SLOT( baseAnd( ListerPredicate ) ) );

}

void FilterWidget::changedInternal() {
    setEnabled( false );
    emit drop( m_old );
    emit changed( m_old = predicate() );
    setEnabled( true );
    setFocus();
}

void FilterWidget::applyInternal() {
    // check for emptiness?
    setEnabled( false );
    emit drop( m_old );
    emit apply( m_old = predicate() );
    reset();
    setEnabled( true );
    setFocus();
}
